/*
 * Decompiled with CFR 0.152.
 */
package cn.zoecloud.core.auth;

import cn.zoecloud.core.auth.Credential;
import cn.zoecloud.core.auth.CredentialProvider;
import cn.zoecloud.core.auth.DefaultCredential;
import cn.zoecloud.core.auth.InvalidCredentialException;
import org.apache.commons.lang3.StringUtils;

public class DefaultCredentialProvider
implements CredentialProvider {
    private volatile Credential credential;

    public DefaultCredentialProvider(Credential credential) {
        this.setCredential(credential);
    }

    public DefaultCredentialProvider(String appKey, String appSecret) {
        this.setCredential(new DefaultCredential(appKey, appSecret));
    }

    @Override
    public synchronized void setCredential(Credential credential) {
        if (credential == null) {
            throw new InvalidCredentialException("credential should not be null.");
        }
        DefaultCredentialProvider.checkCredentials(credential.getAppKey(), credential.getAppSecret());
        this.credential = credential;
    }

    @Override
    public Credential getCredential() {
        if (this.credential == null) {
            throw new InvalidCredentialException("Invalid credential");
        }
        return this.credential;
    }

    private static void checkCredentials(String appKey, String appSecret) {
        if (StringUtils.isBlank((CharSequence)appKey)) {
            throw new InvalidCredentialException("App key should not be null or empty.");
        }
        if (StringUtils.isBlank((CharSequence)appSecret)) {
            throw new InvalidCredentialException("App secret should not be null or empty.");
        }
    }
}

