/*
 * Decompiled with CFR 0.152.
 */
package cn.zoecloud.core.auth;

import cn.zoecloud.core.auth.Credential;
import cn.zoecloud.core.auth.RequestSigner;
import cn.zoecloud.core.service.RequestMessage;
import cn.zoecloud.core.util.HttpUtil;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.codec.digest.HmacAlgorithms;
import org.apache.commons.codec.digest.HmacUtils;
import org.apache.commons.lang3.StringUtils;

public class DefaultRequestSigner
implements RequestSigner {
    private String contentPath;
    private String appKey;
    private String appSecret;

    public DefaultRequestSigner(Credential credential) {
        this(credential, "");
    }

    public DefaultRequestSigner(Credential credential, String contentPath) {
        this.contentPath = contentPath;
        if (credential != null) {
            this.appKey = credential.getAppKey();
            this.appSecret = credential.getAppSecret();
        }
    }

    @Override
    public void sign(RequestMessage request) {
        if (StringUtils.isBlank((CharSequence)this.appKey) || StringUtils.isBlank((CharSequence)this.appSecret)) {
            return;
        }
        HmacUtils hmacUtils = new HmacUtils(HmacAlgorithms.HMAC_MD5, this.appSecret);
        String appKey = this.appKey;
        String timestamp = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSZ").format(new Date());
        String text = appKey + "," + timestamp;
        String uri = request.getMethod().toString() + this.contentPath + request.getResourcePath();
        String param = HttpUtil.paramToQueryString(request.getParameters(), "utf-8");
        param = StringUtils.isBlank((CharSequence)param) ? "" : "?" + param;
        String body = request.getBody();
        if (body == null) {
            body = "";
        }
        String hmac = hmacUtils.hmacHex(text + "," + uri + param + body);
        text = text + "," + hmac;
        String base64 = Base64.encodeBase64String((byte[])text.getBytes());
        String token = HttpUtil.urlEncode(base64, "utf-8");
        request.addHeader("ZH-TOKEN", token);
    }
}

