/*
 * Decompiled with CFR 0.152.
 */
package cn.zoecloud.core.service;

import cn.zoecloud.core.ClientConfiguration;
import cn.zoecloud.core.ClientException;
import cn.zoecloud.core.ServiceException;
import cn.zoecloud.core.service.HttpRequestFactory;
import cn.zoecloud.core.service.IdleConnectionReaper;
import cn.zoecloud.core.service.Protocol;
import cn.zoecloud.core.service.RequestMessage;
import cn.zoecloud.core.service.ResponseMessage;
import cn.zoecloud.core.util.LogUtil;
import java.io.IOException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import org.apache.http.HttpEntity;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.config.Registry;
import org.apache.http.config.RegistryBuilder;
import org.apache.http.config.SocketConfig;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.conn.socket.PlainConnectionSocketFactory;
import org.apache.http.conn.ssl.NoopHostnameVerifier;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.conn.ssl.TrustStrategy;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.ssl.SSLContextBuilder;
import org.apache.http.util.EntityUtils;

public class ServiceClient {
    protected static HttpRequestFactory httpRequestFactory = new HttpRequestFactory();
    private ClientConfiguration config;
    protected CloseableHttpClient httpClient;
    protected HttpClientConnectionManager connectionManager;
    protected RequestConfig requestConfig;

    public ServiceClient(ClientConfiguration config) {
        this.config = config;
        this.connectionManager = this.createHttpClientConnectionManager();
        this.httpClient = this.createHttpClient(this.connectionManager);
        RequestConfig.Builder requestConfigBuilder = RequestConfig.custom();
        requestConfigBuilder.setConnectTimeout(config.getConnectionTimeout());
        requestConfigBuilder.setSocketTimeout(config.getSocketTimeout());
        requestConfigBuilder.setConnectionRequestTimeout(config.getConnectionRequestTimeout());
        this.requestConfig = requestConfigBuilder.build();
    }

    public ResponseMessage sendRequest(RequestMessage request) throws ServiceException, ClientException {
        assert (request != null);
        try {
            return this.sendRequestCore(request);
        }
        catch (ServiceException sex) {
            LogUtil.logException("[Server]Unable to execute HTTP request: ", sex);
            throw sex;
        }
        catch (ClientException cex) {
            LogUtil.logException("[Client]Unable to execute HTTP request: ", cex);
            throw cex;
        }
        catch (Exception ex) {
            LogUtil.logException("[Unknown]Unable to execute HTTP request: ", ex);
            throw new ClientException(String.format("Connection error due to: %s", ex.getMessage()));
        }
    }

    public ResponseMessage sendRequestCore(RequestMessage request) throws IOException {
        HttpRequestBase httpRequest = httpRequestFactory.createHttpRequest(request);
        CloseableHttpResponse httpResponse = null;
        try {
            httpResponse = this.httpClient.execute((HttpUriRequest)httpRequest);
        }
        catch (IOException ex) {
            httpRequest.abort();
            throw new ClientException("Network exception", ex);
        }
        return ServiceClient.buildResponse(httpResponse);
    }

    public void shutdown() {
        IdleConnectionReaper.removeConnectionManager(this.connectionManager);
        this.connectionManager.shutdown();
    }

    private CloseableHttpClient createHttpClient(HttpClientConnectionManager connectionManager) {
        return HttpClients.custom().setConnectionManager(connectionManager).setUserAgent(this.config.getUserAgent()).disableContentCompression().build();
    }

    private HttpClientConnectionManager createHttpClientConnectionManager() {
        SSLContext sslContext = null;
        try {
            sslContext = new SSLContextBuilder().loadTrustMaterial(null, (org.apache.http.ssl.TrustStrategy)new TrustStrategy(){

                public boolean isTrusted(X509Certificate[] chain, String authType) throws CertificateException {
                    return true;
                }
            }).build();
        }
        catch (Exception e) {
            throw new ClientException(e.getMessage());
        }
        SSLConnectionSocketFactory sslSocketFactory = new SSLConnectionSocketFactory(sslContext, (HostnameVerifier)NoopHostnameVerifier.INSTANCE);
        Registry socketFactoryRegistry = RegistryBuilder.create().register(Protocol.HTTP.toString(), (Object)PlainConnectionSocketFactory.getSocketFactory()).register(Protocol.HTTPS.toString(), (Object)sslSocketFactory).build();
        PoolingHttpClientConnectionManager connectionManager = new PoolingHttpClientConnectionManager(socketFactoryRegistry);
        connectionManager.setDefaultMaxPerRoute(this.config.getMaxConnections());
        connectionManager.setMaxTotal(this.config.getMaxConnections());
        connectionManager.setValidateAfterInactivity(this.config.getValidateAfterInactivity());
        connectionManager.setDefaultSocketConfig(SocketConfig.custom().setSoTimeout(this.config.getSocketTimeout()).setTcpNoDelay(true).build());
        IdleConnectionReaper.setIdleConnectionTime(this.config.getIdleConnectionTime());
        IdleConnectionReaper.registerConnectionManager((HttpClientConnectionManager)connectionManager);
        return connectionManager;
    }

    private static ResponseMessage buildResponse(CloseableHttpResponse httpResponse) throws IOException {
        assert (httpResponse != null);
        ResponseMessage response = new ResponseMessage();
        if (httpResponse.getStatusLine() != null) {
            response.setStatusCode(httpResponse.getStatusLine().getStatusCode());
        }
        if (httpResponse.getEntity() != null) {
            response.setContent(EntityUtils.toString((HttpEntity)httpResponse.getEntity()));
        }
        return response;
    }
}

