/*
 * Decompiled with CFR 0.152.
 */
package co.datadome.api.servlet;

import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletRequestWrapper;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;

public class EnrichedHttpServletRequest
extends HttpServletRequestWrapper {
    private Map<String, String> headerMap = new HashMap<String, String>();

    public EnrichedHttpServletRequest(HttpServletRequest request) {
        super(request);
    }

    public void addHeader(String name, String value) {
        this.headerMap.put(name, value);
    }

    public String getHeader(String name) {
        if (this.headerMap.containsKey(name)) {
            return this.headerMap.get(name);
        }
        return super.getHeader(name);
    }

    public Enumeration<String> getHeaderNames() {
        if (super.getHeaderNames() == null) {
            return null;
        }
        ArrayList names = Collections.list(super.getHeaderNames());
        names.addAll(this.headerMap.keySet());
        return Collections.enumeration(names);
    }

    public Enumeration<String> getHeaders(String name) {
        Enumeration headers = super.getHeaders(name);
        if (headers == null) {
            return null;
        }
        ArrayList values = Collections.list(headers);
        if (this.headerMap.containsKey(name)) {
            values.add(this.headerMap.get(name));
        }
        return Collections.enumeration(values);
    }
}

