/*
 * Decompiled with CFR 0.152.
 */
package co.datadome.api.shaded.http.client.protocol;

import co.datadome.api.shaded.http.HttpEntity;
import co.datadome.api.shaded.http.HttpEntityEnclosingRequest;
import co.datadome.api.shaded.http.HttpException;
import co.datadome.api.shaded.http.HttpRequest;
import co.datadome.api.shaded.http.HttpRequestInterceptor;
import co.datadome.api.shaded.http.HttpVersion;
import co.datadome.api.shaded.http.ProtocolVersion;
import co.datadome.api.shaded.http.annotation.Contract;
import co.datadome.api.shaded.http.annotation.ThreadingBehavior;
import co.datadome.api.shaded.http.client.config.RequestConfig;
import co.datadome.api.shaded.http.client.protocol.HttpClientContext;
import co.datadome.api.shaded.http.protocol.HttpContext;
import co.datadome.api.shaded.http.util.Args;
import java.io.IOException;

@Contract(threading=ThreadingBehavior.IMMUTABLE)
public class RequestExpectContinue
implements HttpRequestInterceptor {
    @Override
    public void process(HttpRequest request, HttpContext context) throws HttpException, IOException {
        Args.notNull(request, "HTTP request");
        if (!request.containsHeader("Expect") && request instanceof HttpEntityEnclosingRequest) {
            HttpClientContext clientContext;
            RequestConfig config;
            ProtocolVersion ver = request.getRequestLine().getProtocolVersion();
            HttpEntity entity = ((HttpEntityEnclosingRequest)request).getEntity();
            if (entity != null && entity.getContentLength() != 0L && !ver.lessEquals(HttpVersion.HTTP_1_0) && (config = (clientContext = HttpClientContext.adapt(context)).getRequestConfig()).isExpectContinueEnabled()) {
                request.addHeader("Expect", "100-continue");
            }
        }
    }
}

