/*
 * Decompiled with CFR 0.152.
 */
package co.datadome.api.shaded.http.impl.client;

import co.datadome.api.shaded.http.HttpException;
import co.datadome.api.shaded.http.HttpHost;
import co.datadome.api.shaded.http.HttpRequest;
import co.datadome.api.shaded.http.annotation.Contract;
import co.datadome.api.shaded.http.annotation.ThreadingBehavior;
import co.datadome.api.shaded.http.client.ClientProtocolException;
import co.datadome.api.shaded.http.client.config.RequestConfig;
import co.datadome.api.shaded.http.client.methods.CloseableHttpResponse;
import co.datadome.api.shaded.http.client.methods.Configurable;
import co.datadome.api.shaded.http.client.methods.HttpExecutionAware;
import co.datadome.api.shaded.http.client.methods.HttpRequestWrapper;
import co.datadome.api.shaded.http.client.protocol.HttpClientContext;
import co.datadome.api.shaded.http.conn.ClientConnectionManager;
import co.datadome.api.shaded.http.conn.ClientConnectionRequest;
import co.datadome.api.shaded.http.conn.HttpClientConnectionManager;
import co.datadome.api.shaded.http.conn.ManagedClientConnection;
import co.datadome.api.shaded.http.conn.routing.HttpRoute;
import co.datadome.api.shaded.http.conn.scheme.SchemeRegistry;
import co.datadome.api.shaded.http.impl.DefaultConnectionReuseStrategy;
import co.datadome.api.shaded.http.impl.client.CloseableHttpClient;
import co.datadome.api.shaded.http.impl.client.DefaultConnectionKeepAliveStrategy;
import co.datadome.api.shaded.http.impl.execchain.MinimalClientExec;
import co.datadome.api.shaded.http.params.BasicHttpParams;
import co.datadome.api.shaded.http.params.HttpParams;
import co.datadome.api.shaded.http.protocol.BasicHttpContext;
import co.datadome.api.shaded.http.protocol.HttpContext;
import co.datadome.api.shaded.http.protocol.HttpRequestExecutor;
import co.datadome.api.shaded.http.util.Args;
import java.io.IOException;
import java.util.concurrent.TimeUnit;

@Contract(threading=ThreadingBehavior.SAFE_CONDITIONAL)
class MinimalHttpClient
extends CloseableHttpClient {
    private final HttpClientConnectionManager connManager;
    private final MinimalClientExec requestExecutor;
    private final HttpParams params;

    public MinimalHttpClient(HttpClientConnectionManager connManager) {
        this.connManager = Args.notNull(connManager, "HTTP connection manager");
        this.requestExecutor = new MinimalClientExec(new HttpRequestExecutor(), connManager, DefaultConnectionReuseStrategy.INSTANCE, DefaultConnectionKeepAliveStrategy.INSTANCE);
        this.params = new BasicHttpParams();
    }

    @Override
    protected CloseableHttpResponse doExecute(HttpHost target, HttpRequest request, HttpContext context) throws IOException, ClientProtocolException {
        Args.notNull(target, "Target host");
        Args.notNull(request, "HTTP request");
        HttpExecutionAware execAware = null;
        if (request instanceof HttpExecutionAware) {
            execAware = (HttpExecutionAware)((Object)request);
        }
        try {
            HttpRequestWrapper wrapper = HttpRequestWrapper.wrap(request);
            HttpClientContext localcontext = HttpClientContext.adapt(context != null ? context : new BasicHttpContext());
            HttpRoute route = new HttpRoute(target);
            RequestConfig config = null;
            if (request instanceof Configurable) {
                config = ((Configurable)((Object)request)).getConfig();
            }
            if (config != null) {
                localcontext.setRequestConfig(config);
            }
            return this.requestExecutor.execute(route, wrapper, localcontext, execAware);
        }
        catch (HttpException httpException) {
            throw new ClientProtocolException(httpException);
        }
    }

    @Override
    public HttpParams getParams() {
        return this.params;
    }

    @Override
    public void close() {
        this.connManager.shutdown();
    }

    @Override
    public ClientConnectionManager getConnectionManager() {
        return new ClientConnectionManager(){

            @Override
            public void shutdown() {
                MinimalHttpClient.this.connManager.shutdown();
            }

            @Override
            public ClientConnectionRequest requestConnection(HttpRoute route, Object state) {
                throw new UnsupportedOperationException();
            }

            @Override
            public void releaseConnection(ManagedClientConnection conn, long validDuration, TimeUnit timeUnit) {
                throw new UnsupportedOperationException();
            }

            @Override
            public SchemeRegistry getSchemeRegistry() {
                throw new UnsupportedOperationException();
            }

            @Override
            public void closeIdleConnections(long idletime, TimeUnit timeUnit) {
                MinimalHttpClient.this.connManager.closeIdleConnections(idletime, timeUnit);
            }

            @Override
            public void closeExpiredConnections() {
                MinimalHttpClient.this.connManager.closeExpiredConnections();
            }
        };
    }
}

