/*
 * Decompiled with CFR 0.152.
 */
package co.datadome.api.shaded.http.impl.cookie;

import co.datadome.api.shaded.http.annotation.Contract;
import co.datadome.api.shaded.http.annotation.ThreadingBehavior;
import co.datadome.api.shaded.http.cookie.ClientCookie;
import co.datadome.api.shaded.http.cookie.CommonCookieAttributeHandler;
import co.datadome.api.shaded.http.cookie.Cookie;
import co.datadome.api.shaded.http.cookie.CookieOrigin;
import co.datadome.api.shaded.http.cookie.CookieRestrictionViolationException;
import co.datadome.api.shaded.http.cookie.MalformedCookieException;
import co.datadome.api.shaded.http.cookie.SetCookie;
import co.datadome.api.shaded.http.cookie.SetCookie2;
import co.datadome.api.shaded.http.util.Args;

@Contract(threading=ThreadingBehavior.IMMUTABLE)
public class RFC2965VersionAttributeHandler
implements CommonCookieAttributeHandler {
    @Override
    public void parse(SetCookie cookie, String value) throws MalformedCookieException {
        Args.notNull(cookie, "Cookie");
        if (value == null) {
            throw new MalformedCookieException("Missing value for version attribute");
        }
        int version = -1;
        try {
            version = Integer.parseInt(value);
        }
        catch (NumberFormatException e) {
            version = -1;
        }
        if (version < 0) {
            throw new MalformedCookieException("Invalid cookie version.");
        }
        cookie.setVersion(version);
    }

    @Override
    public void validate(Cookie cookie, CookieOrigin origin) throws MalformedCookieException {
        Args.notNull(cookie, "Cookie");
        if (cookie instanceof SetCookie2 && cookie instanceof ClientCookie && !((ClientCookie)cookie).containsAttribute("version")) {
            throw new CookieRestrictionViolationException("Violates RFC 2965. Version attribute is required.");
        }
    }

    @Override
    public boolean match(Cookie cookie, CookieOrigin origin) {
        return true;
    }

    @Override
    public String getAttributeName() {
        return "version";
    }
}

