/*
 * Decompiled with CFR 0.152.
 */
package co.datadome.api.shaded.http.impl.io;

import co.datadome.api.shaded.http.Header;
import co.datadome.api.shaded.http.HeaderIterator;
import co.datadome.api.shaded.http.HttpException;
import co.datadome.api.shaded.http.HttpMessage;
import co.datadome.api.shaded.http.io.HttpMessageWriter;
import co.datadome.api.shaded.http.io.SessionOutputBuffer;
import co.datadome.api.shaded.http.message.BasicLineFormatter;
import co.datadome.api.shaded.http.message.LineFormatter;
import co.datadome.api.shaded.http.params.HttpParams;
import co.datadome.api.shaded.http.util.Args;
import co.datadome.api.shaded.http.util.CharArrayBuffer;
import java.io.IOException;

public abstract class AbstractMessageWriter<T extends HttpMessage>
implements HttpMessageWriter<T> {
    protected final SessionOutputBuffer sessionBuffer;
    protected final CharArrayBuffer lineBuf;
    protected final LineFormatter lineFormatter;

    @Deprecated
    public AbstractMessageWriter(SessionOutputBuffer buffer, LineFormatter formatter, HttpParams params) {
        Args.notNull(buffer, "Session input buffer");
        this.sessionBuffer = buffer;
        this.lineBuf = new CharArrayBuffer(128);
        this.lineFormatter = formatter != null ? formatter : BasicLineFormatter.INSTANCE;
    }

    public AbstractMessageWriter(SessionOutputBuffer buffer, LineFormatter formatter) {
        this.sessionBuffer = Args.notNull(buffer, "Session input buffer");
        this.lineFormatter = formatter != null ? formatter : BasicLineFormatter.INSTANCE;
        this.lineBuf = new CharArrayBuffer(128);
    }

    protected abstract void writeHeadLine(T var1) throws IOException;

    @Override
    public void write(T message) throws IOException, HttpException {
        Args.notNull(message, "HTTP message");
        this.writeHeadLine(message);
        HeaderIterator it = message.headerIterator();
        while (it.hasNext()) {
            Header header = it.nextHeader();
            this.sessionBuffer.writeLine(this.lineFormatter.formatHeader(this.lineBuf, header));
        }
        this.lineBuf.clear();
        this.sessionBuffer.writeLine(this.lineBuf);
    }
}

