/*
 * Decompiled with CFR 0.152.
 */
package co.datadome.api.shaded.http.protocol;

import co.datadome.api.shaded.http.HttpException;
import co.datadome.api.shaded.http.HttpResponse;
import co.datadome.api.shaded.http.HttpResponseInterceptor;
import co.datadome.api.shaded.http.annotation.Contract;
import co.datadome.api.shaded.http.annotation.ThreadingBehavior;
import co.datadome.api.shaded.http.protocol.HttpContext;
import co.datadome.api.shaded.http.protocol.HttpDateGenerator;
import co.datadome.api.shaded.http.util.Args;
import java.io.IOException;

@Contract(threading=ThreadingBehavior.SAFE)
public class ResponseDate
implements HttpResponseInterceptor {
    private static final HttpDateGenerator DATE_GENERATOR = new HttpDateGenerator();

    @Override
    public void process(HttpResponse response, HttpContext context) throws HttpException, IOException {
        Args.notNull(response, "HTTP response");
        int status = response.getStatusLine().getStatusCode();
        if (status >= 200 && !response.containsHeader("Date")) {
            String httpdate = DATE_GENERATOR.getCurrentDate();
            response.setHeader("Date", httpdate);
        }
    }
}

