/*
 * Decompiled with CFR 0.152.
 */
package unit.java.sdk.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;

public enum AchReturnReason {
    INSUFFICIENT_FUNDS("InsufficientFunds"),
    ACCOUNT_CLOSED("AccountClosed"),
    NO_ACCOUNT("NoAccount"),
    INVALID_ACCOUNT_NUMBER_STRUCTURE("InvalidAccountNumberStructure"),
    UNAUTHORIZED_DEBIT_TO_CONSUMER("UnauthorizedDebitToConsumer"),
    RETURNED_PER_ODFI_REQUEST("ReturnedPerOdfiRequest"),
    AUTHORIZATION_REVOKED_BY_CUSTOMER("AuthorizationRevokedByCustomer"),
    PAYMENT_STOPPED("PaymentStopped"),
    UNCOLLECTED_FUNDS("UncollectedFunds"),
    CUSTOMER_ADVISES_NOT_AUTHORIZED("CustomerAdvisesNotAuthorized"),
    CHECK_TRUNCATION_ENTRY_RETURNED("CheckTruncationEntryReturned"),
    BRANCH_SOLD_TO_ANOTHER_DFI("BranchSoldToAnotherDfi"),
    RDFI_NOT_QUALIFIED_TO_PARTICIPATE("RdfiNotQualifiedToParticipate"),
    REPRESENTATIVE_PAYEE_DECEASED_OR_UNABLE_TO_CONTINUE("RepresentativePayeeDeceasedOrUnableToContinue"),
    BENEFICIARY_OR_BANK_ACCOUNT_HOLDER_DECEASED("BeneficiaryOrBankAccountHolderDeceased"),
    ACCOUNT_FROZEN("AccountFrozen"),
    FILE_RECORD_EDIT_CRITERIA("FileRecordEditCriteria"),
    IMPROPER_EFFECTIVE_ENTRY_DATE("ImproperEffectiveEntryDate"),
    AMOUNT_FIELD_ERROR("AmountFieldError"),
    NON_TRANSACTION_ACCOUNT("NonTransactionAccount"),
    INVALID_COMPANY_IDENTIFICATION("InvalidCompanyIdentification"),
    INVALID_INDIVIDUAL_ID_NUMBER("InvalidIndividualIdNumber"),
    CREDIT_ENTRY_REFUSED_BY_RECEIVER("CreditEntryRefusedByReceiver"),
    DUPLICATE_ENTRY("DuplicateEntry"),
    ADDENDA_ERROR("AddendaError"),
    MANDATORY_FIELD_ERROR("MandatoryFieldError"),
    TRACE_NUMBER_ERROR("TraceNumberError"),
    ROUTING_NUMBER_CHECK_DIGIT_ERROR("RoutingNumberCheckDigitError"),
    CORPORATE_CUSTOMER_ADVISES_NOT_AUTHORIZED("CorporateCustomerAdvisesNotAuthorized"),
    RDFI_NOT_PARTICIPANT_IN_CHECK_TRUNCATION_PROGRAM("RdfiNotParticipantInCheckTruncationProgram"),
    PERMISSIBLE_RETURN_ENTRY("PermissibleReturnEntry"),
    RDFI_NON_SETTLEMENT("RdfiNonSettlement"),
    RETURN_OF_XCK_ENTRY("ReturnOfXckEntry"),
    LIMITED_PARTICIPATION_DFI("LimitedParticipationDfi"),
    RETURN_OF_IMPROPER_DEBIT_ENTRY("ReturnOfImproperDebitEntry"),
    RETURN_OF_IMPROPER_CREDIT_ENTRY("ReturnOfImproperCreditEntry"),
    SOURCE_DOCUMENT_PRESENTED_FOR_PAYMENT("SourceDocumentPresentedForPayment"),
    STOP_PAYMENT_ON_SOURCE_DOCUMENT("StopPaymentOnSourceDocument"),
    IMPROPER_SOURCE_DOCUMENT("ImproperSourceDocument"),
    INVALID_INDIVIDUAL_OR_COMPANY_NAME("InvalidIndividualOrCompanyName"),
    INCORRECTLY_CODED_OUTBOUND_INTERNATIONAL_PAYMENT("IncorrectlyCodedOutboundInternationalPayment");

    private String value;

    private AchReturnReason(String value) {
        this.value = value;
    }

    @JsonValue
    public String getValue() {
        return this.value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    @JsonCreator
    public static AchReturnReason fromValue(String value) {
        for (AchReturnReason b : AchReturnReason.values()) {
            if (!b.value.equals(value)) continue;
            return b;
        }
        throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }

    public String toUrlQueryString(String prefix) {
        if (prefix == null) {
            prefix = "";
        }
        return String.format("%s=%s", prefix, this.toString());
    }
}

