/*
 * Decompiled with CFR 0.152.
 */
package unit.java.sdk.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import jakarta.annotation.Nullable;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.StringJoiner;
import unit.java.sdk.ApiClient;

@JsonPropertyOrder(value={"amount", "fundingAccount", "tags"})
public class ApproveAuthorizationRequestAttributes {
    public static final String JSON_PROPERTY_AMOUNT = "amount";
    private Long amount;
    public static final String JSON_PROPERTY_FUNDING_ACCOUNT = "fundingAccount";
    private String fundingAccount;
    public static final String JSON_PROPERTY_TAGS = "tags";
    private Map<String, String> tags = new HashMap<String, String>();

    public ApproveAuthorizationRequestAttributes amount(Long amount) {
        this.amount = amount;
        return this;
    }

    @Nullable
    @JsonProperty(value="amount")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Long getAmount() {
        return this.amount;
    }

    @JsonProperty(value="amount")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setAmount(Long amount) {
        this.amount = amount;
    }

    public ApproveAuthorizationRequestAttributes fundingAccount(String fundingAccount) {
        this.fundingAccount = fundingAccount;
        return this;
    }

    @Nullable
    @JsonProperty(value="fundingAccount")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getFundingAccount() {
        return this.fundingAccount;
    }

    @JsonProperty(value="fundingAccount")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setFundingAccount(String fundingAccount) {
        this.fundingAccount = fundingAccount;
    }

    public ApproveAuthorizationRequestAttributes tags(Map<String, String> tags) {
        this.tags = tags;
        return this;
    }

    public ApproveAuthorizationRequestAttributes putTagsItem(String key, String tagsItem) {
        if (this.tags == null) {
            this.tags = new HashMap<String, String>();
        }
        this.tags.put(key, tagsItem);
        return this;
    }

    @Nullable
    @JsonProperty(value="tags")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Map<String, String> getTags() {
        return this.tags;
    }

    @JsonProperty(value="tags")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setTags(Map<String, String> tags) {
        this.tags = tags;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ApproveAuthorizationRequestAttributes approveAuthorizationRequestAttributes = (ApproveAuthorizationRequestAttributes)o;
        return Objects.equals(this.amount, approveAuthorizationRequestAttributes.amount) && Objects.equals(this.fundingAccount, approveAuthorizationRequestAttributes.fundingAccount) && Objects.equals(this.tags, approveAuthorizationRequestAttributes.tags);
    }

    public int hashCode() {
        return Objects.hash(this.amount, this.fundingAccount, this.tags);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ApproveAuthorizationRequestAttributes {\n");
        sb.append("    amount: ").append(this.toIndentedString(this.amount)).append("\n");
        sb.append("    fundingAccount: ").append(this.toIndentedString(this.fundingAccount)).append("\n");
        sb.append("    tags: ").append(this.toIndentedString(this.tags)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public String toUrlQueryString() {
        return this.toUrlQueryString(null);
    }

    public String toUrlQueryString(String prefix) {
        String suffix = "";
        String containerSuffix = "";
        String containerPrefix = "";
        if (prefix == null) {
            prefix = "";
        } else {
            prefix = (String)prefix + "[";
            suffix = "]";
            containerSuffix = "]";
            containerPrefix = "[";
        }
        StringJoiner joiner = new StringJoiner("&");
        if (this.getAmount() != null) {
            joiner.add(String.format("%samount%s=%s", prefix, suffix, URLEncoder.encode(ApiClient.valueToString(this.getAmount()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
        }
        if (this.getFundingAccount() != null) {
            joiner.add(String.format("%sfundingAccount%s=%s", prefix, suffix, URLEncoder.encode(ApiClient.valueToString(this.getFundingAccount()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
        }
        if (this.getTags() != null) {
            for (String _key : this.getTags().keySet()) {
                joiner.add(String.format("%stags%s%s=%s", prefix, suffix, "".equals(suffix) ? "" : String.format("%s%d%s", containerPrefix, _key, containerSuffix), this.getTags().get(_key), URLEncoder.encode(ApiClient.valueToString(this.getTags().get(_key)), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
            }
        }
        return joiner.toString();
    }
}

