/*
 * Decompiled with CFR 0.152.
 */
package unit.java.sdk.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.Objects;
import java.util.StringJoiner;
import unit.java.sdk.ApiClient;

@JsonPropertyOrder(value={"amount", "atmName", "atmLocation", "last4Digits", "cardNetwork", "surcharge"})
public class CreateAtmDepositSimulationRequestDataAttributes {
    public static final String JSON_PROPERTY_AMOUNT = "amount";
    private Long amount;
    public static final String JSON_PROPERTY_ATM_NAME = "atmName";
    private String atmName;
    public static final String JSON_PROPERTY_ATM_LOCATION = "atmLocation";
    private String atmLocation;
    public static final String JSON_PROPERTY_LAST4_DIGITS = "last4Digits";
    private String last4Digits;
    public static final String JSON_PROPERTY_CARD_NETWORK = "cardNetwork";
    private CardNetworkEnum cardNetwork;
    public static final String JSON_PROPERTY_SURCHARGE = "surcharge";
    private Long surcharge;

    public CreateAtmDepositSimulationRequestDataAttributes amount(Long amount) {
        this.amount = amount;
        return this;
    }

    @Nonnull
    @JsonProperty(value="amount")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public Long getAmount() {
        return this.amount;
    }

    @JsonProperty(value="amount")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setAmount(Long amount) {
        this.amount = amount;
    }

    public CreateAtmDepositSimulationRequestDataAttributes atmName(String atmName) {
        this.atmName = atmName;
        return this;
    }

    @Nonnull
    @JsonProperty(value="atmName")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getAtmName() {
        return this.atmName;
    }

    @JsonProperty(value="atmName")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setAtmName(String atmName) {
        this.atmName = atmName;
    }

    public CreateAtmDepositSimulationRequestDataAttributes atmLocation(String atmLocation) {
        this.atmLocation = atmLocation;
        return this;
    }

    @Nullable
    @JsonProperty(value="atmLocation")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getAtmLocation() {
        return this.atmLocation;
    }

    @JsonProperty(value="atmLocation")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setAtmLocation(String atmLocation) {
        this.atmLocation = atmLocation;
    }

    public CreateAtmDepositSimulationRequestDataAttributes last4Digits(String last4Digits) {
        this.last4Digits = last4Digits;
        return this;
    }

    @Nonnull
    @JsonProperty(value="last4Digits")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getLast4Digits() {
        return this.last4Digits;
    }

    @JsonProperty(value="last4Digits")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setLast4Digits(String last4Digits) {
        this.last4Digits = last4Digits;
    }

    public CreateAtmDepositSimulationRequestDataAttributes cardNetwork(CardNetworkEnum cardNetwork) {
        this.cardNetwork = cardNetwork;
        return this;
    }

    @Nullable
    @JsonProperty(value="cardNetwork")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public CardNetworkEnum getCardNetwork() {
        return this.cardNetwork;
    }

    @JsonProperty(value="cardNetwork")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setCardNetwork(CardNetworkEnum cardNetwork) {
        this.cardNetwork = cardNetwork;
    }

    public CreateAtmDepositSimulationRequestDataAttributes surcharge(Long surcharge) {
        this.surcharge = surcharge;
        return this;
    }

    @Nullable
    @JsonProperty(value="surcharge")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Long getSurcharge() {
        return this.surcharge;
    }

    @JsonProperty(value="surcharge")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setSurcharge(Long surcharge) {
        this.surcharge = surcharge;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CreateAtmDepositSimulationRequestDataAttributes createAtmDepositSimulationRequestDataAttributes = (CreateAtmDepositSimulationRequestDataAttributes)o;
        return Objects.equals(this.amount, createAtmDepositSimulationRequestDataAttributes.amount) && Objects.equals(this.atmName, createAtmDepositSimulationRequestDataAttributes.atmName) && Objects.equals(this.atmLocation, createAtmDepositSimulationRequestDataAttributes.atmLocation) && Objects.equals(this.last4Digits, createAtmDepositSimulationRequestDataAttributes.last4Digits) && Objects.equals((Object)this.cardNetwork, (Object)createAtmDepositSimulationRequestDataAttributes.cardNetwork) && Objects.equals(this.surcharge, createAtmDepositSimulationRequestDataAttributes.surcharge);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.amount, this.atmName, this.atmLocation, this.last4Digits, this.cardNetwork, this.surcharge});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class CreateAtmDepositSimulationRequestDataAttributes {\n");
        sb.append("    amount: ").append(this.toIndentedString(this.amount)).append("\n");
        sb.append("    atmName: ").append(this.toIndentedString(this.atmName)).append("\n");
        sb.append("    atmLocation: ").append(this.toIndentedString(this.atmLocation)).append("\n");
        sb.append("    last4Digits: ").append(this.toIndentedString(this.last4Digits)).append("\n");
        sb.append("    cardNetwork: ").append(this.toIndentedString((Object)this.cardNetwork)).append("\n");
        sb.append("    surcharge: ").append(this.toIndentedString(this.surcharge)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public String toUrlQueryString() {
        return this.toUrlQueryString(null);
    }

    public String toUrlQueryString(String prefix) {
        String suffix = "";
        String containerSuffix = "";
        String containerPrefix = "";
        if (prefix == null) {
            prefix = "";
        } else {
            prefix = (String)prefix + "[";
            suffix = "]";
            containerSuffix = "]";
            containerPrefix = "[";
        }
        StringJoiner joiner = new StringJoiner("&");
        if (this.getAmount() != null) {
            joiner.add(String.format("%samount%s=%s", prefix, suffix, URLEncoder.encode(ApiClient.valueToString(this.getAmount()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
        }
        if (this.getAtmName() != null) {
            joiner.add(String.format("%satmName%s=%s", prefix, suffix, URLEncoder.encode(ApiClient.valueToString(this.getAtmName()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
        }
        if (this.getAtmLocation() != null) {
            joiner.add(String.format("%satmLocation%s=%s", prefix, suffix, URLEncoder.encode(ApiClient.valueToString(this.getAtmLocation()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
        }
        if (this.getLast4Digits() != null) {
            joiner.add(String.format("%slast4Digits%s=%s", prefix, suffix, URLEncoder.encode(ApiClient.valueToString(this.getLast4Digits()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
        }
        if (this.getCardNetwork() != null) {
            joiner.add(String.format("%scardNetwork%s=%s", prefix, suffix, URLEncoder.encode(ApiClient.valueToString((Object)this.getCardNetwork()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
        }
        if (this.getSurcharge() != null) {
            joiner.add(String.format("%ssurcharge%s=%s", prefix, suffix, URLEncoder.encode(ApiClient.valueToString(this.getSurcharge()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
        }
        return joiner.toString();
    }

    public static enum CardNetworkEnum {
        VISA("Visa"),
        INTERLINK("Interlink"),
        ACCEL("Accel"),
        ALLPOINT("Allpoint"),
        OTHER("Other");

        private String value;

        private CardNetworkEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static CardNetworkEnum fromValue(String value) {
            for (CardNetworkEnum b : CardNetworkEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

