/*
 * Decompiled with CFR 0.152.
 */
package unit.java.sdk.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.time.LocalDate;
import java.util.Objects;
import java.util.StringJoiner;
import unit.java.sdk.ApiClient;

@JsonPropertyOrder(value={"amount", "settlementDate", "companyName", "receivingEntityName", "secCode", "direction"})
public class CreateIncomingAchPaymentRequestDataAttributes {
    public static final String JSON_PROPERTY_AMOUNT = "amount";
    private Long amount;
    public static final String JSON_PROPERTY_SETTLEMENT_DATE = "settlementDate";
    private LocalDate settlementDate;
    public static final String JSON_PROPERTY_COMPANY_NAME = "companyName";
    private String companyName;
    public static final String JSON_PROPERTY_RECEIVING_ENTITY_NAME = "receivingEntityName";
    private String receivingEntityName;
    public static final String JSON_PROPERTY_SEC_CODE = "secCode";
    private String secCode;
    public static final String JSON_PROPERTY_DIRECTION = "direction";
    private DirectionEnum direction;

    public CreateIncomingAchPaymentRequestDataAttributes amount(Long amount) {
        this.amount = amount;
        return this;
    }

    @Nonnull
    @JsonProperty(value="amount")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public Long getAmount() {
        return this.amount;
    }

    @JsonProperty(value="amount")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setAmount(Long amount) {
        this.amount = amount;
    }

    public CreateIncomingAchPaymentRequestDataAttributes settlementDate(LocalDate settlementDate) {
        this.settlementDate = settlementDate;
        return this;
    }

    @Nonnull
    @JsonProperty(value="settlementDate")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public LocalDate getSettlementDate() {
        return this.settlementDate;
    }

    @JsonProperty(value="settlementDate")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setSettlementDate(LocalDate settlementDate) {
        this.settlementDate = settlementDate;
    }

    public CreateIncomingAchPaymentRequestDataAttributes companyName(String companyName) {
        this.companyName = companyName;
        return this;
    }

    @Nonnull
    @JsonProperty(value="companyName")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getCompanyName() {
        return this.companyName;
    }

    @JsonProperty(value="companyName")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setCompanyName(String companyName) {
        this.companyName = companyName;
    }

    public CreateIncomingAchPaymentRequestDataAttributes receivingEntityName(String receivingEntityName) {
        this.receivingEntityName = receivingEntityName;
        return this;
    }

    @Nullable
    @JsonProperty(value="receivingEntityName")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getReceivingEntityName() {
        return this.receivingEntityName;
    }

    @JsonProperty(value="receivingEntityName")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setReceivingEntityName(String receivingEntityName) {
        this.receivingEntityName = receivingEntityName;
    }

    public CreateIncomingAchPaymentRequestDataAttributes secCode(String secCode) {
        this.secCode = secCode;
        return this;
    }

    @Nullable
    @JsonProperty(value="secCode")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getSecCode() {
        return this.secCode;
    }

    @JsonProperty(value="secCode")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setSecCode(String secCode) {
        this.secCode = secCode;
    }

    public CreateIncomingAchPaymentRequestDataAttributes direction(DirectionEnum direction) {
        this.direction = direction;
        return this;
    }

    @Nullable
    @JsonProperty(value="direction")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public DirectionEnum getDirection() {
        return this.direction;
    }

    @JsonProperty(value="direction")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setDirection(DirectionEnum direction) {
        this.direction = direction;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CreateIncomingAchPaymentRequestDataAttributes createIncomingAchPaymentRequestDataAttributes = (CreateIncomingAchPaymentRequestDataAttributes)o;
        return Objects.equals(this.amount, createIncomingAchPaymentRequestDataAttributes.amount) && Objects.equals(this.settlementDate, createIncomingAchPaymentRequestDataAttributes.settlementDate) && Objects.equals(this.companyName, createIncomingAchPaymentRequestDataAttributes.companyName) && Objects.equals(this.receivingEntityName, createIncomingAchPaymentRequestDataAttributes.receivingEntityName) && Objects.equals(this.secCode, createIncomingAchPaymentRequestDataAttributes.secCode) && Objects.equals((Object)this.direction, (Object)createIncomingAchPaymentRequestDataAttributes.direction);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.amount, this.settlementDate, this.companyName, this.receivingEntityName, this.secCode, this.direction});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class CreateIncomingAchPaymentRequestDataAttributes {\n");
        sb.append("    amount: ").append(this.toIndentedString(this.amount)).append("\n");
        sb.append("    settlementDate: ").append(this.toIndentedString(this.settlementDate)).append("\n");
        sb.append("    companyName: ").append(this.toIndentedString(this.companyName)).append("\n");
        sb.append("    receivingEntityName: ").append(this.toIndentedString(this.receivingEntityName)).append("\n");
        sb.append("    secCode: ").append(this.toIndentedString(this.secCode)).append("\n");
        sb.append("    direction: ").append(this.toIndentedString((Object)this.direction)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public String toUrlQueryString() {
        return this.toUrlQueryString(null);
    }

    public String toUrlQueryString(String prefix) {
        String suffix = "";
        String containerSuffix = "";
        String containerPrefix = "";
        if (prefix == null) {
            prefix = "";
        } else {
            prefix = (String)prefix + "[";
            suffix = "]";
            containerSuffix = "]";
            containerPrefix = "[";
        }
        StringJoiner joiner = new StringJoiner("&");
        if (this.getAmount() != null) {
            joiner.add(String.format("%samount%s=%s", prefix, suffix, URLEncoder.encode(ApiClient.valueToString(this.getAmount()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
        }
        if (this.getSettlementDate() != null) {
            joiner.add(String.format("%ssettlementDate%s=%s", prefix, suffix, URLEncoder.encode(ApiClient.valueToString(this.getSettlementDate()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
        }
        if (this.getCompanyName() != null) {
            joiner.add(String.format("%scompanyName%s=%s", prefix, suffix, URLEncoder.encode(ApiClient.valueToString(this.getCompanyName()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
        }
        if (this.getReceivingEntityName() != null) {
            joiner.add(String.format("%sreceivingEntityName%s=%s", prefix, suffix, URLEncoder.encode(ApiClient.valueToString(this.getReceivingEntityName()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
        }
        if (this.getSecCode() != null) {
            joiner.add(String.format("%ssecCode%s=%s", prefix, suffix, URLEncoder.encode(ApiClient.valueToString(this.getSecCode()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
        }
        if (this.getDirection() != null) {
            joiner.add(String.format("%sdirection%s=%s", prefix, suffix, URLEncoder.encode(ApiClient.valueToString((Object)this.getDirection()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
        }
        return joiner.toString();
    }

    public static enum DirectionEnum {
        DEBIT("Debit"),
        CREDIT("Credit");

        private String value;

        private DirectionEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static DirectionEnum fromValue(String value) {
            for (DirectionEnum b : DirectionEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

