/*
 * Decompiled with CFR 0.152.
 */
package unit.java.sdk.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.Objects;
import java.util.StringJoiner;
import unit.java.sdk.ApiClient;

@JsonPropertyOrder(value={"routingNumber", "name", "address", "isWireSupported", "isACHSupported"})
public class InstitutionAttributes {
    public static final String JSON_PROPERTY_ROUTING_NUMBER = "routingNumber";
    private String routingNumber;
    public static final String JSON_PROPERTY_NAME = "name";
    private String name;
    public static final String JSON_PROPERTY_ADDRESS = "address";
    private String address;
    public static final String JSON_PROPERTY_IS_WIRE_SUPPORTED = "isWireSupported";
    private Boolean isWireSupported;
    public static final String JSON_PROPERTY_IS_A_C_H_SUPPORTED = "isACHSupported";
    private Boolean isACHSupported;

    public InstitutionAttributes routingNumber(String routingNumber) {
        this.routingNumber = routingNumber;
        return this;
    }

    @Nonnull
    @JsonProperty(value="routingNumber")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getRoutingNumber() {
        return this.routingNumber;
    }

    @JsonProperty(value="routingNumber")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setRoutingNumber(String routingNumber) {
        this.routingNumber = routingNumber;
    }

    public InstitutionAttributes name(String name) {
        this.name = name;
        return this;
    }

    @Nonnull
    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getName() {
        return this.name;
    }

    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setName(String name) {
        this.name = name;
    }

    public InstitutionAttributes address(String address) {
        this.address = address;
        return this;
    }

    @Nullable
    @JsonProperty(value="address")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getAddress() {
        return this.address;
    }

    @JsonProperty(value="address")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setAddress(String address) {
        this.address = address;
    }

    public InstitutionAttributes isWireSupported(Boolean isWireSupported) {
        this.isWireSupported = isWireSupported;
        return this;
    }

    @Nonnull
    @JsonProperty(value="isWireSupported")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public Boolean getIsWireSupported() {
        return this.isWireSupported;
    }

    @JsonProperty(value="isWireSupported")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setIsWireSupported(Boolean isWireSupported) {
        this.isWireSupported = isWireSupported;
    }

    public InstitutionAttributes isACHSupported(Boolean isACHSupported) {
        this.isACHSupported = isACHSupported;
        return this;
    }

    @Nonnull
    @JsonProperty(value="isACHSupported")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public Boolean getIsACHSupported() {
        return this.isACHSupported;
    }

    @JsonProperty(value="isACHSupported")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setIsACHSupported(Boolean isACHSupported) {
        this.isACHSupported = isACHSupported;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        InstitutionAttributes institutionAttributes = (InstitutionAttributes)o;
        return Objects.equals(this.routingNumber, institutionAttributes.routingNumber) && Objects.equals(this.name, institutionAttributes.name) && Objects.equals(this.address, institutionAttributes.address) && Objects.equals(this.isWireSupported, institutionAttributes.isWireSupported) && Objects.equals(this.isACHSupported, institutionAttributes.isACHSupported);
    }

    public int hashCode() {
        return Objects.hash(this.routingNumber, this.name, this.address, this.isWireSupported, this.isACHSupported);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class InstitutionAttributes {\n");
        sb.append("    routingNumber: ").append(this.toIndentedString(this.routingNumber)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    address: ").append(this.toIndentedString(this.address)).append("\n");
        sb.append("    isWireSupported: ").append(this.toIndentedString(this.isWireSupported)).append("\n");
        sb.append("    isACHSupported: ").append(this.toIndentedString(this.isACHSupported)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public String toUrlQueryString() {
        return this.toUrlQueryString(null);
    }

    public String toUrlQueryString(String prefix) {
        String suffix = "";
        String containerSuffix = "";
        String containerPrefix = "";
        if (prefix == null) {
            prefix = "";
        } else {
            prefix = (String)prefix + "[";
            suffix = "]";
            containerSuffix = "]";
            containerPrefix = "[";
        }
        StringJoiner joiner = new StringJoiner("&");
        if (this.getRoutingNumber() != null) {
            joiner.add(String.format("%sroutingNumber%s=%s", prefix, suffix, URLEncoder.encode(ApiClient.valueToString(this.getRoutingNumber()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
        }
        if (this.getName() != null) {
            joiner.add(String.format("%sname%s=%s", prefix, suffix, URLEncoder.encode(ApiClient.valueToString(this.getName()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
        }
        if (this.getAddress() != null) {
            joiner.add(String.format("%saddress%s=%s", prefix, suffix, URLEncoder.encode(ApiClient.valueToString(this.getAddress()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
        }
        if (this.getIsWireSupported() != null) {
            joiner.add(String.format("%sisWireSupported%s=%s", prefix, suffix, URLEncoder.encode(ApiClient.valueToString(this.getIsWireSupported()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
        }
        if (this.getIsACHSupported() != null) {
            joiner.add(String.format("%sisACHSupported%s=%s", prefix, suffix, URLEncoder.encode(ApiClient.valueToString(this.getIsACHSupported()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
        }
        return joiner.toString();
    }
}

