/*
 * Decompiled with CFR 0.152.
 */
package unit.java.sdk.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import jakarta.annotation.Nonnull;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.time.LocalDate;
import java.util.Objects;
import java.util.StringJoiner;
import unit.java.sdk.ApiClient;

@JsonPropertyOrder(value={"remainingAmountDue", "remainingAmountOverdue", "initiatedRepayments", "statementPeriodStart", "statementPeriodEnd", "nextRepaymentDueDate"})
public class RepaymentInformationAttributes {
    public static final String JSON_PROPERTY_REMAINING_AMOUNT_DUE = "remainingAmountDue";
    private Long remainingAmountDue;
    public static final String JSON_PROPERTY_REMAINING_AMOUNT_OVERDUE = "remainingAmountOverdue";
    private Long remainingAmountOverdue;
    public static final String JSON_PROPERTY_INITIATED_REPAYMENTS = "initiatedRepayments";
    private Long initiatedRepayments;
    public static final String JSON_PROPERTY_STATEMENT_PERIOD_START = "statementPeriodStart";
    private LocalDate statementPeriodStart;
    public static final String JSON_PROPERTY_STATEMENT_PERIOD_END = "statementPeriodEnd";
    private LocalDate statementPeriodEnd;
    public static final String JSON_PROPERTY_NEXT_REPAYMENT_DUE_DATE = "nextRepaymentDueDate";
    private LocalDate nextRepaymentDueDate;

    public RepaymentInformationAttributes remainingAmountDue(Long remainingAmountDue) {
        this.remainingAmountDue = remainingAmountDue;
        return this;
    }

    @Nonnull
    @JsonProperty(value="remainingAmountDue")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public Long getRemainingAmountDue() {
        return this.remainingAmountDue;
    }

    @JsonProperty(value="remainingAmountDue")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setRemainingAmountDue(Long remainingAmountDue) {
        this.remainingAmountDue = remainingAmountDue;
    }

    public RepaymentInformationAttributes remainingAmountOverdue(Long remainingAmountOverdue) {
        this.remainingAmountOverdue = remainingAmountOverdue;
        return this;
    }

    @Nonnull
    @JsonProperty(value="remainingAmountOverdue")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public Long getRemainingAmountOverdue() {
        return this.remainingAmountOverdue;
    }

    @JsonProperty(value="remainingAmountOverdue")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setRemainingAmountOverdue(Long remainingAmountOverdue) {
        this.remainingAmountOverdue = remainingAmountOverdue;
    }

    public RepaymentInformationAttributes initiatedRepayments(Long initiatedRepayments) {
        this.initiatedRepayments = initiatedRepayments;
        return this;
    }

    @Nonnull
    @JsonProperty(value="initiatedRepayments")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public Long getInitiatedRepayments() {
        return this.initiatedRepayments;
    }

    @JsonProperty(value="initiatedRepayments")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setInitiatedRepayments(Long initiatedRepayments) {
        this.initiatedRepayments = initiatedRepayments;
    }

    public RepaymentInformationAttributes statementPeriodStart(LocalDate statementPeriodStart) {
        this.statementPeriodStart = statementPeriodStart;
        return this;
    }

    @Nonnull
    @JsonProperty(value="statementPeriodStart")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public LocalDate getStatementPeriodStart() {
        return this.statementPeriodStart;
    }

    @JsonProperty(value="statementPeriodStart")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setStatementPeriodStart(LocalDate statementPeriodStart) {
        this.statementPeriodStart = statementPeriodStart;
    }

    public RepaymentInformationAttributes statementPeriodEnd(LocalDate statementPeriodEnd) {
        this.statementPeriodEnd = statementPeriodEnd;
        return this;
    }

    @Nonnull
    @JsonProperty(value="statementPeriodEnd")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public LocalDate getStatementPeriodEnd() {
        return this.statementPeriodEnd;
    }

    @JsonProperty(value="statementPeriodEnd")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setStatementPeriodEnd(LocalDate statementPeriodEnd) {
        this.statementPeriodEnd = statementPeriodEnd;
    }

    public RepaymentInformationAttributes nextRepaymentDueDate(LocalDate nextRepaymentDueDate) {
        this.nextRepaymentDueDate = nextRepaymentDueDate;
        return this;
    }

    @Nonnull
    @JsonProperty(value="nextRepaymentDueDate")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public LocalDate getNextRepaymentDueDate() {
        return this.nextRepaymentDueDate;
    }

    @JsonProperty(value="nextRepaymentDueDate")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setNextRepaymentDueDate(LocalDate nextRepaymentDueDate) {
        this.nextRepaymentDueDate = nextRepaymentDueDate;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RepaymentInformationAttributes repaymentInformationAttributes = (RepaymentInformationAttributes)o;
        return Objects.equals(this.remainingAmountDue, repaymentInformationAttributes.remainingAmountDue) && Objects.equals(this.remainingAmountOverdue, repaymentInformationAttributes.remainingAmountOverdue) && Objects.equals(this.initiatedRepayments, repaymentInformationAttributes.initiatedRepayments) && Objects.equals(this.statementPeriodStart, repaymentInformationAttributes.statementPeriodStart) && Objects.equals(this.statementPeriodEnd, repaymentInformationAttributes.statementPeriodEnd) && Objects.equals(this.nextRepaymentDueDate, repaymentInformationAttributes.nextRepaymentDueDate);
    }

    public int hashCode() {
        return Objects.hash(this.remainingAmountDue, this.remainingAmountOverdue, this.initiatedRepayments, this.statementPeriodStart, this.statementPeriodEnd, this.nextRepaymentDueDate);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class RepaymentInformationAttributes {\n");
        sb.append("    remainingAmountDue: ").append(this.toIndentedString(this.remainingAmountDue)).append("\n");
        sb.append("    remainingAmountOverdue: ").append(this.toIndentedString(this.remainingAmountOverdue)).append("\n");
        sb.append("    initiatedRepayments: ").append(this.toIndentedString(this.initiatedRepayments)).append("\n");
        sb.append("    statementPeriodStart: ").append(this.toIndentedString(this.statementPeriodStart)).append("\n");
        sb.append("    statementPeriodEnd: ").append(this.toIndentedString(this.statementPeriodEnd)).append("\n");
        sb.append("    nextRepaymentDueDate: ").append(this.toIndentedString(this.nextRepaymentDueDate)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public String toUrlQueryString() {
        return this.toUrlQueryString(null);
    }

    public String toUrlQueryString(String prefix) {
        String suffix = "";
        String containerSuffix = "";
        String containerPrefix = "";
        if (prefix == null) {
            prefix = "";
        } else {
            prefix = (String)prefix + "[";
            suffix = "]";
            containerSuffix = "]";
            containerPrefix = "[";
        }
        StringJoiner joiner = new StringJoiner("&");
        if (this.getRemainingAmountDue() != null) {
            joiner.add(String.format("%sremainingAmountDue%s=%s", prefix, suffix, URLEncoder.encode(ApiClient.valueToString(this.getRemainingAmountDue()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
        }
        if (this.getRemainingAmountOverdue() != null) {
            joiner.add(String.format("%sremainingAmountOverdue%s=%s", prefix, suffix, URLEncoder.encode(ApiClient.valueToString(this.getRemainingAmountOverdue()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
        }
        if (this.getInitiatedRepayments() != null) {
            joiner.add(String.format("%sinitiatedRepayments%s=%s", prefix, suffix, URLEncoder.encode(ApiClient.valueToString(this.getInitiatedRepayments()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
        }
        if (this.getStatementPeriodStart() != null) {
            joiner.add(String.format("%sstatementPeriodStart%s=%s", prefix, suffix, URLEncoder.encode(ApiClient.valueToString(this.getStatementPeriodStart()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
        }
        if (this.getStatementPeriodEnd() != null) {
            joiner.add(String.format("%sstatementPeriodEnd%s=%s", prefix, suffix, URLEncoder.encode(ApiClient.valueToString(this.getStatementPeriodEnd()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
        }
        if (this.getNextRepaymentDueDate() != null) {
            joiner.add(String.format("%snextRepaymentDueDate%s=%s", prefix, suffix, URLEncoder.encode(ApiClient.valueToString(this.getNextRepaymentDueDate()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
        }
        return joiner.toString();
    }
}

