/*
 * Decompiled with CFR 0.152.
 */
package unit.java.sdk.model;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.time.LocalDate;
import java.util.HashMap;
import java.util.Objects;
import java.util.StringJoiner;
import unit.java.sdk.ApiClient;
import unit.java.sdk.JSON;
import unit.java.sdk.model.ResponseSchedule;

@JsonPropertyOrder(value={"startTime", "endTime", "dayOfMonth", "nextScheduledAction", "totalNumberOfPayments"})
@JsonIgnoreProperties(value={"interval"}, allowSetters=true)
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="interval", visible=true)
public class ResponseWeeklySchedule
extends ResponseSchedule {
    public static final String JSON_PROPERTY_START_TIME = "startTime";
    private LocalDate startTime;
    public static final String JSON_PROPERTY_END_TIME = "endTime";
    private LocalDate endTime;
    public static final String JSON_PROPERTY_DAY_OF_MONTH = "dayOfMonth";
    private Integer dayOfMonth;
    public static final String JSON_PROPERTY_NEXT_SCHEDULED_ACTION = "nextScheduledAction";
    private LocalDate nextScheduledAction;
    public static final String JSON_PROPERTY_TOTAL_NUMBER_OF_PAYMENTS = "totalNumberOfPayments";
    private Integer totalNumberOfPayments;

    public ResponseWeeklySchedule startTime(LocalDate startTime) {
        this.startTime = startTime;
        return this;
    }

    @Nullable
    @JsonProperty(value="startTime")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public LocalDate getStartTime() {
        return this.startTime;
    }

    @JsonProperty(value="startTime")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setStartTime(LocalDate startTime) {
        this.startTime = startTime;
    }

    public ResponseWeeklySchedule endTime(LocalDate endTime) {
        this.endTime = endTime;
        return this;
    }

    @Nullable
    @JsonProperty(value="endTime")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public LocalDate getEndTime() {
        return this.endTime;
    }

    @JsonProperty(value="endTime")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setEndTime(LocalDate endTime) {
        this.endTime = endTime;
    }

    public ResponseWeeklySchedule dayOfMonth(Integer dayOfMonth) {
        this.dayOfMonth = dayOfMonth;
        return this;
    }

    @Nullable
    @JsonProperty(value="dayOfMonth")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Integer getDayOfMonth() {
        return this.dayOfMonth;
    }

    @JsonProperty(value="dayOfMonth")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setDayOfMonth(Integer dayOfMonth) {
        this.dayOfMonth = dayOfMonth;
    }

    public ResponseWeeklySchedule nextScheduledAction(LocalDate nextScheduledAction) {
        this.nextScheduledAction = nextScheduledAction;
        return this;
    }

    @Nonnull
    @JsonProperty(value="nextScheduledAction")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public LocalDate getNextScheduledAction() {
        return this.nextScheduledAction;
    }

    @JsonProperty(value="nextScheduledAction")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setNextScheduledAction(LocalDate nextScheduledAction) {
        this.nextScheduledAction = nextScheduledAction;
    }

    public ResponseWeeklySchedule totalNumberOfPayments(Integer totalNumberOfPayments) {
        this.totalNumberOfPayments = totalNumberOfPayments;
        return this;
    }

    @Nullable
    @JsonProperty(value="totalNumberOfPayments")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Integer getTotalNumberOfPayments() {
        return this.totalNumberOfPayments;
    }

    @JsonProperty(value="totalNumberOfPayments")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setTotalNumberOfPayments(Integer totalNumberOfPayments) {
        this.totalNumberOfPayments = totalNumberOfPayments;
    }

    @Override
    public ResponseWeeklySchedule interval(ResponseSchedule.IntervalEnum interval) {
        this.setInterval(interval);
        return this;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ResponseWeeklySchedule responseWeeklySchedule = (ResponseWeeklySchedule)o;
        return Objects.equals(this.startTime, responseWeeklySchedule.startTime) && Objects.equals(this.endTime, responseWeeklySchedule.endTime) && Objects.equals(this.dayOfMonth, responseWeeklySchedule.dayOfMonth) && Objects.equals(this.nextScheduledAction, responseWeeklySchedule.nextScheduledAction) && Objects.equals(this.totalNumberOfPayments, responseWeeklySchedule.totalNumberOfPayments) && super.equals(o);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.startTime, this.endTime, this.dayOfMonth, this.nextScheduledAction, this.totalNumberOfPayments, super.hashCode());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ResponseWeeklySchedule {\n");
        sb.append("    ").append(this.toIndentedString(super.toString())).append("\n");
        sb.append("    startTime: ").append(this.toIndentedString(this.startTime)).append("\n");
        sb.append("    endTime: ").append(this.toIndentedString(this.endTime)).append("\n");
        sb.append("    dayOfMonth: ").append(this.toIndentedString(this.dayOfMonth)).append("\n");
        sb.append("    nextScheduledAction: ").append(this.toIndentedString(this.nextScheduledAction)).append("\n");
        sb.append("    totalNumberOfPayments: ").append(this.toIndentedString(this.totalNumberOfPayments)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @Override
    public String toUrlQueryString() {
        return this.toUrlQueryString(null);
    }

    @Override
    public String toUrlQueryString(String prefix) {
        String suffix = "";
        String containerSuffix = "";
        String containerPrefix = "";
        if (prefix == null) {
            prefix = "";
        } else {
            prefix = (String)prefix + "[";
            suffix = "]";
            containerSuffix = "]";
            containerPrefix = "[";
        }
        StringJoiner joiner = new StringJoiner("&");
        if (this.getInterval() != null) {
            joiner.add(String.format("%sinterval%s=%s", prefix, suffix, URLEncoder.encode(ApiClient.valueToString((Object)this.getInterval()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
        }
        if (this.getStartTime() != null) {
            joiner.add(String.format("%sstartTime%s=%s", prefix, suffix, URLEncoder.encode(ApiClient.valueToString(this.getStartTime()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
        }
        if (this.getEndTime() != null) {
            joiner.add(String.format("%sendTime%s=%s", prefix, suffix, URLEncoder.encode(ApiClient.valueToString(this.getEndTime()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
        }
        if (this.getDayOfMonth() != null) {
            joiner.add(String.format("%sdayOfMonth%s=%s", prefix, suffix, URLEncoder.encode(ApiClient.valueToString(this.getDayOfMonth()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
        }
        if (this.getNextScheduledAction() != null) {
            joiner.add(String.format("%snextScheduledAction%s=%s", prefix, suffix, URLEncoder.encode(ApiClient.valueToString(this.getNextScheduledAction()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
        }
        if (this.getTotalNumberOfPayments() != null) {
            joiner.add(String.format("%stotalNumberOfPayments%s=%s", prefix, suffix, URLEncoder.encode(ApiClient.valueToString(this.getTotalNumberOfPayments()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
        }
        return joiner.toString();
    }

    static {
        HashMap mappings = new HashMap();
        mappings.put("ResponseWeeklySchedule", ResponseWeeklySchedule.class);
        JSON.registerDiscriminator(ResponseWeeklySchedule.class, "interval", mappings);
    }
}

