/*
 * Decompiled with CFR 0.152.
 */
package unit.java.sdk.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;

public enum ReturnReason {
    INSUFFICIENT_FUNDS("InsufficientFunds"),
    ACCOUNT_CLOSED("AccountClosed"),
    ALTERED_CHECK("AlteredCheck"),
    FORGED_SIGNATURE("ForgedSignature"),
    POSTDATED_CHECK("PostdatedCheck"),
    STOP_PAYMENT_ORDER("StopPaymentOrder"),
    UNAUTHORIZED_DEBIT("UnauthorizedDebit"),
    WRONG_AMOUNT("WrongAmount"),
    DUPLICATE_PAYMENT("DuplicatePayment"),
    MISSING_SIGNATURE("MissingSignature"),
    IRREGULAR_ENDORSEMENT("IrregularEndorsement"),
    OTHER("Other");

    private String value;

    private ReturnReason(String value) {
        this.value = value;
    }

    @JsonValue
    public String getValue() {
        return this.value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    @JsonCreator
    public static ReturnReason fromValue(String value) {
        for (ReturnReason b : ReturnReason.values()) {
            if (!b.value.equals(value)) continue;
            return b;
        }
        throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }

    public String toUrlQueryString(String prefix) {
        if (prefix == null) {
            prefix = "";
        }
        return String.format("%s=%s", prefix, this.toString());
    }
}

