/*
 * Decompiled with CFR 0.152.
 */
package unit.java.sdk.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import jakarta.annotation.Nullable;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.StringJoiner;
import unit.java.sdk.ApiClient;
import unit.java.sdk.model.Address;
import unit.java.sdk.model.CardLevelLimits;

@JsonPropertyOrder(value={"shippingAddress", "design", "tags", "limits", "defaultFundingAccountId"})
public class UpdateIndividualDebitCardAttributes {
    public static final String JSON_PROPERTY_SHIPPING_ADDRESS = "shippingAddress";
    private Address shippingAddress;
    public static final String JSON_PROPERTY_DESIGN = "design";
    private String design;
    public static final String JSON_PROPERTY_TAGS = "tags";
    private Map<String, String> tags = new HashMap<String, String>();
    public static final String JSON_PROPERTY_LIMITS = "limits";
    private CardLevelLimits limits;
    public static final String JSON_PROPERTY_DEFAULT_FUNDING_ACCOUNT_ID = "defaultFundingAccountId";
    private String defaultFundingAccountId;

    public UpdateIndividualDebitCardAttributes shippingAddress(Address shippingAddress) {
        this.shippingAddress = shippingAddress;
        return this;
    }

    @Nullable
    @JsonProperty(value="shippingAddress")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Address getShippingAddress() {
        return this.shippingAddress;
    }

    @JsonProperty(value="shippingAddress")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setShippingAddress(Address shippingAddress) {
        this.shippingAddress = shippingAddress;
    }

    public UpdateIndividualDebitCardAttributes design(String design) {
        this.design = design;
        return this;
    }

    @Nullable
    @JsonProperty(value="design")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getDesign() {
        return this.design;
    }

    @JsonProperty(value="design")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setDesign(String design) {
        this.design = design;
    }

    public UpdateIndividualDebitCardAttributes tags(Map<String, String> tags) {
        this.tags = tags;
        return this;
    }

    public UpdateIndividualDebitCardAttributes putTagsItem(String key, String tagsItem) {
        if (this.tags == null) {
            this.tags = new HashMap<String, String>();
        }
        this.tags.put(key, tagsItem);
        return this;
    }

    @Nullable
    @JsonProperty(value="tags")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Map<String, String> getTags() {
        return this.tags;
    }

    @JsonProperty(value="tags")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setTags(Map<String, String> tags) {
        this.tags = tags;
    }

    public UpdateIndividualDebitCardAttributes limits(CardLevelLimits limits) {
        this.limits = limits;
        return this;
    }

    @Nullable
    @JsonProperty(value="limits")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public CardLevelLimits getLimits() {
        return this.limits;
    }

    @JsonProperty(value="limits")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setLimits(CardLevelLimits limits) {
        this.limits = limits;
    }

    public UpdateIndividualDebitCardAttributes defaultFundingAccountId(String defaultFundingAccountId) {
        this.defaultFundingAccountId = defaultFundingAccountId;
        return this;
    }

    @Nullable
    @JsonProperty(value="defaultFundingAccountId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getDefaultFundingAccountId() {
        return this.defaultFundingAccountId;
    }

    @JsonProperty(value="defaultFundingAccountId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setDefaultFundingAccountId(String defaultFundingAccountId) {
        this.defaultFundingAccountId = defaultFundingAccountId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UpdateIndividualDebitCardAttributes updateIndividualDebitCardAttributes = (UpdateIndividualDebitCardAttributes)o;
        return Objects.equals(this.shippingAddress, updateIndividualDebitCardAttributes.shippingAddress) && Objects.equals(this.design, updateIndividualDebitCardAttributes.design) && Objects.equals(this.tags, updateIndividualDebitCardAttributes.tags) && Objects.equals(this.limits, updateIndividualDebitCardAttributes.limits) && Objects.equals(this.defaultFundingAccountId, updateIndividualDebitCardAttributes.defaultFundingAccountId);
    }

    public int hashCode() {
        return Objects.hash(this.shippingAddress, this.design, this.tags, this.limits, this.defaultFundingAccountId);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class UpdateIndividualDebitCardAttributes {\n");
        sb.append("    shippingAddress: ").append(this.toIndentedString(this.shippingAddress)).append("\n");
        sb.append("    design: ").append(this.toIndentedString(this.design)).append("\n");
        sb.append("    tags: ").append(this.toIndentedString(this.tags)).append("\n");
        sb.append("    limits: ").append(this.toIndentedString(this.limits)).append("\n");
        sb.append("    defaultFundingAccountId: ").append(this.toIndentedString(this.defaultFundingAccountId)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public String toUrlQueryString() {
        return this.toUrlQueryString(null);
    }

    public String toUrlQueryString(String prefix) {
        String suffix = "";
        String containerSuffix = "";
        String containerPrefix = "";
        if (prefix == null) {
            prefix = "";
        } else {
            prefix = (String)prefix + "[";
            suffix = "]";
            containerSuffix = "]";
            containerPrefix = "[";
        }
        StringJoiner joiner = new StringJoiner("&");
        if (this.getShippingAddress() != null) {
            joiner.add(this.getShippingAddress().toUrlQueryString((String)prefix + JSON_PROPERTY_SHIPPING_ADDRESS + suffix));
        }
        if (this.getDesign() != null) {
            joiner.add(String.format("%sdesign%s=%s", prefix, suffix, URLEncoder.encode(ApiClient.valueToString(this.getDesign()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
        }
        if (this.getTags() != null) {
            for (String _key : this.getTags().keySet()) {
                joiner.add(String.format("%stags%s%s=%s", prefix, suffix, "".equals(suffix) ? "" : String.format("%s%d%s", containerPrefix, _key, containerSuffix), this.getTags().get(_key), URLEncoder.encode(ApiClient.valueToString(this.getTags().get(_key)), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
            }
        }
        if (this.getLimits() != null) {
            joiner.add(this.getLimits().toUrlQueryString((String)prefix + JSON_PROPERTY_LIMITS + suffix));
        }
        if (this.getDefaultFundingAccountId() != null) {
            joiner.add(String.format("%sdefaultFundingAccountId%s=%s", prefix, suffix, URLEncoder.encode(ApiClient.valueToString(this.getDefaultFundingAccountId()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
        }
        return joiner.toString();
    }
}

