/*
 * Decompiled with CFR 0.152.
 */
package no.skatteetaten.fastsetting.formueinntekt.felles.documentsql.api;

import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class PathElement {
    private final String name;
    private final String namespace;
    private final boolean manifest;

    public PathElement(String name) {
        this.name = name;
        this.namespace = null;
        this.manifest = true;
    }

    public PathElement(String name, String namespace) {
        this.name = name;
        this.namespace = namespace;
        this.manifest = true;
    }

    public PathElement(String name, String namespace, boolean manifest) {
        this.name = name;
        this.namespace = namespace;
        this.manifest = manifest;
    }

    public String getName() {
        return this.name;
    }

    public Optional<String> getNamespace() {
        return Optional.ofNullable(this.namespace);
    }

    public boolean isManifest() {
        return this.manifest;
    }

    static List<PathElement> merge(List<PathElement> key, PathElement ... elements) {
        return Stream.concat(key.stream(), Stream.of(elements)).collect(Collectors.toList());
    }

    @SafeVarargs
    static List<List<PathElement>> merge(List<List<PathElement>> prefix, List<PathElement> ... elements) {
        return Stream.concat(prefix.stream(), Stream.of(Stream.of(elements).flatMap(Collection::stream).collect(Collectors.toList()))).collect(Collectors.toList());
    }

    public static List<String> dense(List<PathElement> path) {
        return path.stream().filter(element -> element.manifest).map(element -> element.name).collect(Collectors.toList());
    }

    private static List<String> full(Function<String, String> transformer, List<PathElement> path, Function<String, String> toNamespacePrefix) {
        return path.stream().map(element -> {
            if (element.namespace == null) {
                return (String)transformer.apply(element.name);
            }
            String prefix = (String)toNamespacePrefix.apply(element.namespace);
            if (prefix.isEmpty()) {
                return (String)transformer.apply(element.name);
            }
            return prefix + ":" + (String)transformer.apply(element.name);
        }).collect(Collectors.toList());
    }

    public static String full(String infix, Function<String, String> transformer, List<PathElement> path, Function<String, String> toNamespacePrefix) {
        if (path.isEmpty()) {
            return "";
        }
        return String.join((CharSequence)infix, PathElement.full(transformer, path, toNamespacePrefix));
    }

    public static String full(String prefix, String infix, Function<String, String> transformer, List<PathElement> path, Function<String, String> toNamespacePrefix) {
        if (path.isEmpty()) {
            return prefix;
        }
        return prefix + infix + String.join((CharSequence)infix, PathElement.full(transformer, path, toNamespacePrefix));
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        PathElement that = (PathElement)object;
        if (this.manifest != that.manifest) {
            return false;
        }
        if (!this.name.equals(that.name)) {
            return false;
        }
        return this.namespace != null ? this.namespace.equals(that.namespace) : that.namespace == null;
    }

    public int hashCode() {
        int result = this.name.hashCode();
        result = 31 * result + (this.namespace != null ? this.namespace.hashCode() : 0);
        result = 31 * result + (this.manifest ? 1 : 0);
        return result;
    }

    public String toString() {
        return this.name;
    }
}

