/*
 * Decompiled with CFR 0.152.
 */
package no.skatteetaten.fastsetting.formueinntekt.felles.documentsql.api;

import java.time.LocalDate;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;
import java.util.Map;

public interface AuditMonitor {
    default public Map<String, Long> summary(LocalDate date) {
        return this.summary(date, ZoneOffset.UTC);
    }

    default public Map<String, Long> summary(LocalDate date, ZoneOffset offset) {
        return this.summary(date, offset, 0);
    }

    default public Map<String, Long> summary(LocalDate date, int range) {
        return this.summary(date, ZoneOffset.UTC, range);
    }

    default public Map<String, Long> summary(LocalDate date, ZoneOffset offset, int range) {
        return this.summary(date.minusDays(range), date.plusDays(range), offset);
    }

    default public Map<String, Long> summary(LocalDate from, LocalDate to) {
        return this.summary(from, to, ZoneOffset.UTC);
    }

    default public Map<String, Long> summary(LocalDate from, LocalDate to, ZoneOffset offset) {
        return this.summary(OffsetDateTime.of(from.atStartOfDay(), offset), OffsetDateTime.of(to.plusDays(1L).atStartOfDay(), offset));
    }

    public Map<String, Long> summary(OffsetDateTime var1, OffsetDateTime var2);
}

