/*
 * Decompiled with CFR 0.152.
 */
package no.skatteetaten.fastsetting.formueinntekt.felles.documentsql.api;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;

public class SyntheticNamespacePrefixResolver
implements Function<Set<String>, Map<String, String>> {
    private final boolean emptyToEmpty;
    private final boolean firstToEmpty;

    public SyntheticNamespacePrefixResolver() {
        this.emptyToEmpty = true;
        this.firstToEmpty = true;
    }

    public SyntheticNamespacePrefixResolver(boolean emptyToEmpty, boolean firstToEmpty) {
        this.emptyToEmpty = emptyToEmpty;
        this.firstToEmpty = firstToEmpty;
    }

    @Override
    public Map<String, String> apply(Set<String> namespaces) {
        boolean firstToEmpty;
        HashMap<String, String> prefixes = new HashMap<String, String>();
        if (this.emptyToEmpty && namespaces.contains("")) {
            prefixes.put("", "");
            firstToEmpty = false;
        } else {
            firstToEmpty = this.firstToEmpty;
        }
        int index = 0;
        for (String namespace : namespaces) {
            if (this.emptyToEmpty && namespace.isEmpty()) continue;
            if (firstToEmpty) {
                prefixes.put(namespace, "");
                firstToEmpty = false;
                continue;
            }
            prefixes.put(namespace, "ns" + ++index);
        }
        return prefixes;
    }
}

