/*
 * Decompiled with CFR 0.152.
 */
package no.skatteetaten.fastsetting.formueinntekt.felles.documentsql.api;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import no.skatteetaten.fastsetting.formueinntekt.felles.documentsql.api.NameResolver;

public class CapitalizingNameResolver
implements NameResolver {
    private static final String NO_NAME_COLUMN = "VALUE";
    public static final int ORA_MAX_LENGTH = 25;
    private final int maxLength;

    public CapitalizingNameResolver() {
        this(25);
    }

    public CapitalizingNameResolver(int maxLength) {
        if (maxLength < NO_NAME_COLUMN.length()) {
            throw new IllegalArgumentException("Length must be at least: " + NO_NAME_COLUMN.length());
        }
        this.maxLength = maxLength;
    }

    @Override
    public String resolve(List<String> elements, Predicate<String> isReserved) {
        String name;
        List identifiers = elements.stream().map(element -> element.replaceAll("([a-z])([A-Z]+)", "$1_$2").toUpperCase(Locale.US)).map(element -> element.replaceAll("[^a-zA-Z0-9_]", "_")).map(element -> element.startsWith("_") && element.length() > 1 ? element.substring(1) : element).collect(Collectors.toList());
        ArrayList<String> retained = new ArrayList<String>();
        int length = 0;
        for (int index = identifiers.size() - 1; index >= 0; --index) {
            String identifier = (String)identifiers.get(index);
            if (length + identifier.length() < this.maxLength) {
                retained.add(0, identifier);
                length += identifier.length() + 1;
                continue;
            }
            String abbreviation = CapitalizingNameResolver.toAbbreviation(elements.get(index));
            if (length + abbreviation.length() < this.maxLength) {
                retained.add(0, abbreviation);
                length += abbreviation.length() + 1;
                continue;
            }
            if (index > 0) {
                abbreviation = CapitalizingNameResolver.toAbbreviation(elements.get(0));
            }
            while ((length -= ((String)retained.remove(0)).length() + 1) + abbreviation.length() > this.maxLength - 1) {
            }
            if (retained.isEmpty()) {
                if (((String)identifiers.get(identifiers.size() - 1)).length() < this.maxLength) {
                    retained.add((String)identifiers.get(identifiers.size() - 1));
                    break;
                }
                throw new IllegalArgumentException("Cannot generate unique name for " + String.valueOf(elements));
            }
            if (length + ((String)identifiers.get(0)).length() < this.maxLength) {
                retained.add(0, (String)identifiers.get(0));
                break;
            }
            retained.add(0, abbreviation);
            break;
        }
        if (retained.isEmpty()) {
            if (identifiers.isEmpty()) {
                name = NO_NAME_COLUMN;
            } else {
                String identifier = (String)identifiers.get(identifiers.size() - 1);
                name = identifier.substring(0, Math.min(identifier.length(), this.maxLength));
            }
        } else {
            name = String.join((CharSequence)"_", retained);
        }
        int increment = 0;
        Object adjusted = name;
        while (isReserved.test((String)adjusted)) {
            adjusted = (name.length() > this.maxLength - 3 ? name.substring(0, name.length() - 3) : name) + "_" + increment++;
        }
        return adjusted;
    }

    static String toAbbreviation(String value) {
        StringBuilder abbreviation = new StringBuilder().append(Character.toUpperCase(value.charAt(0)));
        boolean lastUpper = true;
        for (int index = 1; index < value.length(); ++index) {
            if (Character.isDigit(value.charAt(index))) {
                abbreviation.append(value.charAt(index));
                continue;
            }
            if (!lastUpper && Character.isUpperCase(value.charAt(index))) {
                abbreviation.append(value.charAt(index));
                lastUpper = true;
                continue;
            }
            if (value.charAt(index) != '_' && !Character.isLowerCase(value.charAt(index))) continue;
            lastUpper = false;
        }
        return abbreviation.toString();
    }
}

