/*
 * Decompiled with CFR 0.152.
 */
package no.skatteetaten.fastsetting.formueinntekt.felles.documentsql.api;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import no.skatteetaten.fastsetting.formueinntekt.felles.documentsql.api.PathContext;
import no.skatteetaten.fastsetting.formueinntekt.felles.documentsql.api.PathElement;

public class JacksonJsonPathResolver
implements Function<Class<?>, Map<PathElement, PathContext>> {
    @Override
    public Map<PathElement, PathContext> apply(Class<?> type) {
        List<Field> fields = JacksonJsonPathResolver.toFields(type);
        for (Class<?> superClass = type.getSuperclass(); superClass != null && superClass != Object.class; superClass = superClass.getSuperclass()) {
            fields.addAll(Arrays.asList(superClass.getDeclaredFields()));
        }
        LinkedHashMap<PathElement, PathContext> elements = new LinkedHashMap<PathElement, PathContext>();
        for (Field field : fields) {
            if (JacksonJsonPathResolver.isTransient(field)) continue;
            elements.put(new PathElement(JacksonJsonPathResolver.resolve(field)), PathContext.of(field, Collections::emptyList));
        }
        return elements;
    }

    private static boolean isTransient(Field property) {
        if (property.isAnnotationPresent(JsonIgnore.class)) {
            return true;
        }
        if (property.getType().isAnnotationPresent(JsonIgnoreType.class)) {
            return true;
        }
        if (property.getType().isAnnotationPresent(JsonIgnoreProperties.class)) {
            return Arrays.asList(property.getDeclaringClass().getAnnotation(JsonIgnoreProperties.class).value()).contains(JacksonJsonPathResolver.resolve(property));
        }
        return false;
    }

    private static String resolve(Field property) {
        JsonProperty element = property.getAnnotation(JsonProperty.class);
        if (element != null) {
            return element.value().isEmpty() ? property.getName() : element.value();
        }
        return property.getName();
    }

    private static List<Field> toFields(Class<?> type) {
        ArrayList<Field> fields = new ArrayList<Field>(Arrays.asList(type.getDeclaredFields()));
        JsonSubTypes subTypes = type.getAnnotation(JsonSubTypes.class);
        if (subTypes != null) {
            for (JsonSubTypes.Type subType : subTypes.value()) {
                fields.addAll(JacksonJsonPathResolver.toFields(subType.value()));
            }
        }
        return fields;
    }
}

