/*
 * Decompiled with CFR 0.152.
 */
package no.skatteetaten.fastsetting.formueinntekt.felles.documentsql.api;

import java.lang.annotation.Annotation;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import no.skatteetaten.fastsetting.formueinntekt.felles.documentsql.api.PathElement;

public class JaxbHandler {
    private static final String DEFAULT = "##default";
    private final Class<? extends Annotation> xmlType;
    private final Class<? extends Annotation> xmlSchema;
    private final Class<? extends Annotation> xmlElement;
    private final Class<? extends Annotation> xmlElementWrapper;
    private final Class<? extends Annotation> xmlTransient;
    private final Class<? extends Annotation> xmlSeeAlso;
    private final MethodHandle xmlTypeNamespace;
    private final MethodHandle xmlSchemaNamespace;
    private final MethodHandle xmlElementName;
    private final MethodHandle xmlElementNamespace;
    private final MethodHandle xmlElementWrapperName;
    private final MethodHandle xmlElementWrapperNamespace;
    private final MethodHandle xmlSeeAlsoValue;

    private JaxbHandler(ClassLoader classLoader, String namespace) {
        try {
            this.xmlType = Class.forName(namespace + ".XmlType", true, classLoader);
            this.xmlTypeNamespace = MethodHandles.publicLookup().findVirtual(this.xmlType, "namespace", MethodType.methodType(String.class));
            this.xmlSchema = Class.forName(namespace + ".XmlSchema", true, classLoader);
            this.xmlSchemaNamespace = MethodHandles.publicLookup().findVirtual(this.xmlSchema, "namespace", MethodType.methodType(String.class));
            this.xmlElement = Class.forName(namespace + ".XmlElement", true, classLoader);
            this.xmlElementName = MethodHandles.publicLookup().findVirtual(this.xmlElement, "name", MethodType.methodType(String.class));
            this.xmlElementNamespace = MethodHandles.publicLookup().findVirtual(this.xmlElement, "namespace", MethodType.methodType(String.class));
            this.xmlElementWrapper = Class.forName(namespace + ".XmlElementWrapper", true, classLoader);
            this.xmlElementWrapperName = MethodHandles.publicLookup().findVirtual(this.xmlElementWrapper, "name", MethodType.methodType(String.class));
            this.xmlElementWrapperNamespace = MethodHandles.publicLookup().findVirtual(this.xmlElementWrapper, "namespace", MethodType.methodType(String.class));
            this.xmlTransient = Class.forName(namespace + ".XmlTransient", true, classLoader);
            this.xmlSeeAlso = Class.forName(namespace + ".XmlSeeAlso", true, classLoader);
            this.xmlSeeAlsoValue = MethodHandles.publicLookup().findVirtual(this.xmlSeeAlso, "value", MethodType.methodType(Class[].class));
        }
        catch (Exception e) {
            throw new IllegalStateException("Could not resolve JAXB for namespace " + namespace + " in " + String.valueOf(classLoader), e);
        }
    }

    public static JaxbHandler ofJavax() {
        return JaxbHandler.ofJavax(JaxbHandler.class.getClassLoader());
    }

    public static JaxbHandler ofJavax(ClassLoader classLoader) {
        return new JaxbHandler(classLoader, "javax.xml.bind.annotation");
    }

    public static JaxbHandler ofJakarta() {
        return JaxbHandler.ofJakarta(JaxbHandler.class.getClassLoader());
    }

    public static JaxbHandler ofJakarta(ClassLoader classLoader) {
        return new JaxbHandler(classLoader, "jakarta.xml.bind.annotation");
    }

    boolean isXmlType(Class<?> type) {
        return type.isAnnotationPresent(this.xmlType);
    }

    boolean isXmlTransient(Field field) {
        return field.isAnnotationPresent(this.xmlTransient);
    }

    Optional<String> toNamespace(Class<?> property) {
        try {
            Annotation type = property.getAnnotation(this.xmlType);
            if (type != null && !this.xmlTypeNamespace.invoke(type).equals(DEFAULT)) {
                return Optional.of(this.xmlTypeNamespace.invoke(type)).filter(namespace -> !namespace.isEmpty());
            }
            if (property.getPackage() == null) {
                return Optional.empty();
            }
            Annotation schema = property.getPackage().getAnnotation(this.xmlSchema);
            return schema == null || this.xmlSchemaNamespace.invoke(schema).isEmpty() ? Optional.empty() : Optional.of(this.xmlSchemaNamespace.invoke(schema));
        }
        catch (Throwable t) {
            throw new IllegalStateException(t);
        }
    }

    Optional<PathElement> toElement(Field field) {
        return Optional.ofNullable(field.getAnnotation(this.xmlElement)).map(element -> {
            try {
                return new PathElement(this.xmlElementName.invoke((Annotation)element).equals(DEFAULT) ? field.getName() : this.xmlElementName.invoke((Annotation)element), this.xmlElementNamespace.invoke((Annotation)element).equals(DEFAULT) || this.xmlElementNamespace.invoke((Annotation)element).isEmpty() ? (String)this.toNamespace(field.getDeclaringClass()).orElse(null) : this.xmlElementNamespace.invoke((Annotation)element));
            }
            catch (Throwable t) {
                throw new IllegalStateException(t);
            }
        });
    }

    Optional<PathElement> toWrapper(Field field, PathElement pathElement) {
        return Optional.ofNullable(field.getAnnotation(this.xmlElementWrapper)).map(elementWrapper -> {
            try {
                return new PathElement(this.xmlElementWrapperName.invoke((Annotation)elementWrapper).equals(DEFAULT) ? field.getName() : this.xmlElementWrapperName.invoke((Annotation)elementWrapper), this.xmlElementWrapperNamespace.invoke((Annotation)elementWrapper).equals(DEFAULT) || this.xmlElementWrapperNamespace.invoke((Annotation)elementWrapper).isEmpty() ? (String)this.toNamespace(field.getDeclaringClass()).orElse(null) : this.xmlElementWrapperNamespace.invoke((Annotation)elementWrapper), false);
            }
            catch (Throwable t) {
                throw new IllegalStateException(t);
            }
        });
    }

    List<Field> toFields(Class<?> type) {
        ArrayList<Field> fields = new ArrayList<Field>(Arrays.asList(type.getDeclaredFields()));
        Annotation seeAlso = type.getAnnotation(this.xmlSeeAlso);
        if (seeAlso != null) {
            Class[] values;
            try {
                values = this.xmlSeeAlsoValue.invoke(seeAlso);
            }
            catch (Throwable t) {
                throw new IllegalStateException(t);
            }
            for (Class specialization : values) {
                fields.addAll(this.toFields(specialization));
            }
        }
        return fields;
    }
}

