/*
 * Decompiled with CFR 0.152.
 */
package no.skatteetaten.fastsetting.formueinntekt.felles.documentsql.api;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import no.skatteetaten.fastsetting.formueinntekt.felles.documentsql.api.JaxbHandler;
import no.skatteetaten.fastsetting.formueinntekt.felles.documentsql.api.PathContext;
import no.skatteetaten.fastsetting.formueinntekt.felles.documentsql.api.PathElement;

public class JaxbPathResolver
implements Function<Class<?>, Map<PathElement, PathContext>> {
    private final JaxbHandler handler;

    public JaxbPathResolver(JaxbHandler handler) {
        this.handler = handler;
    }

    @Override
    public Map<PathElement, PathContext> apply(Class<?> type) {
        List<Field> fields = this.handler.toFields(type);
        for (Class<?> superClass = type.getSuperclass(); superClass != null && this.handler.isXmlType(superClass); superClass = superClass.getSuperclass()) {
            fields.addAll(Arrays.asList(superClass.getDeclaredFields()));
        }
        LinkedHashMap<PathElement, PathContext> elements = new LinkedHashMap<PathElement, PathContext>();
        for (Field field : fields) {
            if (this.handler.isXmlTransient(field) || Modifier.isStatic(field.getModifiers())) continue;
            PathElement pathElement = this.handler.toElement(field).orElseGet(() -> new PathElement(field.getName(), this.handler.toNamespace(field.getDeclaringClass()).orElse(null)));
            elements.put(pathElement, PathContext.of(field, () -> this.handler.toWrapper(field, pathElement).map(Collections::singletonList).orElseGet(Collections::emptyList)));
        }
        return elements;
    }
}

