/*
 * Decompiled with CFR 0.152.
 */
package no.skatteetaten.fastsetting.formueinntekt.felles.documentsql.api;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Predicate;
import javax.sql.DataSource;
import no.skatteetaten.fastsetting.formueinntekt.felles.documentsql.api.CapitalizingNameResolver;
import no.skatteetaten.fastsetting.formueinntekt.felles.documentsql.api.JdbcDispatcherFactory;
import no.skatteetaten.fastsetting.formueinntekt.felles.documentsql.api.NameResolver;
import no.skatteetaten.fastsetting.formueinntekt.felles.documentsql.api.PathElement;
import no.skatteetaten.fastsetting.formueinntekt.felles.documentsql.api.RevisionedId;
import no.skatteetaten.fastsetting.formueinntekt.felles.documentsql.api.SimpleTableResolver;
import no.skatteetaten.fastsetting.formueinntekt.felles.documentsql.api.SimpleViewResolver;
import no.skatteetaten.fastsetting.formueinntekt.felles.documentsql.api.TableResolver;
import no.skatteetaten.fastsetting.formueinntekt.felles.documentsql.api.ViewResolver;

public interface JdbcDispatcher<T> {
    public static Builder<String> of(JdbcDispatcherFactory factory) {
        return new Builder<String>(factory, new SimpleViewResolver(), new CapitalizingNameResolver(), SimpleTableResolver.ofString());
    }

    default public void printToEach(Consumer<String> consumer) {
        this.printTo(strings -> strings.forEach(consumer));
    }

    public void printTo(Consumer<List<String>> var1);

    default public void create(DataSource dataSource) throws SQLException {
        this.create(dataSource, (String sql) -> {});
    }

    default public void create(DataSource dataSource, Consumer<String> callback) throws SQLException {
        this.create(dataSource, Collections.emptySet(), callback);
    }

    default public void create(DataSource dataSource, Collection<String> users) throws SQLException {
        this.create(dataSource, users, sql -> {});
    }

    public void create(DataSource var1, Collection<String> var2, Consumer<String> var3) throws SQLException;

    default public void drop(DataSource dataSource) throws SQLException {
        this.drop(dataSource, sql -> {});
    }

    default public void drop(DataSource dataSource, Consumer<String> callback) throws SQLException {
        this.drop(dataSource, callback, exception -> false);
    }

    public void drop(DataSource var1, Consumer<String> var2, Predicate<SQLException> var3) throws SQLException;

    default public void insert(Connection conn, String id, T payload) throws SQLException {
        this.insert(conn, id, 1, payload);
    }

    default public void insert(Connection conn, String id, int revision, T payload) throws SQLException {
        this.insert(conn, id, revision, false, payload);
    }

    default public void insert(Connection conn, String id, int revision, boolean deleted, T payload) throws SQLException {
        this.insert(conn, new RevisionedId(id, revision, deleted), payload);
    }

    default public void insert(Connection conn, RevisionedId id, T payload) throws SQLException {
        this.insert(conn, Collections.singletonMap(id, payload));
    }

    public void insert(Connection var1, Map<RevisionedId, T> var2) throws SQLException;

    default public void insert(DataSource dataSource, String id, T payload) throws SQLException {
        try (Connection conn = dataSource.getConnection();){
            this.insert(conn, id, payload);
        }
    }

    default public void insert(DataSource dataSource, String id, int revision, T payload) throws SQLException {
        try (Connection conn = dataSource.getConnection();){
            this.insert(conn, id, revision, payload);
        }
    }

    default public void insert(DataSource dataSource, String id, int revision, boolean deleted, T payload) throws SQLException {
        try (Connection conn = dataSource.getConnection();){
            this.insert(conn, id, revision, deleted, payload);
        }
    }

    default public void insert(DataSource dataSource, RevisionedId id, T payload) throws SQLException {
        try (Connection conn = dataSource.getConnection();){
            this.insert(conn, id, payload);
        }
    }

    default public void insert(DataSource dataSource, Map<RevisionedId, T> payloads) throws SQLException {
        try (Connection conn = dataSource.getConnection();){
            this.insert(conn, payloads);
        }
    }

    public void truncate(DataSource var1) throws SQLException;

    public static class Builder<T> {
        private final JdbcDispatcherFactory factory;
        private final ViewResolver viewResolver;
        private final NameResolver nameResolver;
        private final TableResolver<T> tableResolver;

        private Builder(JdbcDispatcherFactory factory, ViewResolver viewResolver, NameResolver nameResolver, TableResolver<T> tableResolver) {
            this.factory = factory;
            this.viewResolver = viewResolver;
            this.nameResolver = nameResolver;
            this.tableResolver = tableResolver;
        }

        public Builder<T> withViewResolver(ViewResolver viewResolver) {
            return new Builder<T>(this.factory, viewResolver, this.nameResolver, this.tableResolver);
        }

        public Builder<T> withNameResolver(NameResolver nameResolver) {
            return new Builder<T>(this.factory, this.viewResolver, nameResolver, this.tableResolver);
        }

        public <S> Builder<S> withTableResolver(TableResolver<S> tableResolver) {
            return new Builder<S>(this.factory, this.viewResolver, this.nameResolver, tableResolver);
        }

        public JdbcDispatcher<T> build(String name, Class<?> type) {
            return this.build(name, type, new PathElement[0]);
        }

        public JdbcDispatcher<T> build(String name, Class<?> type, String ... roots) {
            return this.build(name, type, (PathElement[])Arrays.stream(roots).map(PathElement::new).toArray(PathElement[]::new));
        }

        public JdbcDispatcher<T> build(String name, Class<?> type, PathElement ... roots) {
            return this.build(name, type, roots.length == 0 ? Collections.emptyList() : Collections.singletonList(Arrays.asList(roots)));
        }

        public JdbcDispatcher<T> build(String name, Class<?> type, List<List<PathElement>> roots) {
            return this.factory.create(name, this.viewResolver.resolve(type, roots), this.nameResolver, this.tableResolver);
        }
    }
}

