/*
 * Decompiled with CFR 0.152.
 */
package no.skatteetaten.fastsetting.formueinntekt.felles.documentsql.api;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.time.Duration;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.MonthDay;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.time.Year;
import java.time.YearMonth;
import java.time.ZonedDateTime;
import java.util.ArrayDeque;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiPredicate;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import no.skatteetaten.fastsetting.formueinntekt.felles.documentsql.api.PathContext;
import no.skatteetaten.fastsetting.formueinntekt.felles.documentsql.api.PathElement;
import no.skatteetaten.fastsetting.formueinntekt.felles.documentsql.api.SimplePathResolver;
import no.skatteetaten.fastsetting.formueinntekt.felles.documentsql.api.ViewResolver;

public class SimpleViewResolver
implements ViewResolver {
    private static final String JAXB_XML_CALENDAR = "javax.xml.datatype.XMLGregorianCalendar";
    private static final String JAKARTA_XML_CALENDAR = "jakarta.xml.datatype.XMLGregorianCalendar";
    private static final Set<Class<?>> TERMINAL_TYPES = Set.of(Boolean.TYPE, Boolean.class, Byte.TYPE, Byte.class, Short.TYPE, Short.class, Character.TYPE, Character.class, Integer.TYPE, Integer.class, Long.TYPE, Long.class, Float.TYPE, Float.class, Double.TYPE, Double.class, Number.class, BigDecimal.class, BigInteger.class, Year.class, Object.class, String.class, Date.class, Duration.class, MonthDay.class, YearMonth.class, LocalTime.class, LocalDate.class, LocalDateTime.class, OffsetTime.class, OffsetDateTime.class, ZonedDateTime.class);
    private final Function<Class<?>, Map<PathElement, PathContext>> resolver;
    private final Predicate<Class<?>> isTerminal;
    private final BiPredicate<List<List<PathElement>>, Class<?>> filter;

    public SimpleViewResolver() {
        this.resolver = new SimplePathResolver();
        this.isTerminal = type -> TERMINAL_TYPES.contains(type) || type.getName().equals(JAXB_XML_CALENDAR) || type.getName().equals(JAKARTA_XML_CALENDAR);
        this.filter = (elements, type) -> type != Object.class;
    }

    public SimpleViewResolver(Function<Class<?>, Map<PathElement, PathContext>> resolver) {
        this.resolver = resolver;
        this.isTerminal = type -> TERMINAL_TYPES.contains(type) || type.getName().equals(JAXB_XML_CALENDAR) || type.getName().equals(JAKARTA_XML_CALENDAR);
        this.filter = (elements, type) -> type != Object.class;
    }

    public SimpleViewResolver(BiPredicate<List<String>, Class<?>> filter) {
        this.resolver = new SimplePathResolver();
        this.isTerminal = type -> TERMINAL_TYPES.contains(type) || type.getName().equals(JAXB_XML_CALENDAR) || type.getName().equals(JAKARTA_XML_CALENDAR);
        this.filter = (elements, type) -> type != Object.class && filter.test(PathElement.dense(elements.stream().flatMap(Collection::stream).collect(Collectors.toList())), (Class<?>)type);
    }

    public SimpleViewResolver(Function<Class<?>, Map<PathElement, PathContext>> resolver, BiPredicate<List<String>, Class<?>> filter) {
        this.resolver = resolver;
        this.isTerminal = type -> TERMINAL_TYPES.contains(type) || type.getName().equals(JAXB_XML_CALENDAR) || type.getName().equals(JAKARTA_XML_CALENDAR);
        this.filter = (elements, type) -> type != Object.class && filter.test(PathElement.dense(elements.stream().flatMap(Collection::stream).collect(Collectors.toList())), (Class<?>)type);
    }

    public SimpleViewResolver(Function<Class<?>, Map<PathElement, PathContext>> resolver, Predicate<Class<?>> isTerminal, BiPredicate<List<List<PathElement>>, Class<?>> filter) {
        this.resolver = resolver;
        this.isTerminal = isTerminal;
        this.filter = filter;
    }

    @Override
    public Map<List<List<PathElement>>, Map<List<PathElement>, Class<?>>> resolve(Class<?> type, List<List<PathElement>> roots) {
        if (!this.filter.test(roots, type)) {
            return Collections.emptyMap();
        }
        LinkedHashMap views = new LinkedHashMap();
        ArrayDeque work = new ArrayDeque();
        work.add(Map.entry(roots, new ChainedValue(type, type)));
        do {
            Map.Entry current;
            if (((Class)((ChainedValue)(current = (Map.Entry)work.removeFirst()).getValue()).getValue()).isEnum() || this.isTerminal.test((Class)((ChainedValue)current.getValue()).getValue())) {
                views.put((List)current.getKey(), Collections.singletonMap(Collections.emptyList(), (Class)((ChainedValue)current.getValue()).getValue()));
                continue;
            }
            LinkedHashMap properties = new LinkedHashMap();
            ArrayDeque unresolved = new ArrayDeque();
            this.resolver.apply((Class)((ChainedValue)current.getValue()).getValue()).forEach((element, context) -> unresolved.addLast(Map.entry(Collections.singletonList(element), new ChainedValue<PathContext>((PathContext)context))));
            while (!unresolved.isEmpty()) {
                Map.Entry entry = (Map.Entry)unresolved.removeFirst();
                ((PathContext)((ChainedValue)entry.getValue()).getValue()).accept(property -> {
                    if (this.filter.test(PathElement.merge((List)current.getKey(), (List)entry.getKey()), (Class<?>)property)) {
                        if (property.isEnum() || this.isTerminal.test((Class<?>)property)) {
                            properties.put((List)entry.getKey(), property);
                        } else {
                            this.resolver.apply((Class<?>)property).forEach((element, context) -> unresolved.addLast(Map.entry(PathElement.merge((List)entry.getKey(), element), ((ChainedValue)entry.getValue()).chain(context, (Class<?>)property))));
                        }
                    }
                }, (property, wrappers) -> {
                    List<List<PathElement>> paths = PathElement.merge((List)current.getKey(), wrappers, (List)entry.getKey());
                    if (this.filter.test(paths, (Class<?>)property)) {
                        work.addLast(Map.entry(paths, ((ChainedValue)current.getValue()).chain(property, (Class<?>)property)));
                    }
                });
            }
            if (properties.isEmpty()) continue;
            views.put((List)current.getKey(), properties);
        } while (!work.isEmpty());
        return views;
    }

    static class ChainedValue<T> {
        private final T value;
        private final Set<Class<?>> previous;

        ChainedValue(T value) {
            this.value = value;
            this.previous = Collections.emptySet();
        }

        ChainedValue(T value, Class<?> type) {
            this.value = value;
            this.previous = Collections.singleton(type);
        }

        private ChainedValue(T value, Set<Class<?>> previous) {
            this.value = value;
            this.previous = previous;
        }

        T getValue() {
            return this.value;
        }

        ChainedValue<T> chain(T value, Class<?> type) {
            LinkedHashSet previous = new LinkedHashSet(this.previous);
            if (previous.add(type)) {
                return new ChainedValue<T>(value, previous);
            }
            throw new IllegalArgumentException(previous.stream().map(Class::getTypeName).collect(Collectors.joining(" -> ", "Cannot resolve chain with recursive occurrence of " + String.valueOf(type) + " via ", "")));
        }
    }
}

