/*
 * Decompiled with CFR 0.152.
 */
package no.skatteetaten.fastsetting.formueinntekt.felles.task.api;

import no.skatteetaten.fastsetting.formueinntekt.felles.task.api.TaskDecision;
import no.skatteetaten.fastsetting.formueinntekt.felles.task.api.TaskResult;

public class TaskResultException
extends RuntimeException {
    private final TaskResult result;
    private final boolean continued;

    public TaskResultException(TaskResult result) {
        this.result = result;
        this.continued = result == TaskResult.SUCCESS;
    }

    public TaskResultException(TaskResult result, boolean continued) {
        this.result = result;
        this.continued = continued;
    }

    public TaskResultException(String message) {
        super(message);
        this.result = TaskResult.FAILURE;
        this.continued = false;
    }

    public TaskResultException(Throwable cause) {
        super(cause);
        this.result = TaskResult.FAILURE;
        this.continued = false;
    }

    public TaskResultException(TaskResult result, Throwable cause) {
        super(cause);
        this.result = result;
        this.continued = result == TaskResult.SUCCESS;
    }

    public TaskResultException(TaskResult result, String message) {
        super(message);
        this.result = result;
        this.continued = result == TaskResult.SUCCESS;
    }

    public TaskResultException(TaskResult result, Throwable cause, boolean continued) {
        super(cause);
        this.result = result;
        this.continued = continued;
    }

    public TaskResultException(TaskResult result, String message, boolean continued) {
        super(message);
        this.result = result;
        this.continued = continued;
    }

    public TaskResult getResult() {
        return this.result;
    }

    public TaskDecision toDecision() {
        TaskDecision decision = this.getCause() == null ? new TaskDecision(this.result, this.getMessage()) : new TaskDecision(this.result, this.getCause());
        return decision.withContinuation(this.continued);
    }
}

