/*
 * Decompiled with CFR 0.152.
 */
package no.skatteetaten.fastsetting.formueinntekt.felles.task.api;

import java.util.Map;
import java.util.Optional;
import no.skatteetaten.fastsetting.formueinntekt.felles.task.api.Task;
import no.skatteetaten.fastsetting.formueinntekt.felles.task.api.TaskResult;
import no.skatteetaten.fastsetting.formueinntekt.felles.task.api.TaskState;

public interface TaskReviver<TRANSACTION, EXCEPTION extends Exception> {
    default public Optional<Task> recreate(TRANSACTION transaction, String topic, Revivification revivification, Revived revived) throws EXCEPTION {
        return this.recreate(transaction, topic, revivification, revived, 1).values().stream().findFirst();
    }

    default public Map<Task, Task> recreate(TRANSACTION transaction, String topic, Revivification revivification, Revived revived, int size) throws EXCEPTION {
        return this.recreate(transaction, topic, revivification, revived, 0L, Long.MAX_VALUE, size);
    }

    public Map<Task, Task> recreate(TRANSACTION var1, String var2, Revivification var3, Revived var4, long var5, long var7, int var9) throws EXCEPTION;

    public static enum Revivification {
        APPEND,
        REPLACE,
        RESET;

    }

    public static enum Revived {
        EXPIRED(TaskState.EXPIRED),
        SUCCEEDED(TaskState.SUCCEEDED),
        SUSPENDED(TaskState.SUSPENDED),
        FILTERED(TaskState.FILTERED),
        FAILED(TaskState.FAILED);

        private final TaskState state;

        private Revived(TaskState state) {
            this.state = state;
        }

        public static Revived of(TaskResult result) {
            switch (result) {
                case SUCCESS: {
                    return SUCCEEDED;
                }
                case SUSPENSION: {
                    return SUSPENDED;
                }
                case FILTER: {
                    return FILTERED;
                }
                case FAILURE: {
                    return FAILED;
                }
            }
            throw new IllegalStateException();
        }

        public TaskState toState() {
            return this.state;
        }
    }
}

