/*
 * Decompiled with CFR 0.152.
 */
package no.skatteetaten.fastsetting.formueinntekt.felles.task.processor;

import java.util.function.Supplier;

@FunctionalInterface
public interface TaskDispatcher<TRANSACTION, EXCEPTION extends Exception> {
    default public void accept(TransactionConsumer<TRANSACTION, EXCEPTION> consumer) throws EXCEPTION {
        this.apply(transaction -> {
            consumer.accept(transaction);
            return null;
        });
    }

    public <PAYLOAD> PAYLOAD apply(TransactionFunction<TRANSACTION, EXCEPTION, PAYLOAD> var1) throws EXCEPTION;

    public static <TRANSACTION, EXCEPTION extends Exception> TaskDispatcher<TRANSACTION, EXCEPTION> simple(final Supplier<TRANSACTION> supplier) {
        return new TaskDispatcher<TRANSACTION, EXCEPTION>(){

            @Override
            public <PAYLOAD> PAYLOAD apply(TransactionFunction<TRANSACTION, EXCEPTION, PAYLOAD> function) throws Exception {
                return function.apply(supplier.get());
            }
        };
    }

    @FunctionalInterface
    public static interface TransactionConsumer<TRANSACTION, EXCEPTION extends Exception> {
        public void accept(TRANSACTION var1) throws EXCEPTION;
    }

    @FunctionalInterface
    public static interface TransactionFunction<TRANSACTION, EXCEPTION extends Exception, PAYLOAD> {
        public PAYLOAD apply(TRANSACTION var1) throws EXCEPTION;
    }
}

