/*
 * Decompiled with CFR 0.152.
 */
package com.actigence.aal;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import javax.servlet.ReadListener;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpRequestCachingWrapper
extends HttpServletRequestWrapper {
    private static final Logger log = LoggerFactory.getLogger(HttpRequestCachingWrapper.class);
    private final String body;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HttpRequestCachingWrapper(HttpServletRequest httpServletRequest) throws IOException {
        super(httpServletRequest);
        StringBuilder stringBuilder = new StringBuilder();
        BufferedReader bufferedReader = null;
        try {
            ServletInputStream inputStream = httpServletRequest.getInputStream();
            if (inputStream != null) {
                bufferedReader = new BufferedReader(new InputStreamReader((InputStream)inputStream));
                char[] charBuffer = new char[128];
                int bytesRead = bufferedReader.read(charBuffer);
                while (bytesRead > 0) {
                    stringBuilder.append(charBuffer, 0, bytesRead);
                    bytesRead = bufferedReader.read(charBuffer);
                }
            }
        }
        finally {
            if (bufferedReader != null) {
                try {
                    bufferedReader.close();
                }
                catch (IOException iOException) {}
            }
        }
        this.body = stringBuilder.toString();
    }

    public BufferedReader getReader() {
        return new BufferedReader(new InputStreamReader((InputStream)this.getInputStream()));
    }

    public ServletInputStream getInputStream() {
        final ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(this.body.getBytes());
        return new ServletInputStream(){

            public boolean isFinished() {
                return false;
            }

            public boolean isReady() {
                return false;
            }

            public void setReadListener(ReadListener listener) {
            }

            public int read() {
                return byteArrayInputStream.read();
            }
        };
    }

    public String getBody() {
        return this.body;
    }
}

