/*
 * Decompiled with CFR 0.152.
 */
package com.actigence.aal;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import javax.servlet.ServletOutputStream;
import javax.servlet.WriteListener;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpServletResponseWrapper;

public class HttpResponseCachingWrapper
extends HttpServletResponseWrapper {
    private ByteArrayPrintWriter byteArrayPrintWriter = new ByteArrayPrintWriter();
    private byte[] bytes;
    private final HttpServletResponse httpServletResponse;

    public HttpResponseCachingWrapper(HttpServletResponse response) {
        super(response);
        this.httpServletResponse = response;
    }

    public PrintWriter getWriter() throws IOException {
        return this.byteArrayPrintWriter.getWriter();
    }

    public ServletOutputStream getOutputStream() {
        return this.byteArrayPrintWriter.stream;
    }

    public byte[] getBytes() {
        if (this.bytes == null) {
            this.bytes = this.byteArrayPrintWriter.toByteArray();
        }
        return this.bytes;
    }

    public int getStatusCode() {
        return this.httpServletResponse.getStatus();
    }

    private static class ByteArrayServletStream
    extends ServletOutputStream {
        private final ByteArrayOutputStream byteArrayOutputStream;

        private ByteArrayServletStream(ByteArrayOutputStream baos) {
            this.byteArrayOutputStream = baos;
        }

        public boolean isReady() {
            return false;
        }

        public void setWriteListener(WriteListener writeListener) {
        }

        public void write(int b) throws IOException {
            this.byteArrayOutputStream.write(b);
        }
    }

    private static class ByteArrayPrintWriter {
        private ByteArrayOutputStream baos = new ByteArrayOutputStream();
        private PrintWriter writer = new PrintWriter(this.baos);
        ServletOutputStream stream = new ByteArrayServletStream(this.baos);

        private ByteArrayPrintWriter() {
        }

        byte[] toByteArray() {
            return this.baos.toByteArray();
        }

        public PrintWriter getWriter() {
            return this.writer;
        }
    }
}

