/*
 * Decompiled with CFR 0.152.
 */
package com.actigence.aal.dto;

import com.actigence.aal.dto.NameValue;
import java.time.ZonedDateTime;
import java.util.LinkedList;
import java.util.List;

public class ApiAccessLog {
    private String logId;
    private String clientId;
    private String requestUri;
    private String requestQueryString;
    private List<NameValue> requestHeaders;
    private String requestHttpMethod;
    private String requestBody;
    private int responseHttpStatus;
    private String responseBody;
    private ZonedDateTime requestStartTime;
    private ZonedDateTime requestEndTime;

    private void addHeader(String name, String value) {
        if (this.requestHeaders == null) {
            this.requestHeaders = new LinkedList<NameValue>();
        }
        this.requestHeaders.add(new NameValue(name, value));
    }

    ApiAccessLog(String logId, String clientId, String requestUri, String requestQueryString, List<NameValue> requestHeaders, String requestHttpMethod, String requestBody, int responseHttpStatus, String responseBody, ZonedDateTime requestStartTime, ZonedDateTime requestEndTime) {
        this.logId = logId;
        this.clientId = clientId;
        this.requestUri = requestUri;
        this.requestQueryString = requestQueryString;
        this.requestHeaders = requestHeaders;
        this.requestHttpMethod = requestHttpMethod;
        this.requestBody = requestBody;
        this.responseHttpStatus = responseHttpStatus;
        this.responseBody = responseBody;
        this.requestStartTime = requestStartTime;
        this.requestEndTime = requestEndTime;
    }

    public static ApiAccessLogBuilder builder() {
        return new ApiAccessLogBuilder();
    }

    public void setLogId(String logId) {
        this.logId = logId;
    }

    public void setClientId(String clientId) {
        this.clientId = clientId;
    }

    public void setRequestUri(String requestUri) {
        this.requestUri = requestUri;
    }

    public void setRequestQueryString(String requestQueryString) {
        this.requestQueryString = requestQueryString;
    }

    public void setRequestHeaders(List<NameValue> requestHeaders) {
        this.requestHeaders = requestHeaders;
    }

    public void setRequestHttpMethod(String requestHttpMethod) {
        this.requestHttpMethod = requestHttpMethod;
    }

    public void setRequestBody(String requestBody) {
        this.requestBody = requestBody;
    }

    public void setResponseHttpStatus(int responseHttpStatus) {
        this.responseHttpStatus = responseHttpStatus;
    }

    public void setResponseBody(String responseBody) {
        this.responseBody = responseBody;
    }

    public void setRequestStartTime(ZonedDateTime requestStartTime) {
        this.requestStartTime = requestStartTime;
    }

    public void setRequestEndTime(ZonedDateTime requestEndTime) {
        this.requestEndTime = requestEndTime;
    }

    public String getLogId() {
        return this.logId;
    }

    public String getClientId() {
        return this.clientId;
    }

    public String getRequestUri() {
        return this.requestUri;
    }

    public String getRequestQueryString() {
        return this.requestQueryString;
    }

    public List<NameValue> getRequestHeaders() {
        return this.requestHeaders;
    }

    public String getRequestHttpMethod() {
        return this.requestHttpMethod;
    }

    public String getRequestBody() {
        return this.requestBody;
    }

    public int getResponseHttpStatus() {
        return this.responseHttpStatus;
    }

    public String getResponseBody() {
        return this.responseBody;
    }

    public ZonedDateTime getRequestStartTime() {
        return this.requestStartTime;
    }

    public ZonedDateTime getRequestEndTime() {
        return this.requestEndTime;
    }

    public String toString() {
        return "ApiAccessLog(logId=" + this.getLogId() + ", clientId=" + this.getClientId() + ", requestUri=" + this.getRequestUri() + ", requestQueryString=" + this.getRequestQueryString() + ", requestHeaders=" + this.getRequestHeaders() + ", requestHttpMethod=" + this.getRequestHttpMethod() + ", requestBody=" + this.getRequestBody() + ", responseHttpStatus=" + this.getResponseHttpStatus() + ", responseBody=" + this.getResponseBody() + ", requestStartTime=" + this.getRequestStartTime() + ", requestEndTime=" + this.getRequestEndTime() + ")";
    }

    public static class ApiAccessLogBuilder {
        private String logId;
        private String clientId;
        private String requestUri;
        private String requestQueryString;
        private List<NameValue> requestHeaders;
        private String requestHttpMethod;
        private String requestBody;
        private int responseHttpStatus;
        private String responseBody;
        private ZonedDateTime requestStartTime;
        private ZonedDateTime requestEndTime;

        ApiAccessLogBuilder() {
        }

        public ApiAccessLogBuilder logId(String logId) {
            this.logId = logId;
            return this;
        }

        public ApiAccessLogBuilder clientId(String clientId) {
            this.clientId = clientId;
            return this;
        }

        public ApiAccessLogBuilder requestUri(String requestUri) {
            this.requestUri = requestUri;
            return this;
        }

        public ApiAccessLogBuilder requestQueryString(String requestQueryString) {
            this.requestQueryString = requestQueryString;
            return this;
        }

        public ApiAccessLogBuilder requestHeaders(List<NameValue> requestHeaders) {
            this.requestHeaders = requestHeaders;
            return this;
        }

        public ApiAccessLogBuilder requestHttpMethod(String requestHttpMethod) {
            this.requestHttpMethod = requestHttpMethod;
            return this;
        }

        public ApiAccessLogBuilder requestBody(String requestBody) {
            this.requestBody = requestBody;
            return this;
        }

        public ApiAccessLogBuilder responseHttpStatus(int responseHttpStatus) {
            this.responseHttpStatus = responseHttpStatus;
            return this;
        }

        public ApiAccessLogBuilder responseBody(String responseBody) {
            this.responseBody = responseBody;
            return this;
        }

        public ApiAccessLogBuilder requestStartTime(ZonedDateTime requestStartTime) {
            this.requestStartTime = requestStartTime;
            return this;
        }

        public ApiAccessLogBuilder requestEndTime(ZonedDateTime requestEndTime) {
            this.requestEndTime = requestEndTime;
            return this;
        }

        public ApiAccessLog build() {
            return new ApiAccessLog(this.logId, this.clientId, this.requestUri, this.requestQueryString, this.requestHeaders, this.requestHttpMethod, this.requestBody, this.responseHttpStatus, this.responseBody, this.requestStartTime, this.requestEndTime);
        }

        public String toString() {
            return "ApiAccessLog.ApiAccessLogBuilder(logId=" + this.logId + ", clientId=" + this.clientId + ", requestUri=" + this.requestUri + ", requestQueryString=" + this.requestQueryString + ", requestHeaders=" + this.requestHeaders + ", requestHttpMethod=" + this.requestHttpMethod + ", requestBody=" + this.requestBody + ", responseHttpStatus=" + this.responseHttpStatus + ", responseBody=" + this.responseBody + ", requestStartTime=" + this.requestStartTime + ", requestEndTime=" + this.requestEndTime + ")";
        }
    }
}

