/*
 * Decompiled with CFR 0.152.
 */
package com.aerospike.mapper.tools;

import com.aerospike.client.AerospikeException;
import com.aerospike.client.Bin;
import com.aerospike.client.IAerospikeClient;
import com.aerospike.client.Key;
import com.aerospike.client.Record;
import com.aerospike.client.Value;
import com.aerospike.client.policy.BatchPolicy;
import com.aerospike.client.policy.Policy;
import com.aerospike.client.policy.QueryPolicy;
import com.aerospike.client.policy.RecordExistsAction;
import com.aerospike.client.policy.ScanPolicy;
import com.aerospike.client.policy.WritePolicy;
import com.aerospike.client.query.RecordSet;
import com.aerospike.client.query.Statement;
import com.aerospike.mapper.tools.ClassCache;
import com.aerospike.mapper.tools.ClassCacheEntry;
import com.aerospike.mapper.tools.GenericTypeMapper;
import com.aerospike.mapper.tools.IAeroMapper;
import com.aerospike.mapper.tools.LoadedObjectResolver;
import com.aerospike.mapper.tools.ThreadLocalKeySaver;
import com.aerospike.mapper.tools.configuration.ClassConfig;
import com.aerospike.mapper.tools.configuration.Configuration;
import com.aerospike.mapper.tools.converters.MappingConverter;
import com.aerospike.mapper.tools.utils.MapperUtils;
import com.aerospike.mapper.tools.utils.TypeUtils;
import com.aerospike.mapper.tools.virtuallist.VirtualList;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import javax.validation.constraints.NotNull;
import org.apache.commons.lang3.StringUtils;

public class AeroMapper
implements IAeroMapper {
    private final IAerospikeClient mClient;
    private final MappingConverter mappingConverter;

    private AeroMapper(@NotNull IAerospikeClient client) {
        this.mClient = client;
        this.mappingConverter = new MappingConverter(this, this.mClient);
    }

    @Override
    public void save(Object ... objects) throws AerospikeException {
        for (Object thisObject : objects) {
            this.save(thisObject, new String[0]);
        }
    }

    @Override
    public void save(@NotNull Object object, String ... binNames) throws AerospikeException {
        this.save(null, object, RecordExistsAction.REPLACE, binNames);
    }

    @Override
    public void save(@NotNull WritePolicy writePolicy, @NotNull Object object, String ... binNames) throws AerospikeException {
        this.save(writePolicy, (Object)object, (RecordExistsAction)null, binNames);
    }

    private <T> void save(WritePolicy writePolicy, @NotNull T object, RecordExistsAction recordExistsAction, String[] binNames) {
        String set;
        Class<?> clazz = object.getClass();
        ClassCacheEntry<?> entry = MapperUtils.getEntryAndValidateNamespace(clazz, this);
        if (writePolicy == null) {
            writePolicy = new WritePolicy(entry.getWritePolicy());
            if (recordExistsAction != null) {
                writePolicy.recordExistsAction = recordExistsAction;
            }
        }
        if ("".equals(set = entry.getSetName())) {
            set = null;
        }
        Integer ttl = entry.getTtl();
        Boolean sendKey = entry.getSendKey();
        if (ttl != null) {
            writePolicy.expiration = ttl;
        }
        if (sendKey != null) {
            writePolicy.sendKey = sendKey;
        }
        Key key = new Key(entry.getNamespace(), set, Value.get((Object)entry.getKey(object)));
        Bin[] bins = entry.getBins(object, writePolicy.recordExistsAction != RecordExistsAction.REPLACE, binNames);
        this.mClient.put(writePolicy, key, bins);
    }

    @Override
    public void update(@NotNull Object object, String ... binNames) throws AerospikeException {
        this.save(null, object, RecordExistsAction.UPDATE, binNames);
    }

    @Override
    public <T> T readFromDigest(@NotNull Class<T> clazz, @NotNull byte[] digest) throws AerospikeException {
        return this.readFromDigest(clazz, digest, true);
    }

    @Override
    public <T> T readFromDigest(@NotNull Class<T> clazz, @NotNull byte[] digest, boolean resolveDependencies) throws AerospikeException {
        ClassCacheEntry<T> entry = MapperUtils.getEntryAndValidateNamespace(clazz, this);
        Key key = new Key(entry.getNamespace(), digest, entry.getSetName(), null);
        return this.read(null, clazz, key, entry, resolveDependencies);
    }

    @Override
    public <T> T readFromDigest(Policy readPolicy, @NotNull Class<T> clazz, @NotNull byte[] digest) throws AerospikeException {
        return this.readFromDigest(readPolicy, clazz, digest, true);
    }

    @Override
    public <T> T readFromDigest(Policy readPolicy, @NotNull Class<T> clazz, @NotNull byte[] digest, boolean resolveDependencies) throws AerospikeException {
        ClassCacheEntry<T> entry = MapperUtils.getEntryAndValidateNamespace(clazz, this);
        Key key = new Key(entry.getNamespace(), digest, entry.getSetName(), null);
        return this.read(readPolicy, clazz, key, entry, resolveDependencies);
    }

    @Override
    public <T> T read(@NotNull Class<T> clazz, @NotNull Object userKey) throws AerospikeException {
        return this.read(clazz, userKey, true);
    }

    @Override
    public <T> T read(@NotNull Class<T> clazz, @NotNull Object userKey, boolean resolveDependencies) throws AerospikeException {
        ClassCacheEntry<T> entry = MapperUtils.getEntryAndValidateNamespace(clazz, this);
        String set = entry.getSetName();
        Key key = new Key(entry.getNamespace(), set, Value.get((Object)entry.translateKeyToAerospikeKey(userKey)));
        return this.read(null, clazz, key, entry, resolveDependencies);
    }

    @Override
    public <T> T read(Policy readPolicy, @NotNull Class<T> clazz, @NotNull Object userKey) throws AerospikeException {
        return this.read(readPolicy, clazz, userKey, true);
    }

    @Override
    public <T> T read(Policy readPolicy, @NotNull Class<T> clazz, @NotNull Object userKey, boolean resolveDependencies) throws AerospikeException {
        ClassCacheEntry<T> entry = MapperUtils.getEntryAndValidateNamespace(clazz, this);
        String set = entry.getSetName();
        Key key = new Key(entry.getNamespace(), set, Value.get((Object)entry.translateKeyToAerospikeKey(userKey)));
        return this.read(readPolicy, clazz, key, entry, resolveDependencies);
    }

    @Override
    public <T> T[] read(@NotNull Class<T> clazz, Object ... userKeys) throws AerospikeException {
        return this.read((BatchPolicy)null, clazz, userKeys);
    }

    @Override
    public <T> T[] read(BatchPolicy batchPolicy, @NotNull Class<T> clazz, Object ... userKeys) throws AerospikeException {
        ClassCacheEntry<T> entry = MapperUtils.getEntryAndValidateNamespace(clazz, this);
        String set = entry.getSetName();
        Key[] keys = new Key[userKeys.length];
        for (int i = 0; i < userKeys.length; ++i) {
            if (userKeys[i] == null) {
                throw new AerospikeException("Cannot pass null to object " + i + " in multi-read call");
            }
            keys[i] = new Key(entry.getNamespace(), set, Value.get((Object)entry.translateKeyToAerospikeKey(userKeys[i])));
        }
        return this.readBatch(batchPolicy, clazz, keys, entry);
    }

    private <T> T read(Policy readPolicy, @NotNull Class<T> clazz, @NotNull Key key, @NotNull ClassCacheEntry<T> entry, boolean resolveDependencies) {
        Record record;
        Object objectForKey = LoadedObjectResolver.get(key);
        if (objectForKey != null) {
            return (T)objectForKey;
        }
        if (readPolicy == null) {
            readPolicy = entry.getReadPolicy();
        }
        if ((record = this.mClient.get(readPolicy, key)) == null) {
            return null;
        }
        try {
            ThreadLocalKeySaver.save(key);
            LoadedObjectResolver.begin();
            T t = this.mappingConverter.convertToObject(clazz, record, entry, resolveDependencies);
            return t;
        }
        catch (ReflectiveOperationException e) {
            throw new AerospikeException((Throwable)e);
        }
        finally {
            LoadedObjectResolver.end();
            ThreadLocalKeySaver.clear();
        }
    }

    private <T> T[] readBatch(BatchPolicy batchPolicy, @NotNull Class<T> clazz, @NotNull Key[] keys, @NotNull ClassCacheEntry<T> entry) {
        if (batchPolicy == null) {
            batchPolicy = entry.getBatchPolicy();
        }
        Record[] records = this.mClient.get(batchPolicy, keys);
        Object[] results = (Object[])Array.newInstance(clazz, records.length);
        for (int i = 0; i < records.length; ++i) {
            if (records[i] == null) {
                results[i] = null;
                continue;
            }
            try {
                ThreadLocalKeySaver.save(keys[i]);
                T result = this.mappingConverter.convertToObject(clazz, records[i], entry, false);
                results[i] = result;
                continue;
            }
            catch (ReflectiveOperationException e) {
                throw new AerospikeException((Throwable)e);
            }
            finally {
                ThreadLocalKeySaver.clear();
            }
        }
        this.mappingConverter.resolveDependencies(entry);
        return results;
    }

    @Override
    public <T> boolean delete(@NotNull Class<T> clazz, @NotNull Object userKey) throws AerospikeException {
        return this.delete(null, clazz, userKey);
    }

    @Override
    public <T> boolean delete(WritePolicy writePolicy, @NotNull Class<T> clazz, @NotNull Object userKey) throws AerospikeException {
        ClassCacheEntry<T> entry = MapperUtils.getEntryAndValidateNamespace(clazz, this);
        Object asKey = entry.translateKeyToAerospikeKey(userKey);
        if (writePolicy == null) {
            writePolicy = entry.getWritePolicy();
            if (entry.getDurableDelete() != null) {
                writePolicy = new WritePolicy(writePolicy);
                writePolicy.durableDelete = entry.getDurableDelete();
            }
        }
        Key key = new Key(entry.getNamespace(), entry.getSetName(), Value.get((Object)asKey));
        return this.mClient.delete(writePolicy, key);
    }

    @Override
    public boolean delete(@NotNull Object object) throws AerospikeException {
        return this.delete((WritePolicy)null, object);
    }

    @Override
    public boolean delete(WritePolicy writePolicy, @NotNull Object object) throws AerospikeException {
        ClassCacheEntry<?> entry = MapperUtils.getEntryAndValidateNamespace(object.getClass(), this);
        Key key = new Key(entry.getNamespace(), entry.getSetName(), Value.get((Object)entry.getKey(object)));
        if (writePolicy == null) {
            writePolicy = entry.getWritePolicy();
            if (entry.getDurableDelete() != null) {
                writePolicy = new WritePolicy(writePolicy);
                writePolicy.durableDelete = entry.getDurableDelete();
            }
        }
        return this.mClient.delete(writePolicy, key);
    }

    @Override
    public <T> VirtualList<T> asBackedList(@NotNull Object object, @NotNull String binName, Class<T> elementClazz) {
        return new VirtualList<T>(this, object, binName, elementClazz);
    }

    @Override
    public <T> VirtualList<T> asBackedList(@NotNull Class<?> owningClazz, @NotNull Object key, @NotNull String binName, Class<T> elementClazz) {
        return new VirtualList<T>(this, owningClazz, key, binName, elementClazz);
    }

    @Override
    public <T> void find(@NotNull Class<T> clazz, Function<T, Boolean> function) throws AerospikeException {
        ClassCacheEntry<T> entry = MapperUtils.getEntryAndValidateNamespace(clazz, this);
        Statement statement = new Statement();
        statement.setNamespace(entry.getNamespace());
        statement.setSetName(entry.getSetName());
        try (RecordSet recordSet = null;){
            recordSet = this.mClient.query(null, statement);
            while (recordSet.next()) {
                T result = clazz.getConstructor(new Class[0]).newInstance(new Object[0]);
                entry.hydrateFromRecord(recordSet.getRecord(), result);
                if (function.apply(result).booleanValue()) continue;
                break;
            }
        }
    }

    @Override
    public IAerospikeClient getClient() {
        return this.mClient;
    }

    @Override
    public MappingConverter getMappingConverter() {
        return this.mappingConverter;
    }

    @Override
    public Policy getReadPolicy(Class<?> clazz) {
        return this.getPolicyByClassAndType(clazz, ClassCache.PolicyType.READ);
    }

    @Override
    public WritePolicy getWritePolicy(Class<?> clazz) {
        return (WritePolicy)this.getPolicyByClassAndType(clazz, ClassCache.PolicyType.WRITE);
    }

    @Override
    public BatchPolicy getBatchPolicy(Class<?> clazz) {
        return (BatchPolicy)this.getPolicyByClassAndType(clazz, ClassCache.PolicyType.BATCH);
    }

    @Override
    public ScanPolicy getScanPolicy(Class<?> clazz) {
        return (ScanPolicy)this.getPolicyByClassAndType(clazz, ClassCache.PolicyType.SCAN);
    }

    @Override
    public QueryPolicy getQueryPolicy(Class<?> clazz) {
        return (QueryPolicy)this.getPolicyByClassAndType(clazz, ClassCache.PolicyType.QUERY);
    }

    @Override
    public IAeroMapper asMapper() {
        return this;
    }

    private Policy getPolicyByClassAndType(Class<?> clazz, ClassCache.PolicyType policyType) {
        ClassCacheEntry<?> entry = ClassCache.getInstance().loadClass(clazz, this);
        switch (policyType) {
            case READ: {
                return entry == null ? this.mClient.getReadPolicyDefault() : entry.getReadPolicy();
            }
            case WRITE: {
                return entry == null ? this.mClient.getWritePolicyDefault() : entry.getWritePolicy();
            }
            case BATCH: {
                return entry == null ? this.mClient.getBatchPolicyDefault() : entry.getBatchPolicy();
            }
            case SCAN: {
                return entry == null ? this.mClient.getScanPolicyDefault() : entry.getScanPolicy();
            }
            case QUERY: {
                return entry == null ? this.mClient.getQueryPolicyDefault() : entry.getQueryPolicy();
            }
        }
        throw new UnsupportedOperationException("Provided unsupported policy.");
    }

    public static class Builder {
        private final AeroMapper mapper;
        private List<Class<?>> classesToPreload = null;

        public Builder(IAerospikeClient client) {
            this.mapper = new AeroMapper(client);
            ClassCache.getInstance().setDefaultPolicies(client);
        }

        public Builder addConverter(Object converter) {
            GenericTypeMapper mapper = new GenericTypeMapper(converter);
            TypeUtils.addTypeMapper(mapper.getMappedClass(), mapper);
            return this;
        }

        public Builder preLoadClass(Class<?> clazz) {
            if (this.classesToPreload == null) {
                this.classesToPreload = new ArrayList();
            }
            this.classesToPreload.add(clazz);
            return this;
        }

        public Builder withConfigurationFile(File file) throws IOException {
            return this.withConfigurationFile(file, false);
        }

        public Builder withConfigurationFile(File file, boolean allowsInvalid) throws IOException {
            ObjectMapper objectMapper = new ObjectMapper((JsonFactory)new YAMLFactory());
            Configuration configuration = (Configuration)objectMapper.readValue(file, Configuration.class);
            this.loadConfiguration(configuration, allowsInvalid);
            return this;
        }

        public Builder withConfigurationFile(InputStream ios) throws IOException {
            return this.withConfigurationFile(ios, false);
        }

        public Builder withConfigurationFile(InputStream ios, boolean allowsInvalid) throws IOException {
            ObjectMapper objectMapper = new ObjectMapper((JsonFactory)new YAMLFactory());
            Configuration configuration = (Configuration)objectMapper.readValue(ios, Configuration.class);
            this.loadConfiguration(configuration, allowsInvalid);
            return this;
        }

        public Builder withConfiguration(String configurationYaml) throws JsonProcessingException {
            return this.withConfiguration(configurationYaml, false);
        }

        public Builder withConfiguration(String configurationYaml, boolean allowsInvalid) throws JsonProcessingException {
            ObjectMapper objectMapper = new ObjectMapper((JsonFactory)new YAMLFactory());
            Configuration configuration = (Configuration)objectMapper.readValue(configurationYaml, Configuration.class);
            this.loadConfiguration(configuration, allowsInvalid);
            return this;
        }

        private void loadConfiguration(@NotNull Configuration configuration, boolean allowsInvalid) {
            for (ClassConfig config : configuration.getClasses()) {
                try {
                    String name = config.getClassName();
                    if (StringUtils.isBlank((CharSequence)name)) {
                        throw new AerospikeException("Class with blank name in configuration file");
                    }
                    try {
                        Class.forName(config.getClassName());
                    }
                    catch (ClassNotFoundException e) {
                        throw new AerospikeException("Cannot find a class with name " + name);
                    }
                }
                catch (RuntimeException re) {
                    if (allowsInvalid) {
                        System.err.println("Ignoring issue with configuration: " + re.getMessage());
                        continue;
                    }
                    throw re;
                }
            }
            ClassCache.getInstance().addConfiguration(configuration);
        }

        public AeroPolicyMapper withReadPolicy(Policy policy) {
            return new AeroPolicyMapper(this, ClassCache.PolicyType.READ, policy);
        }

        public AeroPolicyMapper withWritePolicy(Policy policy) {
            return new AeroPolicyMapper(this, ClassCache.PolicyType.WRITE, policy);
        }

        public AeroPolicyMapper withBatchPolicy(BatchPolicy policy) {
            return new AeroPolicyMapper(this, ClassCache.PolicyType.BATCH, (Policy)policy);
        }

        public AeroPolicyMapper withScanPolicy(ScanPolicy policy) {
            return new AeroPolicyMapper(this, ClassCache.PolicyType.SCAN, (Policy)policy);
        }

        public AeroPolicyMapper withQueryPolicy(QueryPolicy policy) {
            return new AeroPolicyMapper(this, ClassCache.PolicyType.QUERY, (Policy)policy);
        }

        public AeroMapper build() {
            if (this.classesToPreload != null) {
                for (Class<?> clazz : this.classesToPreload) {
                    ClassCache.getInstance().loadClass(clazz, this.mapper);
                }
            }
            return this.mapper;
        }

        public static class AeroPolicyMapper {
            private final Builder builder;
            private final Policy policy;
            private final ClassCache.PolicyType policyType;

            public AeroPolicyMapper(Builder builder, ClassCache.PolicyType policyType, Policy policy) {
                this.builder = builder;
                this.policyType = policyType;
                this.policy = policy;
            }

            public Builder forClasses(Class<?> ... classes) {
                for (Class<?> thisClass : classes) {
                    ClassCache.getInstance().setSpecificPolicy(this.policyType, thisClass, this.policy);
                }
                return this.builder;
            }

            public Builder forThisOrChildrenOf(Class<?> clazz) {
                ClassCache.getInstance().setChildrenPolicy(this.policyType, clazz, this.policy);
                return this.builder;
            }

            public Builder forAll() {
                ClassCache.getInstance().setDefaultPolicy(this.policyType, this.policy);
                return this.builder;
            }
        }
    }
}

