/*
 * Decompiled with CFR 0.152.
 */
package com.aerospike.mapper.tools;

import com.aerospike.client.AerospikeException;
import com.aerospike.client.Bin;
import com.aerospike.client.Key;
import com.aerospike.client.Value;
import com.aerospike.client.policy.BatchPolicy;
import com.aerospike.client.policy.Policy;
import com.aerospike.client.policy.QueryPolicy;
import com.aerospike.client.policy.RecordExistsAction;
import com.aerospike.client.policy.ScanPolicy;
import com.aerospike.client.policy.WritePolicy;
import com.aerospike.client.reactor.IAerospikeReactorClient;
import com.aerospike.mapper.tools.AeroMapper;
import com.aerospike.mapper.tools.ClassCache;
import com.aerospike.mapper.tools.ClassCacheEntry;
import com.aerospike.mapper.tools.GenericTypeMapper;
import com.aerospike.mapper.tools.IAeroMapper;
import com.aerospike.mapper.tools.IReactiveAeroMapper;
import com.aerospike.mapper.tools.ThreadLocalKeySaver;
import com.aerospike.mapper.tools.configuration.ClassConfig;
import com.aerospike.mapper.tools.configuration.Configuration;
import com.aerospike.mapper.tools.converters.MappingConverter;
import com.aerospike.mapper.tools.utils.MapperUtils;
import com.aerospike.mapper.tools.utils.TypeUtils;
import com.aerospike.mapper.tools.virtuallist.ReactiveVirtualList;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import javax.validation.constraints.NotNull;
import org.apache.commons.lang3.StringUtils;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class ReactiveAeroMapper
implements IReactiveAeroMapper {
    private final IAerospikeReactorClient reactorClient;
    private final IAeroMapper aeroMapper;
    private final MappingConverter mappingConverter;

    private ReactiveAeroMapper(@NotNull IAerospikeReactorClient reactorClient) {
        this.reactorClient = reactorClient;
        this.aeroMapper = new AeroMapper.Builder(reactorClient.getAerospikeClient()).build();
        this.mappingConverter = new MappingConverter(this, reactorClient.getAerospikeClient());
    }

    @Override
    public <T> Flux<T> save(T ... objects) {
        return Flux.fromStream(Arrays.stream(objects)).flatMap(x$0 -> this.save(x$0, new String[0]));
    }

    @Override
    public <T> Mono<T> save(@NotNull T object, String ... binNames) {
        return this.save(null, object, RecordExistsAction.REPLACE, binNames);
    }

    @Override
    public <T> Mono<T> save(@NotNull WritePolicy writePolicy, @NotNull T object, String ... binNames) {
        return this.save(writePolicy, object, (RecordExistsAction)null, binNames);
    }

    @Override
    public <T> Mono<T> update(@NotNull T object, String ... binNames) {
        return this.save(null, object, RecordExistsAction.UPDATE, binNames);
    }

    @Override
    public <T> Mono<T> readFromDigest(@NotNull Class<T> clazz, @NotNull byte[] digest) {
        return this.readFromDigest(clazz, digest, true);
    }

    @Override
    public <T> Mono<T> readFromDigest(@NotNull Class<T> clazz, @NotNull byte[] digest, boolean resolveDependencies) throws AerospikeException {
        ClassCacheEntry<T> entry = MapperUtils.getEntryAndValidateNamespace(clazz, this);
        Key key = new Key(entry.getNamespace(), digest, entry.getSetName(), null);
        return this.read(null, clazz, key, entry, resolveDependencies);
    }

    @Override
    public <T> Mono<T> readFromDigest(Policy readPolicy, @NotNull Class<T> clazz, @NotNull byte[] digest) {
        return this.readFromDigest(readPolicy, clazz, digest, true);
    }

    @Override
    public <T> Mono<T> readFromDigest(Policy readPolicy, @NotNull Class<T> clazz, @NotNull byte[] digest, boolean resolveDependencies) {
        ClassCacheEntry<T> entry = MapperUtils.getEntryAndValidateNamespace(clazz, this);
        Key key = new Key(entry.getNamespace(), digest, entry.getSetName(), null);
        return this.read(readPolicy, clazz, key, entry, resolveDependencies);
    }

    @Override
    public <T> Mono<T> read(@NotNull Class<T> clazz, @NotNull Object userKey) {
        return this.read(clazz, userKey, true);
    }

    @Override
    public <T> Mono<T> read(@NotNull Class<T> clazz, @NotNull Object userKey, boolean resolveDependencies) {
        ClassCacheEntry<T> entry = MapperUtils.getEntryAndValidateNamespace(clazz, this);
        String set = entry.getSetName();
        Key key = new Key(entry.getNamespace(), set, Value.get((Object)entry.translateKeyToAerospikeKey(userKey)));
        return this.read(null, clazz, key, entry, resolveDependencies);
    }

    @Override
    public <T> Mono<T> read(Policy readPolicy, @NotNull Class<T> clazz, @NotNull Object userKey) {
        return this.read(readPolicy, clazz, userKey, true);
    }

    @Override
    public <T> Mono<T> read(Policy readPolicy, @NotNull Class<T> clazz, @NotNull Object userKey, boolean resolveDependencies) {
        ClassCacheEntry<T> entry = MapperUtils.getEntryAndValidateNamespace(clazz, this);
        String set = entry.getSetName();
        Key key = new Key(entry.getNamespace(), set, Value.get((Object)entry.translateKeyToAerospikeKey(userKey)));
        return this.read(readPolicy, clazz, key, entry, resolveDependencies);
    }

    @Override
    public <T> Flux<T> read(@NotNull Class<T> clazz, Object ... userKeys) {
        throw new UnsupportedOperationException("Batch reading is not supported in ReactiveAeroMapper yet.");
    }

    @Override
    public <T> Flux<T> read(BatchPolicy batchPolicy, @NotNull Class<T> clazz, Object ... userKeys) {
        ClassCacheEntry<T> entry = MapperUtils.getEntryAndValidateNamespace(clazz, this);
        String set = entry.getSetName();
        Key[] keys = new Key[userKeys.length];
        for (int i = 0; i < userKeys.length; ++i) {
            if (userKeys[i] == null) {
                throw new AerospikeException("Cannot pass null to object " + i + " in multi-read call");
            }
            keys[i] = new Key(entry.getNamespace(), set, Value.get((Object)entry.translateKeyToAerospikeKey(userKeys[i])));
        }
        return this.readBatch(batchPolicy, clazz, keys, entry);
    }

    @Override
    public <T> Mono<Boolean> delete(@NotNull Class<T> clazz, @NotNull Object userKey) {
        return this.delete(null, clazz, userKey);
    }

    @Override
    public <T> Mono<Boolean> delete(WritePolicy writePolicy, @NotNull Class<T> clazz, @NotNull Object userKey) {
        ClassCacheEntry<T> entry = MapperUtils.getEntryAndValidateNamespace(clazz, this);
        Object asKey = entry.translateKeyToAerospikeKey(userKey);
        if (writePolicy == null) {
            writePolicy = entry.getWritePolicy();
            if (entry.getDurableDelete() != null) {
                writePolicy = new WritePolicy(writePolicy);
                writePolicy.durableDelete = entry.getDurableDelete();
            }
        }
        Key key = new Key(entry.getNamespace(), entry.getSetName(), Value.get((Object)asKey));
        return this.reactorClient.delete(writePolicy, key).map(k -> true);
    }

    @Override
    public Mono<Boolean> delete(@NotNull Object object) {
        return this.delete((WritePolicy)null, object);
    }

    @Override
    public Mono<Boolean> delete(WritePolicy writePolicy, @NotNull Object object) {
        ClassCacheEntry<?> entry = MapperUtils.getEntryAndValidateNamespace(object.getClass(), this);
        Key key = new Key(entry.getNamespace(), entry.getSetName(), Value.get((Object)entry.getKey(object)));
        if (writePolicy == null) {
            writePolicy = entry.getWritePolicy();
            if (entry.getDurableDelete() != null) {
                writePolicy = new WritePolicy(writePolicy);
                writePolicy.durableDelete = entry.getDurableDelete();
            }
        }
        return this.reactorClient.delete(writePolicy, key).map(k -> true);
    }

    @Override
    public <T> ReactiveVirtualList<T> asBackedList(@NotNull Object object, @NotNull String binName, Class<T> elementClazz) {
        return new ReactiveVirtualList<T>(this, object, binName, elementClazz);
    }

    @Override
    public <T> ReactiveVirtualList<T> asBackedList(@NotNull Class<?> owningClazz, @NotNull Object key, @NotNull String binName, Class<T> elementClazz) {
        return new ReactiveVirtualList<T>(this, owningClazz, key, binName, elementClazz);
    }

    @Override
    public <T> Mono<Void> find(@NotNull Class<T> clazz, Function<T, Boolean> function) throws AerospikeException {
        return Mono.fromCallable(() -> {
            this.asMapper().find(clazz, function);
            return null;
        });
    }

    @Override
    public IAerospikeReactorClient getReactorClient() {
        return this.reactorClient;
    }

    @Override
    public MappingConverter getMappingConverter() {
        return this.mappingConverter;
    }

    @Override
    public Policy getReadPolicy(Class<?> clazz) {
        return this.getPolicyByClassAndType(clazz, ClassCache.PolicyType.READ);
    }

    @Override
    public WritePolicy getWritePolicy(Class<?> clazz) {
        return (WritePolicy)this.getPolicyByClassAndType(clazz, ClassCache.PolicyType.WRITE);
    }

    @Override
    public BatchPolicy getBatchPolicy(Class<?> clazz) {
        return (BatchPolicy)this.getPolicyByClassAndType(clazz, ClassCache.PolicyType.BATCH);
    }

    @Override
    public ScanPolicy getScanPolicy(Class<?> clazz) {
        return (ScanPolicy)this.getPolicyByClassAndType(clazz, ClassCache.PolicyType.SCAN);
    }

    @Override
    public QueryPolicy getQueryPolicy(Class<?> clazz) {
        return (QueryPolicy)this.getPolicyByClassAndType(clazz, ClassCache.PolicyType.QUERY);
    }

    @Override
    public IAeroMapper asMapper() {
        return this.aeroMapper;
    }

    private Policy getPolicyByClassAndType(Class<?> clazz, ClassCache.PolicyType policyType) {
        ClassCacheEntry<?> entry = ClassCache.getInstance().loadClass(clazz, this);
        switch (policyType) {
            case READ: {
                return entry == null ? this.reactorClient.getReadPolicyDefault() : entry.getReadPolicy();
            }
            case WRITE: {
                return entry == null ? this.reactorClient.getWritePolicyDefault() : entry.getWritePolicy();
            }
            case BATCH: {
                return entry == null ? this.reactorClient.getBatchPolicyDefault() : entry.getBatchPolicy();
            }
            case SCAN: {
                return entry == null ? this.reactorClient.getScanPolicyDefault() : entry.getScanPolicy();
            }
            case QUERY: {
                return entry == null ? this.reactorClient.getQueryPolicyDefault() : entry.getQueryPolicy();
            }
        }
        throw new UnsupportedOperationException("Provided unsupported policy.");
    }

    private <T> Mono<T> save(WritePolicy writePolicy, @NotNull T object, RecordExistsAction recordExistsAction, String[] binNames) {
        String set;
        Class<?> clazz = object.getClass();
        ClassCacheEntry<?> entry = MapperUtils.getEntryAndValidateNamespace(clazz, this);
        if (writePolicy == null) {
            writePolicy = new WritePolicy(entry.getWritePolicy());
            if (recordExistsAction != null) {
                writePolicy.recordExistsAction = recordExistsAction;
            }
        }
        if ("".equals(set = entry.getSetName())) {
            set = null;
        }
        Integer ttl = entry.getTtl();
        Boolean sendKey = entry.getSendKey();
        if (ttl != null) {
            writePolicy.expiration = ttl;
        }
        if (sendKey != null) {
            writePolicy.sendKey = sendKey;
        }
        Key key = new Key(entry.getNamespace(), set, Value.get((Object)entry.getKey(object)));
        Bin[] bins = entry.getBins(object, writePolicy.recordExistsAction != RecordExistsAction.REPLACE, binNames);
        return this.reactorClient.put(writePolicy, key, bins).map(docKey -> object).onErrorMap(this::translateError);
    }

    private <T> Mono<T> read(Policy readPolicy, @NotNull Class<T> clazz, @NotNull Key key, @NotNull ClassCacheEntry<T> entry, boolean resolveDependencies) {
        if (readPolicy == null) {
            readPolicy = entry.getReadPolicy();
        }
        return this.reactorClient.get(readPolicy, key).filter(keyRecord -> Objects.nonNull(keyRecord.record)).map(keyRecord -> {
            try {
                ThreadLocalKeySaver.save(key);
                Object t = this.mappingConverter.convertToObject(clazz, keyRecord.record, entry, resolveDependencies);
                return t;
            }
            catch (ReflectiveOperationException e) {
                throw new AerospikeException((Throwable)e);
            }
            finally {
                ThreadLocalKeySaver.clear();
            }
        });
    }

    private <T> Flux<T> readBatch(BatchPolicy batchPolicy, @NotNull Class<T> clazz, @NotNull Key[] keys, @NotNull ClassCacheEntry<T> entry) {
        if (batchPolicy == null) {
            batchPolicy = entry.getBatchPolicy();
        }
        Flux results = this.reactorClient.getFlux(batchPolicy, keys).filter(keyRecord -> Objects.nonNull(keyRecord.record)).map(keyRecord -> {
            try {
                ThreadLocalKeySaver.save(keyRecord.key);
                Object t = this.mappingConverter.convertToObject(clazz, keyRecord.record, entry, false);
                return t;
            }
            catch (ReflectiveOperationException e) {
                throw new AerospikeException((Throwable)e);
            }
            finally {
                ThreadLocalKeySaver.clear();
            }
        });
        this.mappingConverter.resolveDependencies(entry);
        return results;
    }

    private Throwable translateError(Throwable e) {
        if (e instanceof AerospikeException) {
            return this.translateError((Throwable)((AerospikeException)e));
        }
        return e;
    }

    public static class Builder {
        private final ReactiveAeroMapper reactorMapper;
        private List<Class<?>> classesToPreload = null;

        public Builder(IAerospikeReactorClient reactorClient) {
            this.reactorMapper = new ReactiveAeroMapper(reactorClient);
            ClassCache.getInstance().setReactiveDefaultPolicies(reactorClient);
        }

        public Builder addConverter(Object converter) {
            GenericTypeMapper mapper = new GenericTypeMapper(converter);
            TypeUtils.addTypeMapper(mapper.getMappedClass(), mapper);
            return this;
        }

        public Builder preLoadClass(Class<?> clazz) {
            if (this.classesToPreload == null) {
                this.classesToPreload = new ArrayList();
            }
            this.classesToPreload.add(clazz);
            return this;
        }

        public Builder withConfigurationFile(File file) throws IOException {
            return this.withConfigurationFile(file, false);
        }

        public Builder withConfigurationFile(File file, boolean allowsInvalid) throws IOException {
            ObjectMapper objectMapper = new ObjectMapper((JsonFactory)new YAMLFactory());
            Configuration configuration = (Configuration)objectMapper.readValue(file, Configuration.class);
            this.loadConfiguration(configuration, allowsInvalid);
            return this;
        }

        public Builder withConfiguration(String configurationYaml) throws JsonProcessingException {
            return this.withConfiguration(configurationYaml, false);
        }

        public Builder withConfiguration(String configurationYaml, boolean allowsInvalid) throws JsonProcessingException {
            ObjectMapper objectMapper = new ObjectMapper((JsonFactory)new YAMLFactory());
            Configuration configuration = (Configuration)objectMapper.readValue(configurationYaml, Configuration.class);
            this.loadConfiguration(configuration, allowsInvalid);
            return this;
        }

        private void loadConfiguration(@NotNull Configuration configuration, boolean allowsInvalid) {
            for (ClassConfig config : configuration.getClasses()) {
                try {
                    String name = config.getClassName();
                    if (StringUtils.isBlank((CharSequence)name)) {
                        throw new AerospikeException("Class with blank name in configuration file");
                    }
                    try {
                        Class.forName(config.getClassName());
                    }
                    catch (ClassNotFoundException e) {
                        throw new AerospikeException("Cannot find a class with name " + name);
                    }
                }
                catch (RuntimeException re) {
                    if (allowsInvalid) {
                        System.err.println("Ignoring issue with configuration: " + re.getMessage());
                        continue;
                    }
                    throw re;
                }
            }
            ClassCache.getInstance().addConfiguration(configuration);
        }

        public ReactiveAeroPolicyMapper withReadPolicy(Policy policy) {
            return new ReactiveAeroPolicyMapper(this, ClassCache.PolicyType.READ, policy);
        }

        public ReactiveAeroPolicyMapper withWritePolicy(Policy policy) {
            return new ReactiveAeroPolicyMapper(this, ClassCache.PolicyType.WRITE, policy);
        }

        public ReactiveAeroPolicyMapper withBatchPolicy(BatchPolicy policy) {
            return new ReactiveAeroPolicyMapper(this, ClassCache.PolicyType.BATCH, (Policy)policy);
        }

        public ReactiveAeroPolicyMapper withScanPolicy(ScanPolicy policy) {
            return new ReactiveAeroPolicyMapper(this, ClassCache.PolicyType.SCAN, (Policy)policy);
        }

        public ReactiveAeroPolicyMapper withQueryPolicy(QueryPolicy policy) {
            return new ReactiveAeroPolicyMapper(this, ClassCache.PolicyType.QUERY, (Policy)policy);
        }

        public ReactiveAeroMapper build() {
            if (this.classesToPreload != null) {
                for (Class<?> clazz : this.classesToPreload) {
                    ClassCache.getInstance().loadClass(clazz, this.reactorMapper);
                }
            }
            return this.reactorMapper;
        }

        public static class ReactiveAeroPolicyMapper {
            private final Builder builder;
            private final Policy policy;
            private final ClassCache.PolicyType policyType;

            public ReactiveAeroPolicyMapper(Builder builder, ClassCache.PolicyType policyType, Policy policy) {
                this.builder = builder;
                this.policyType = policyType;
                this.policy = policy;
            }

            public Builder forClasses(Class<?> ... classes) {
                for (Class<?> thisClass : classes) {
                    ClassCache.getInstance().setSpecificPolicy(this.policyType, thisClass, this.policy);
                }
                return this.builder;
            }

            public Builder forThisOrChildrenOf(Class<?> clazz) {
                ClassCache.getInstance().setChildrenPolicy(this.policyType, clazz, this.policy);
                return this.builder;
            }

            public Builder forAll() {
                ClassCache.getInstance().setDefaultPolicy(this.policyType, this.policy);
                return this.builder;
            }
        }
    }
}

