/*
 * Decompiled with CFR 0.152.
 */
package com.aerospike.mapper.tools.virtuallist;

import com.aerospike.client.Key;
import com.aerospike.client.Operation;
import com.aerospike.client.Value;
import com.aerospike.client.policy.Policy;
import com.aerospike.client.policy.RecordExistsAction;
import com.aerospike.client.policy.WritePolicy;
import com.aerospike.client.query.KeyRecord;
import com.aerospike.mapper.tools.ClassCache;
import com.aerospike.mapper.tools.IReactiveAeroMapper;
import com.aerospike.mapper.tools.virtuallist.BaseVirtualList;
import com.aerospike.mapper.tools.virtuallist.IReactiveVirtualList;
import com.aerospike.mapper.tools.virtuallist.Interactor;
import com.aerospike.mapper.tools.virtuallist.ReactiveMultiOperation;
import com.aerospike.mapper.tools.virtuallist.ReturnType;
import java.util.List;
import javax.validation.constraints.NotNull;
import reactor.core.publisher.Mono;

public class ReactiveVirtualList<E>
extends BaseVirtualList<E>
implements IReactiveVirtualList<E> {
    private final IReactiveAeroMapper reactiveAeroMapper;

    public ReactiveVirtualList(@NotNull IReactiveAeroMapper reactiveAeroMapper, @NotNull Class<?> owningClazz, @NotNull Object key, @NotNull String binName, @NotNull Class<E> clazz) {
        super(reactiveAeroMapper, null, owningClazz, key, binName, clazz);
        this.reactiveAeroMapper = reactiveAeroMapper;
    }

    public ReactiveVirtualList(@NotNull IReactiveAeroMapper reactiveAeroMapper, @NotNull Object object, @NotNull String binName, @NotNull Class<E> clazz) {
        super(reactiveAeroMapper, object, null, null, binName, clazz);
        this.reactiveAeroMapper = reactiveAeroMapper;
    }

    public ReactiveVirtualList<E> changeKey(Object newKey) {
        String set = this.alignedSet();
        this.key = new Key(this.owningEntry.getNamespace(), set, Value.get((Object)this.owningEntry.translateKeyToAerospikeKey(this.key)));
        return this;
    }

    public ReactiveMultiOperation<E> beginMultiOperation() {
        return this.beginMulti(null);
    }

    public ReactiveMultiOperation<E> beginMulti(WritePolicy writePolicy) {
        if (writePolicy == null) {
            writePolicy = new WritePolicy(this.owningEntry.getWritePolicy());
            writePolicy.recordExistsAction = RecordExistsAction.UPDATE;
        }
        return new ReactiveMultiOperation(writePolicy, this.binName, this.listMapper, this.key, this.virtualListInteractors, this.reactiveAeroMapper);
    }

    @Override
    public Mono<E> getByValue(Object value, ReturnType returnResultsOfType) {
        return this.getByValue(null, value, returnResultsOfType);
    }

    @Override
    public Mono<E> getByValue(WritePolicy writePolicy, Object value, ReturnType returnResultsOfType) {
        if (writePolicy == null) {
            writePolicy = new WritePolicy(this.owningEntry.getWritePolicy());
            writePolicy.recordExistsAction = RecordExistsAction.UPDATE;
        }
        Interactor interactor = this.virtualListInteractors.getGetByValueInteractor(value);
        interactor.setNeedsResultOfType(returnResultsOfType);
        return this.reactiveAeroMapper.getReactorClient().operate(writePolicy, this.key, new Operation[]{interactor.getOperation()}).map(keyRecord -> interactor.getResult(keyRecord.record.getList(this.binName)));
    }

    @Override
    public Mono<E> getByValueRange(Object startValue, Object endValue, ReturnType returnResultsOfType) {
        return this.getByValueRange(null, startValue, endValue, returnResultsOfType);
    }

    @Override
    public Mono<E> getByValueRange(WritePolicy writePolicy, Object startValue, Object endValue, ReturnType returnResultsOfType) {
        if (writePolicy == null) {
            writePolicy = new WritePolicy(this.owningEntry.getWritePolicy());
            writePolicy.recordExistsAction = RecordExistsAction.UPDATE;
        }
        Interactor interactor = this.virtualListInteractors.getGetByValueRangeInteractor(startValue, endValue);
        interactor.setNeedsResultOfType(returnResultsOfType);
        return this.reactiveAeroMapper.getReactorClient().operate(writePolicy, this.key, new Operation[]{interactor.getOperation()}).map(keyRecord -> this.getResultsWithDependencies((KeyRecord)keyRecord, interactor));
    }

    @Override
    public Mono<E> getByValueList(List<Object> values, ReturnType returnResultsOfType) {
        return this.getByValueList(null, values, returnResultsOfType);
    }

    @Override
    public Mono<E> getByValueList(WritePolicy writePolicy, List<Object> values, ReturnType returnResultsOfType) {
        if (writePolicy == null) {
            writePolicy = new WritePolicy(this.owningEntry.getWritePolicy());
            writePolicy.recordExistsAction = RecordExistsAction.UPDATE;
        }
        Interactor interactor = this.virtualListInteractors.getGetByValueListInteractor(values);
        interactor.setNeedsResultOfType(returnResultsOfType);
        return this.reactiveAeroMapper.getReactorClient().operate(writePolicy, this.key, new Operation[]{interactor.getOperation()}).map(keyRecord -> interactor.getResult(keyRecord.record.getList(this.binName)));
    }

    @Override
    public Mono<E> getByValueRelativeRankRange(Object value, int rank, ReturnType returnResultsOfType) {
        return this.getByValueRelativeRankRange(null, value, rank, returnResultsOfType);
    }

    @Override
    public Mono<E> getByValueRelativeRankRange(WritePolicy writePolicy, Object value, int rank, ReturnType returnResultsOfType) {
        if (writePolicy == null) {
            writePolicy = new WritePolicy(this.owningEntry.getWritePolicy());
            writePolicy.recordExistsAction = RecordExistsAction.UPDATE;
        }
        Interactor interactor = this.virtualListInteractors.getGetByValueRelativeRankRangeInteractor(value, rank);
        interactor.setNeedsResultOfType(returnResultsOfType);
        return this.reactiveAeroMapper.getReactorClient().operate(writePolicy, this.key, new Operation[]{interactor.getOperation()}).map(keyRecord -> interactor.getResult(keyRecord.record.getList(this.binName)));
    }

    @Override
    public Mono<E> getByValueRelativeRankRange(Object value, int rank, int count, ReturnType returnResultsOfType) {
        return this.getByValueRelativeRankRange(null, value, rank, count, returnResultsOfType);
    }

    @Override
    public Mono<E> getByValueRelativeRankRange(WritePolicy writePolicy, Object value, int rank, int count, ReturnType returnResultsOfType) {
        if (writePolicy == null) {
            writePolicy = new WritePolicy(this.owningEntry.getWritePolicy());
            writePolicy.recordExistsAction = RecordExistsAction.UPDATE;
        }
        Interactor interactor = this.virtualListInteractors.getGetByValueRelativeRankRangeInteractor(value, rank, count);
        interactor.setNeedsResultOfType(returnResultsOfType);
        return this.reactiveAeroMapper.getReactorClient().operate(writePolicy, this.key, new Operation[]{interactor.getOperation()}).map(keyRecord -> interactor.getResult(keyRecord.record.getList(this.binName)));
    }

    @Override
    public Mono<E> getByIndexRange(int index, ReturnType returnResultsOfType) {
        return this.getByIndexRange(null, index, returnResultsOfType);
    }

    @Override
    public Mono<E> getByIndexRange(WritePolicy writePolicy, int index, ReturnType returnResultsOfType) {
        if (writePolicy == null) {
            writePolicy = new WritePolicy(this.owningEntry.getWritePolicy());
            writePolicy.recordExistsAction = RecordExistsAction.UPDATE;
        }
        Interactor interactor = this.virtualListInteractors.getGetByIndexRangeInteractor(index);
        interactor.setNeedsResultOfType(returnResultsOfType);
        return this.reactiveAeroMapper.getReactorClient().operate(writePolicy, this.key, new Operation[]{interactor.getOperation()}).map(keyRecord -> interactor.getResult(keyRecord.record.getList(this.binName)));
    }

    @Override
    public Mono<E> getByIndexRange(int index, int count, ReturnType returnResultsOfType) {
        return this.getByIndexRange(null, index, count, returnResultsOfType);
    }

    @Override
    public Mono<E> getByIndexRange(WritePolicy writePolicy, int index, int count, ReturnType returnResultsOfType) {
        if (writePolicy == null) {
            writePolicy = new WritePolicy(this.owningEntry.getWritePolicy());
            writePolicy.recordExistsAction = RecordExistsAction.UPDATE;
        }
        Interactor interactor = this.virtualListInteractors.getGetByIndexRangeInteractor(index, count);
        interactor.setNeedsResultOfType(returnResultsOfType);
        return this.reactiveAeroMapper.getReactorClient().operate(writePolicy, this.key, new Operation[]{interactor.getOperation()}).map(keyRecord -> interactor.getResult(keyRecord.record.getList(this.binName)));
    }

    @Override
    public Mono<E> getByRank(int rank, ReturnType returnResultsOfType) {
        return this.getByRank(null, rank, returnResultsOfType);
    }

    @Override
    public Mono<E> getByRank(WritePolicy writePolicy, int rank, ReturnType returnResultsOfType) {
        if (writePolicy == null) {
            writePolicy = new WritePolicy(this.owningEntry.getWritePolicy());
            writePolicy.recordExistsAction = RecordExistsAction.UPDATE;
        }
        Interactor interactor = this.virtualListInteractors.getGetByRankInteractor(rank);
        interactor.setNeedsResultOfType(returnResultsOfType);
        return this.reactiveAeroMapper.getReactorClient().operate(writePolicy, this.key, new Operation[]{interactor.getOperation()}).map(keyRecord -> interactor.getResult(keyRecord.record.getList(this.binName)));
    }

    @Override
    public Mono<E> getByRankRange(int rank, ReturnType returnResultsOfType) {
        return this.getByRankRange(null, rank, returnResultsOfType);
    }

    @Override
    public Mono<E> getByRankRange(WritePolicy writePolicy, int rank, ReturnType returnResultsOfType) {
        if (writePolicy == null) {
            writePolicy = new WritePolicy(this.owningEntry.getWritePolicy());
            writePolicy.recordExistsAction = RecordExistsAction.UPDATE;
        }
        Interactor interactor = this.virtualListInteractors.getGetByRankRangeInteractor(rank);
        interactor.setNeedsResultOfType(returnResultsOfType);
        return this.reactiveAeroMapper.getReactorClient().operate(writePolicy, this.key, new Operation[]{interactor.getOperation()}).map(keyRecord -> interactor.getResult(keyRecord.record.getList(this.binName)));
    }

    @Override
    public Mono<E> getByRankRange(int rank, int count, ReturnType returnResultsOfType) {
        return this.getByRankRange(null, rank, count, returnResultsOfType);
    }

    @Override
    public Mono<E> getByRankRange(WritePolicy writePolicy, int rank, int count, ReturnType returnResultsOfType) {
        if (writePolicy == null) {
            writePolicy = new WritePolicy(this.owningEntry.getWritePolicy());
            writePolicy.recordExistsAction = RecordExistsAction.UPDATE;
        }
        Interactor interactor = this.virtualListInteractors.getGetByRankRangeInteractor(rank, count);
        interactor.setNeedsResultOfType(returnResultsOfType);
        return this.reactiveAeroMapper.getReactorClient().operate(writePolicy, this.key, new Operation[]{interactor.getOperation()}).map(keyRecord -> interactor.getResult(keyRecord.record.getList(this.binName)));
    }

    @Override
    public Mono<E> getByKey(Object key, ReturnType returnResultsOfType) {
        return this.getByKey(null, key, returnResultsOfType);
    }

    @Override
    public Mono<E> getByKey(WritePolicy writePolicy, Object key, ReturnType returnResultsOfType) {
        if (writePolicy == null) {
            writePolicy = new WritePolicy(this.owningEntry.getWritePolicy());
            writePolicy.recordExistsAction = RecordExistsAction.UPDATE;
        }
        Interactor interactor = this.virtualListInteractors.getGetByKeyInteractor(key);
        interactor.setNeedsResultOfType(returnResultsOfType);
        return this.reactiveAeroMapper.getReactorClient().operate(writePolicy, this.key, new Operation[]{interactor.getOperation()}).map(keyRecord -> interactor.getResult(keyRecord.record.getList(this.binName)));
    }

    @Override
    public Mono<E> getByKeyRange(Object startKey, Object endKey, ReturnType returnResultsOfType) {
        return this.getByKeyRange(null, startKey, endKey, returnResultsOfType);
    }

    @Override
    public Mono<E> getByKeyRange(WritePolicy writePolicy, Object startKey, Object endKey, ReturnType returnResultsOfType) {
        if (writePolicy == null) {
            writePolicy = new WritePolicy(this.owningEntry.getWritePolicy());
            writePolicy.recordExistsAction = RecordExistsAction.UPDATE;
        }
        Interactor interactor = this.virtualListInteractors.getGetByKeyRangeInteractor(startKey, endKey);
        interactor.setNeedsResultOfType(returnResultsOfType);
        return this.reactiveAeroMapper.getReactorClient().operate(writePolicy, this.key, new Operation[]{interactor.getOperation()}).map(keyRecord -> this.getResultsWithDependencies((KeyRecord)keyRecord, interactor));
    }

    @Override
    public Mono<E> removeByKey(Object key, ReturnType returnResultsOfType) {
        return this.removeByKey(null, key, returnResultsOfType);
    }

    @Override
    public Mono<E> removeByKey(WritePolicy writePolicy, Object key, ReturnType returnResultsOfType) {
        if (writePolicy == null) {
            writePolicy = new WritePolicy(this.owningEntry.getWritePolicy());
            writePolicy.recordExistsAction = RecordExistsAction.UPDATE;
        }
        Interactor interactor = this.virtualListInteractors.getRemoveKeyInteractor(key);
        interactor.setNeedsResultOfType(returnResultsOfType);
        return this.reactiveAeroMapper.getReactorClient().operate(writePolicy, this.key, new Operation[]{interactor.getOperation()}).map(keyRecord -> this.getResultsWithDependencies((KeyRecord)keyRecord, interactor));
    }

    @Override
    public Mono<E> removeByValue(Object value, ReturnType returnResultsOfType) {
        return this.removeByValue(null, value, returnResultsOfType);
    }

    @Override
    public Mono<E> removeByValue(WritePolicy writePolicy, Object value, ReturnType returnResultsOfType) {
        if (writePolicy == null) {
            writePolicy = new WritePolicy(this.owningEntry.getWritePolicy());
            writePolicy.recordExistsAction = RecordExistsAction.UPDATE;
        }
        Interactor interactor = this.virtualListInteractors.getRemoveByValueInteractor(value);
        interactor.setNeedsResultOfType(returnResultsOfType);
        return this.reactiveAeroMapper.getReactorClient().operate(writePolicy, this.key, new Operation[]{interactor.getOperation()}).map(keyRecord -> interactor.getResult(keyRecord.record.getList(this.binName)));
    }

    @Override
    public Mono<E> removeByValueList(List<Object> values, ReturnType returnResultsOfType) {
        return this.removeByValueList(null, values, returnResultsOfType);
    }

    @Override
    public Mono<E> removeByValueList(WritePolicy writePolicy, List<Object> values, ReturnType returnResultsOfType) {
        if (writePolicy == null) {
            writePolicy = new WritePolicy(this.owningEntry.getWritePolicy());
            writePolicy.recordExistsAction = RecordExistsAction.UPDATE;
        }
        Interactor interactor = this.virtualListInteractors.getRemoveByValueListInteractor(values);
        interactor.setNeedsResultOfType(returnResultsOfType);
        return this.reactiveAeroMapper.getReactorClient().operate(writePolicy, this.key, new Operation[]{interactor.getOperation()}).map(keyRecord -> interactor.getResult(keyRecord.record.getList(this.binName)));
    }

    @Override
    public Mono<E> removeByValueRange(Object startValue, Object endValue, ReturnType returnResultsOfType) {
        return this.removeByValueRange(null, startValue, endValue, returnResultsOfType);
    }

    @Override
    public Mono<E> removeByValueRange(WritePolicy writePolicy, Object startValue, Object endValue, ReturnType returnResultsOfType) {
        if (writePolicy == null) {
            writePolicy = new WritePolicy(this.owningEntry.getWritePolicy());
            writePolicy.recordExistsAction = RecordExistsAction.UPDATE;
        }
        Interactor interactor = this.virtualListInteractors.getRemoveByValueRangeInteractor(startValue, endValue);
        interactor.setNeedsResultOfType(returnResultsOfType);
        return this.reactiveAeroMapper.getReactorClient().operate(writePolicy, this.key, new Operation[]{interactor.getOperation()}).map(keyRecord -> interactor.getResult(keyRecord.record.getList(this.binName)));
    }

    @Override
    public Mono<E> removeByValueRelativeRankRange(Object value, int rank, ReturnType returnResultsOfType) {
        return this.removeByValueRelativeRankRange(null, value, rank, returnResultsOfType);
    }

    @Override
    public Mono<E> removeByValueRelativeRankRange(WritePolicy writePolicy, Object value, int rank, ReturnType returnResultsOfType) {
        if (writePolicy == null) {
            writePolicy = new WritePolicy(this.owningEntry.getWritePolicy());
            writePolicy.recordExistsAction = RecordExistsAction.UPDATE;
        }
        Interactor interactor = this.virtualListInteractors.getRemoveByValueRelativeRankRangeInteractor(value, rank);
        interactor.setNeedsResultOfType(returnResultsOfType);
        return this.reactiveAeroMapper.getReactorClient().operate(writePolicy, this.key, new Operation[]{interactor.getOperation()}).map(keyRecord -> interactor.getResult(keyRecord.record.getList(this.binName)));
    }

    @Override
    public Mono<E> removeByValueRelativeRankRange(Object value, int rank, int count, ReturnType returnResultsOfType) {
        return this.removeByValueRelativeRankRange(null, value, rank, count, returnResultsOfType);
    }

    @Override
    public Mono<E> removeByValueRelativeRankRange(WritePolicy writePolicy, Object value, int rank, int count, ReturnType returnResultsOfType) {
        if (writePolicy == null) {
            writePolicy = new WritePolicy(this.owningEntry.getWritePolicy());
            writePolicy.recordExistsAction = RecordExistsAction.UPDATE;
        }
        Interactor interactor = this.virtualListInteractors.getRemoveByValueRelativeRankRangeInteractor(value, rank, count);
        interactor.setNeedsResultOfType(returnResultsOfType);
        return this.reactiveAeroMapper.getReactorClient().operate(writePolicy, this.key, new Operation[]{interactor.getOperation()}).map(keyRecord -> interactor.getResult(keyRecord.record.getList(this.binName)));
    }

    @Override
    public Mono<E> removeByIndex(int index, ReturnType returnResultsOfType) {
        return this.removeByIndex(null, index, returnResultsOfType);
    }

    @Override
    public Mono<E> removeByIndex(WritePolicy writePolicy, int index, ReturnType returnResultsOfType) {
        if (writePolicy == null) {
            writePolicy = new WritePolicy(this.owningEntry.getWritePolicy());
            writePolicy.recordExistsAction = RecordExistsAction.UPDATE;
        }
        Interactor interactor = this.virtualListInteractors.getRemoveByIndexInteractor(index);
        interactor.setNeedsResultOfType(returnResultsOfType);
        return this.reactiveAeroMapper.getReactorClient().operate(writePolicy, this.key, new Operation[]{interactor.getOperation()}).map(keyRecord -> interactor.getResult(keyRecord.record.getList(this.binName)));
    }

    @Override
    public Mono<E> removeByIndexRange(int index, ReturnType returnResultsOfType) {
        return this.removeByIndexRange(null, index, returnResultsOfType);
    }

    @Override
    public Mono<E> removeByIndexRange(WritePolicy writePolicy, int index, ReturnType returnResultsOfType) {
        if (writePolicy == null) {
            writePolicy = new WritePolicy(this.owningEntry.getWritePolicy());
            writePolicy.recordExistsAction = RecordExistsAction.UPDATE;
        }
        Interactor interactor = this.virtualListInteractors.getRemoveByIndexRangeInteractor(index);
        interactor.setNeedsResultOfType(returnResultsOfType);
        return this.reactiveAeroMapper.getReactorClient().operate(writePolicy, this.key, new Operation[]{interactor.getOperation()}).map(keyRecord -> interactor.getResult(keyRecord.record.getList(this.binName)));
    }

    @Override
    public Mono<E> removeByIndexRange(int index, int count, ReturnType returnResultsOfType) {
        return this.removeByIndexRange(null, index, count, returnResultsOfType);
    }

    @Override
    public Mono<E> removeByIndexRange(WritePolicy writePolicy, int index, int count, ReturnType returnResultsOfType) {
        if (writePolicy == null) {
            writePolicy = new WritePolicy(this.owningEntry.getWritePolicy());
            writePolicy.recordExistsAction = RecordExistsAction.UPDATE;
        }
        Interactor interactor = this.virtualListInteractors.getRemoveByIndexRangeInteractor(index, count);
        interactor.setNeedsResultOfType(returnResultsOfType);
        return this.reactiveAeroMapper.getReactorClient().operate(writePolicy, this.key, new Operation[]{interactor.getOperation()}).map(keyRecord -> interactor.getResult(keyRecord.record.getList(this.binName)));
    }

    @Override
    public Mono<E> removeByRank(int rank, ReturnType returnResultsOfType) {
        return this.removeByRank(null, rank, returnResultsOfType);
    }

    @Override
    public Mono<E> removeByRank(WritePolicy writePolicy, int rank, ReturnType returnResultsOfType) {
        if (writePolicy == null) {
            writePolicy = new WritePolicy(this.owningEntry.getWritePolicy());
            writePolicy.recordExistsAction = RecordExistsAction.UPDATE;
        }
        Interactor interactor = this.virtualListInteractors.getRemoveByRankInteractor(rank);
        interactor.setNeedsResultOfType(returnResultsOfType);
        return this.reactiveAeroMapper.getReactorClient().operate(writePolicy, this.key, new Operation[]{interactor.getOperation()}).map(keyRecord -> interactor.getResult(keyRecord.record.getList(this.binName)));
    }

    @Override
    public Mono<E> removeByRankRange(int rank, ReturnType returnResultsOfType) {
        return this.removeByRankRange(null, rank, returnResultsOfType);
    }

    @Override
    public Mono<E> removeByRankRange(WritePolicy writePolicy, int rank, ReturnType returnResultsOfType) {
        if (writePolicy == null) {
            writePolicy = new WritePolicy(this.owningEntry.getWritePolicy());
            writePolicy.recordExistsAction = RecordExistsAction.UPDATE;
        }
        Interactor interactor = this.virtualListInteractors.getRemoveByRankRangeInteractor(rank);
        interactor.setNeedsResultOfType(returnResultsOfType);
        return this.reactiveAeroMapper.getReactorClient().operate(writePolicy, this.key, new Operation[]{interactor.getOperation()}).map(keyRecord -> interactor.getResult(keyRecord.record.getList(this.binName)));
    }

    @Override
    public Mono<E> removeByRankRange(int rank, int count, ReturnType returnResultsOfType) {
        return this.removeByRankRange(null, rank, count, returnResultsOfType);
    }

    @Override
    public Mono<E> removeByRankRange(WritePolicy writePolicy, int rank, int count, ReturnType returnResultsOfType) {
        if (writePolicy == null) {
            writePolicy = new WritePolicy(this.owningEntry.getWritePolicy());
            writePolicy.recordExistsAction = RecordExistsAction.UPDATE;
        }
        Interactor interactor = this.virtualListInteractors.getRemoveByRankRangeInteractor(rank, count);
        interactor.setNeedsResultOfType(returnResultsOfType);
        return this.reactiveAeroMapper.getReactorClient().operate(writePolicy, this.key, new Operation[]{interactor.getOperation()}).map(keyRecord -> this.getResultsWithDependencies((KeyRecord)keyRecord, interactor));
    }

    @Override
    public Mono<E> removeByKeyRange(Object startKey, Object endKey, ReturnType returnResultsOfType) {
        return this.removeByKeyRange(null, startKey, endKey, returnResultsOfType);
    }

    @Override
    public Mono<E> removeByKeyRange(WritePolicy writePolicy, Object startKey, Object endKey, ReturnType returnResultsOfType) {
        if (writePolicy == null) {
            writePolicy = new WritePolicy(this.owningEntry.getWritePolicy());
            writePolicy.recordExistsAction = RecordExistsAction.UPDATE;
        }
        Interactor interactor = this.virtualListInteractors.getRemoveKeyRangeInteractor(startKey, endKey);
        interactor.setNeedsResultOfType(returnResultsOfType);
        return this.reactiveAeroMapper.getReactorClient().operate(writePolicy, this.key, new Operation[]{interactor.getOperation()}).map(keyRecord -> this.getResultsWithDependencies((KeyRecord)keyRecord, interactor));
    }

    @Override
    public Mono<Long> append(E element) {
        return this.append(null, element);
    }

    @Override
    public Mono<Long> append(WritePolicy writePolicy, E element) {
        Object result = this.listMapper.toAerospikeInstanceFormat(element);
        if (writePolicy == null) {
            writePolicy = new WritePolicy(this.owningEntry.getWritePolicy());
            writePolicy.recordExistsAction = RecordExistsAction.UPDATE;
        }
        return this.reactiveAeroMapper.getReactorClient().operate(writePolicy, this.key, new Operation[]{this.virtualListInteractors.getAppendOperation(result)}).map(keyRecord -> keyRecord == null ? -1L : keyRecord.record.getLong(this.binName));
    }

    @Override
    public Mono<E> get(int index) {
        return this.get(null, index);
    }

    @Override
    public Mono<E> get(Policy policy, int index) {
        Interactor interactor = this.virtualListInteractors.getByIndexInteractor(index);
        return this.reactiveAeroMapper.getReactorClient().operate(this.getWritePolicy(policy), this.key, new Operation[]{interactor.getOperation()}).map(keyRecord -> this.getResultsWithDependencies((KeyRecord)keyRecord, interactor));
    }

    @Override
    public Mono<Long> size(Policy policy) {
        Interactor interactor = this.virtualListInteractors.getSizeInteractor();
        return this.reactiveAeroMapper.getReactorClient().operate(this.getWritePolicy(policy), this.key, new Operation[]{interactor.getOperation()}).map(keyRecord -> keyRecord == null ? -1L : keyRecord.record.getLong(this.binName));
    }

    @Override
    public Mono<Void> clear() {
        Interactor interactor = this.virtualListInteractors.getClearInteractor();
        return this.reactiveAeroMapper.getReactorClient().operate(null, this.key, new Operation[]{interactor.getOperation()}).then();
    }

    private E getResultsWithDependencies(KeyRecord keyRecord, Interactor interactor) {
        Object result;
        Object object = result = keyRecord == null ? null : interactor.getResult(keyRecord.record.getList(this.binName));
        if (result != null) {
            this.reactiveAeroMapper.getMappingConverter().resolveDependencies(ClassCache.getInstance().loadClass(result.getClass(), this.reactiveAeroMapper));
        }
        return (E)result;
    }
}

