/*
 * Decompiled with CFR 0.152.
 */
package com.aerospike.mapper.tools.virtuallist;

import com.aerospike.client.AerospikeException;
import com.aerospike.client.Key;
import com.aerospike.client.Operation;
import com.aerospike.client.policy.WritePolicy;
import com.aerospike.mapper.tools.ClassCache;
import com.aerospike.mapper.tools.IReactiveAeroMapper;
import com.aerospike.mapper.tools.mappers.ListMapper;
import com.aerospike.mapper.tools.virtuallist.Interactor;
import com.aerospike.mapper.tools.virtuallist.ResultsUnpacker;
import com.aerospike.mapper.tools.virtuallist.ReturnType;
import com.aerospike.mapper.tools.virtuallist.VirtualListInteractors;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.validation.constraints.NotNull;
import reactor.core.publisher.Mono;

public class ReactiveMultiOperation<E> {
    final List<Interactor> interactions = new ArrayList<Interactor>();
    int indexToReturn = -1;
    final WritePolicy writePolicy;
    final String binName;
    final ListMapper listMapper;
    Key key;
    final VirtualListInteractors virtualListInteractors;
    final IReactiveAeroMapper reactiveAeroMapper;

    ReactiveMultiOperation(@NotNull WritePolicy writePolicy, String binName, ListMapper listMapper, Key key, VirtualListInteractors virtualListInteractors, IReactiveAeroMapper reactiveAeroMapper) {
        this.writePolicy = writePolicy;
        this.binName = binName;
        this.listMapper = listMapper;
        this.key = key;
        this.virtualListInteractors = virtualListInteractors;
        this.reactiveAeroMapper = reactiveAeroMapper;
    }

    public ReactiveMultiOperation<E> append(E item) {
        Object aerospikeItem = this.listMapper.toAerospikeInstanceFormat(item);
        this.interactions.add(new Interactor(this.virtualListInteractors.getAppendOperation(aerospikeItem), new ResultsUnpacker[0]));
        return this;
    }

    public ReactiveMultiOperation<E> removeByKey(Object key) {
        this.interactions.add(this.virtualListInteractors.getRemoveKeyInteractor(key));
        return this;
    }

    public ReactiveMultiOperation<E> removeByKeyRange(Object startKey, Object endKey) {
        this.interactions.add(this.virtualListInteractors.getRemoveKeyRangeInteractor(startKey, endKey));
        return this;
    }

    public ReactiveMultiOperation<E> removeByValue(Object value) {
        this.interactions.add(this.virtualListInteractors.getRemoveByValueInteractor(value));
        return this;
    }

    public ReactiveMultiOperation<E> removeByValueList(List<Object> values) {
        this.interactions.add(this.virtualListInteractors.getRemoveByValueListInteractor(values));
        return this;
    }

    public ReactiveMultiOperation<E> removeByValueRange(Object startValue, Object endValue) {
        this.interactions.add(this.virtualListInteractors.getRemoveByValueRangeInteractor(startValue, endValue));
        return this;
    }

    public ReactiveMultiOperation<E> removeByValueRelativeRankRange(Object value, int rank) {
        this.interactions.add(this.virtualListInteractors.getRemoveByValueRelativeRankRangeInteractor(value, rank));
        return this;
    }

    public ReactiveMultiOperation<E> removeByValueRelativeRankRange(Object value, int rank, int count) {
        this.interactions.add(this.virtualListInteractors.getRemoveByValueRelativeRankRangeInteractor(value, rank, count));
        return this;
    }

    public ReactiveMultiOperation<E> removeByIndex(int index) {
        this.interactions.add(this.virtualListInteractors.getRemoveByIndexInteractor(index));
        return this;
    }

    public ReactiveMultiOperation<E> removeByIndexRange(int index) {
        this.interactions.add(this.virtualListInteractors.getRemoveByIndexRangeInteractor(index));
        return this;
    }

    public ReactiveMultiOperation<E> removeByIndexRange(int index, int count) {
        this.interactions.add(this.virtualListInteractors.getRemoveByIndexRangeInteractor(index, count));
        return this;
    }

    public ReactiveMultiOperation<E> removeByRank(int rank) {
        this.interactions.add(this.virtualListInteractors.getRemoveByRankInteractor(rank));
        return this;
    }

    public ReactiveMultiOperation<E> getByValue(Object value) {
        this.interactions.add(this.virtualListInteractors.getGetByValueInteractor(value));
        return this;
    }

    public ReactiveMultiOperation<E> getByValueRange(Object startValue, Object endValue) {
        this.interactions.add(this.virtualListInteractors.getGetByValueRangeInteractor(startValue, endValue));
        return this;
    }

    public ReactiveMultiOperation<E> getByValueList(List<Object> values) {
        this.interactions.add(this.virtualListInteractors.getGetByValueListInteractor(values));
        return this;
    }

    public ReactiveMultiOperation<E> getByValueRelativeRankRange(Object value, int rank) {
        this.interactions.add(this.virtualListInteractors.getGetByValueRelativeRankRangeInteractor(value, rank));
        return this;
    }

    public ReactiveMultiOperation<E> getByValueRelativeRankRange(Object value, int rank, int count) {
        this.interactions.add(this.virtualListInteractors.getGetByValueRelativeRankRangeInteractor(value, rank, count));
        return this;
    }

    public ReactiveMultiOperation<E> getByIndexRange(int index) {
        this.interactions.add(this.virtualListInteractors.getGetByIndexRangeInteractor(index));
        return this;
    }

    public ReactiveMultiOperation<E> getByIndexRange(int index, int count) {
        this.interactions.add(this.virtualListInteractors.getGetByIndexRangeInteractor(index, count));
        return this;
    }

    public ReactiveMultiOperation<E> getByRank(int rank) {
        this.interactions.add(this.virtualListInteractors.getGetByRankInteractor(rank));
        return this;
    }

    public ReactiveMultiOperation<E> getByRankRange(int rank) {
        this.interactions.add(this.virtualListInteractors.getGetByRankRangeInteractor(rank));
        return this;
    }

    public ReactiveMultiOperation<E> getByRankRange(int rank, int count) {
        this.interactions.add(this.virtualListInteractors.getGetByRankRangeInteractor(rank, count));
        return this;
    }

    public ReactiveMultiOperation<E> getByKey(Object key) {
        this.interactions.add(this.virtualListInteractors.getGetByKeyInteractor(key));
        return this;
    }

    public ReactiveMultiOperation<E> getByKeyRange(Object startKey, Object endKey) {
        this.interactions.add(this.virtualListInteractors.getGetByKeyRangeInteractor(startKey, endKey));
        return this;
    }

    public ReactiveMultiOperation<E> get(int index) {
        this.interactions.add(this.virtualListInteractors.getByIndexInteractor(index));
        return this;
    }

    public ReactiveMultiOperation<E> size() {
        this.interactions.add(this.virtualListInteractors.getSizeInteractor());
        return this;
    }

    public ReactiveMultiOperation<E> clear() {
        this.interactions.add(this.virtualListInteractors.getClearInteractor());
        return this;
    }

    public ReactiveMultiOperation<E> asResult() {
        return this.asResultOfType(ReturnType.DEFAULT);
    }

    public ReactiveMultiOperation<E> asResultOfType(ReturnType type) {
        if (this.interactions.isEmpty()) {
            throw new AerospikeException("asResult() cannot mark an item as the function result if there are no items to process");
        }
        if (this.indexToReturn >= 0) {
            throw new AerospikeException("asResult() can only be called once in a multi operation");
        }
        this.indexToReturn = this.interactions.size() - 1;
        this.interactions.get(this.indexToReturn).setNeedsResultOfType(type);
        return this;
    }

    public <T> Mono<T> end() {
        return this.end(null);
    }

    public <T> Mono<T> end(Class<T> resultType) {
        if (this.interactions.isEmpty()) {
            return null;
        }
        this.writePolicy.respondAllOps = true;
        Operation[] operations = new Operation[this.interactions.size()];
        int listSize = this.interactions.size();
        if (this.indexToReturn < 0) {
            for (int i = listSize - 1; i >= 0; --i) {
                if (this.interactions.get(i).isWriteOperation()) continue;
                this.indexToReturn = i;
                this.interactions.get(this.indexToReturn).setNeedsResultOfType(ReturnType.DEFAULT);
                break;
            }
        }
        int count = 0;
        for (Interactor thisInteractor : this.interactions) {
            operations[count++] = thisInteractor.getOperation();
        }
        int finalCount = count;
        return this.reactiveAeroMapper.getReactorClient().operate(this.writePolicy, this.key, operations).map(keyRecord -> {
            Object result;
            if (finalCount == 1) {
                result = this.interactions.get(0).getResult(keyRecord.record.getValue(this.binName));
            } else {
                List resultList = keyRecord.record.getList(this.binName);
                if (this.indexToReturn < 0) {
                    this.indexToReturn = listSize - 1;
                    for (int i = listSize - 1; i >= 0; --i) {
                        if (this.interactions.get(i).isWriteOperation()) continue;
                        this.indexToReturn = i;
                        break;
                    }
                }
                result = this.interactions.get(this.indexToReturn).getResult(resultList.get(this.indexToReturn));
            }
            if (result != null) {
                Object object = result;
                if (result instanceof Collection) {
                    Collection collection = (Collection)result;
                    object = collection.isEmpty() ? null : collection.iterator().next();
                }
                this.reactiveAeroMapper.getMappingConverter().resolveDependencies(ClassCache.getInstance().loadClass(object.getClass(), this.reactiveAeroMapper));
            }
            return result;
        });
    }
}

