/*
 * Decompiled with CFR 0.152.
 */
package com.aerospike.mapper.tools.virtuallist;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;

public interface ResultsUnpacker {
    public Object unpack(Object var1);

    public static class ArrayUnpacker
    implements ResultsUnpacker {
        Function<Object, Object> function;

        public ArrayUnpacker(Function<Object, Object> itemMapper) {
            this.function = itemMapper;
        }

        @Override
        public Object unpack(Object object) {
            if (object == null) {
                return null;
            }
            List source = (List)object;
            ArrayList<Object> results = new ArrayList<Object>(source.size());
            for (Object thisObject : source) {
                results.add(this.function.apply(thisObject));
            }
            return results;
        }
    }

    public static class ElementUnpacker
    implements ResultsUnpacker {
        Function<Object, Object> function;

        public ElementUnpacker(Function<Object, Object> itemMapper) {
            this.function = itemMapper;
        }

        @Override
        public Object unpack(Object object) {
            return this.function.apply(object);
        }
    }

    public static class IdentityUnpacker
    implements ResultsUnpacker {
        public static final IdentityUnpacker instance = new IdentityUnpacker();

        private IdentityUnpacker() {
        }

        @Override
        public Object unpack(Object object) {
            return object;
        }
    }

    public static class ListUnpacker
    implements ResultsUnpacker {
        public static final ListUnpacker instance = new ListUnpacker();

        private ListUnpacker() {
        }

        @Override
        public Object unpack(Object object) {
            if (object == null) {
                return null;
            }
            List list = (List)object;
            return list.isEmpty() ? null : list.get(0);
        }
    }
}

