/*
 * Decompiled with CFR 0.152.
 */
package com.aerospike.mapper.tools.virtuallist;

import com.aerospike.client.Operation;
import com.aerospike.client.Value;
import com.aerospike.client.cdt.CTX;
import com.aerospike.client.cdt.ListOperation;
import com.aerospike.client.cdt.MapOperation;
import com.aerospike.client.cdt.MapOrder;
import com.aerospike.client.cdt.MapPolicy;
import com.aerospike.mapper.annotations.AerospikeEmbed;
import com.aerospike.mapper.tools.ClassCacheEntry;
import com.aerospike.mapper.tools.IBaseAeroMapper;
import com.aerospike.mapper.tools.utils.TypeUtils;
import com.aerospike.mapper.tools.virtuallist.DeferredOperation;
import com.aerospike.mapper.tools.virtuallist.Interactor;
import com.aerospike.mapper.tools.virtuallist.OperationParameters;
import com.aerospike.mapper.tools.virtuallist.ResultsUnpacker;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

public class VirtualListInteractors {
    private final String binName;
    private final AerospikeEmbed.EmbedType listType;
    private final ClassCacheEntry<?> elementEntry;
    private final Function<Object, Object> instanceMapper;
    private final IBaseAeroMapper mapper;

    public VirtualListInteractors(String binName, AerospikeEmbed.EmbedType listType, ClassCacheEntry<?> elementEntry, Function<Object, Object> instanceMapper, IBaseAeroMapper mapper) {
        this.binName = binName;
        this.listType = listType;
        this.elementEntry = elementEntry;
        this.instanceMapper = instanceMapper;
        this.mapper = mapper;
    }

    public Interactor getGetByValueInteractor(final Object value) {
        DeferredOperation deferred = new DeferredOperation(){

            @Override
            public ResultsUnpacker[] getUnpackers(OperationParameters operationParams) {
                switch (operationParams.getNeedsResultOfType()) {
                    case DEFAULT: 
                    case ELEMENTS: {
                        return new ResultsUnpacker[]{new ResultsUnpacker.ArrayUnpacker(VirtualListInteractors.this.instanceMapper)};
                    }
                }
                return new ResultsUnpacker[0];
            }

            @Override
            public Operation getOperation(OperationParameters operationParams) {
                if (VirtualListInteractors.this.listType == AerospikeEmbed.EmbedType.LIST) {
                    return ListOperation.getByValue((String)VirtualListInteractors.this.binName, (Value)VirtualListInteractors.this.getValue(value, false), (int)TypeUtils.returnTypeToListReturnType(operationParams.getNeedsResultOfType()), (CTX[])new CTX[0]);
                }
                return MapOperation.getByValue((String)VirtualListInteractors.this.binName, (Value)VirtualListInteractors.this.getValue(value, false), (int)TypeUtils.returnTypeToMapReturnType(operationParams.getNeedsResultOfType()), (CTX[])new CTX[0]);
            }

            @Override
            public boolean isGetOperation() {
                return true;
            }
        };
        return new Interactor(deferred);
    }

    public Interactor getGetByValueRangeInteractor(final Object startValue, final Object endValue) {
        DeferredOperation deferred = new DeferredOperation(){

            @Override
            public ResultsUnpacker[] getUnpackers(OperationParameters operationParams) {
                switch (operationParams.getNeedsResultOfType()) {
                    case DEFAULT: 
                    case ELEMENTS: {
                        return new ResultsUnpacker[]{new ResultsUnpacker.ArrayUnpacker(VirtualListInteractors.this.instanceMapper)};
                    }
                }
                return new ResultsUnpacker[0];
            }

            @Override
            public Operation getOperation(OperationParameters operationParams) {
                if (VirtualListInteractors.this.listType == AerospikeEmbed.EmbedType.LIST) {
                    return ListOperation.getByValueRange((String)VirtualListInteractors.this.binName, (Value)VirtualListInteractors.this.getValue(startValue, false), (Value)VirtualListInteractors.this.getValue(endValue, false), (int)TypeUtils.returnTypeToListReturnType(operationParams.getNeedsResultOfType()), (CTX[])new CTX[0]);
                }
                return MapOperation.getByValueRange((String)VirtualListInteractors.this.binName, (Value)VirtualListInteractors.this.getValue(startValue, false), (Value)VirtualListInteractors.this.getValue(endValue, false), (int)TypeUtils.returnTypeToMapReturnType(operationParams.getNeedsResultOfType()), (CTX[])new CTX[0]);
            }

            @Override
            public boolean isGetOperation() {
                return true;
            }
        };
        return new Interactor(deferred);
    }

    public Interactor getGetByValueListInteractor(final List<Object> values) {
        DeferredOperation deferred = new DeferredOperation(){

            @Override
            public ResultsUnpacker[] getUnpackers(OperationParameters operationParams) {
                switch (operationParams.getNeedsResultOfType()) {
                    case DEFAULT: 
                    case ELEMENTS: {
                        return new ResultsUnpacker[]{new ResultsUnpacker.ArrayUnpacker(VirtualListInteractors.this.instanceMapper)};
                    }
                }
                return new ResultsUnpacker[0];
            }

            @Override
            public Operation getOperation(OperationParameters operationParams) {
                List aerospikeValues = values.stream().map(x -> VirtualListInteractors.this.getValue(x, false)).collect(Collectors.toList());
                if (VirtualListInteractors.this.listType == AerospikeEmbed.EmbedType.LIST) {
                    return ListOperation.getByValueList((String)VirtualListInteractors.this.binName, aerospikeValues, (int)TypeUtils.returnTypeToListReturnType(operationParams.getNeedsResultOfType()), (CTX[])new CTX[0]);
                }
                return MapOperation.getByValueList((String)VirtualListInteractors.this.binName, aerospikeValues, (int)TypeUtils.returnTypeToMapReturnType(operationParams.getNeedsResultOfType()), (CTX[])new CTX[0]);
            }

            @Override
            public boolean isGetOperation() {
                return true;
            }
        };
        return new Interactor(deferred);
    }

    public Interactor getGetByValueRelativeRankRangeInteractor(final Object value, final int rank) {
        DeferredOperation deferred = new DeferredOperation(){

            @Override
            public ResultsUnpacker[] getUnpackers(OperationParameters operationParams) {
                switch (operationParams.getNeedsResultOfType()) {
                    case DEFAULT: 
                    case ELEMENTS: {
                        return new ResultsUnpacker[]{new ResultsUnpacker.ArrayUnpacker(VirtualListInteractors.this.instanceMapper)};
                    }
                }
                return new ResultsUnpacker[0];
            }

            @Override
            public Operation getOperation(OperationParameters operationParams) {
                if (VirtualListInteractors.this.listType == AerospikeEmbed.EmbedType.LIST) {
                    return ListOperation.getByValueRelativeRankRange((String)VirtualListInteractors.this.binName, (Value)VirtualListInteractors.this.getValue(value, false), (int)rank, (int)TypeUtils.returnTypeToListReturnType(operationParams.getNeedsResultOfType()), (CTX[])new CTX[0]);
                }
                return MapOperation.getByValueRelativeRankRange((String)VirtualListInteractors.this.binName, (Value)VirtualListInteractors.this.getValue(value, false), (int)rank, (int)TypeUtils.returnTypeToMapReturnType(operationParams.getNeedsResultOfType()), (CTX[])new CTX[0]);
            }

            @Override
            public boolean isGetOperation() {
                return true;
            }
        };
        return new Interactor(deferred);
    }

    public Interactor getGetByValueRelativeRankRangeInteractor(final Object value, final int rank, final int count) {
        DeferredOperation deferred = new DeferredOperation(){

            @Override
            public ResultsUnpacker[] getUnpackers(OperationParameters operationParams) {
                switch (operationParams.getNeedsResultOfType()) {
                    case DEFAULT: 
                    case ELEMENTS: {
                        return new ResultsUnpacker[]{new ResultsUnpacker.ArrayUnpacker(VirtualListInteractors.this.instanceMapper)};
                    }
                }
                return new ResultsUnpacker[0];
            }

            @Override
            public Operation getOperation(OperationParameters operationParams) {
                if (VirtualListInteractors.this.listType == AerospikeEmbed.EmbedType.LIST) {
                    return ListOperation.getByValueRelativeRankRange((String)VirtualListInteractors.this.binName, (Value)VirtualListInteractors.this.getValue(value, false), (int)rank, (int)count, (int)TypeUtils.returnTypeToListReturnType(operationParams.getNeedsResultOfType()), (CTX[])new CTX[0]);
                }
                return MapOperation.getByValueRelativeRankRange((String)VirtualListInteractors.this.binName, (Value)VirtualListInteractors.this.getValue(value, false), (int)rank, (int)count, (int)TypeUtils.returnTypeToMapReturnType(operationParams.getNeedsResultOfType()), (CTX[])new CTX[0]);
            }

            @Override
            public boolean isGetOperation() {
                return true;
            }
        };
        return new Interactor(deferred);
    }

    public Interactor getGetByIndexRangeInteractor(final int index) {
        DeferredOperation deferred = new DeferredOperation(){

            @Override
            public ResultsUnpacker[] getUnpackers(OperationParameters operationParams) {
                switch (operationParams.getNeedsResultOfType()) {
                    case DEFAULT: 
                    case ELEMENTS: {
                        return new ResultsUnpacker[]{new ResultsUnpacker.ArrayUnpacker(VirtualListInteractors.this.instanceMapper)};
                    }
                }
                return new ResultsUnpacker[0];
            }

            @Override
            public Operation getOperation(OperationParameters operationParams) {
                if (VirtualListInteractors.this.listType == AerospikeEmbed.EmbedType.LIST) {
                    return ListOperation.getByIndexRange((String)VirtualListInteractors.this.binName, (int)index, (int)TypeUtils.returnTypeToListReturnType(operationParams.getNeedsResultOfType()), (CTX[])new CTX[0]);
                }
                return MapOperation.getByIndexRange((String)VirtualListInteractors.this.binName, (int)index, (int)TypeUtils.returnTypeToMapReturnType(operationParams.getNeedsResultOfType()), (CTX[])new CTX[0]);
            }

            @Override
            public boolean isGetOperation() {
                return true;
            }
        };
        return new Interactor(deferred);
    }

    public Interactor getGetByIndexRangeInteractor(final int index, final int count) {
        DeferredOperation deferred = new DeferredOperation(){

            @Override
            public ResultsUnpacker[] getUnpackers(OperationParameters operationParams) {
                switch (operationParams.getNeedsResultOfType()) {
                    case DEFAULT: 
                    case ELEMENTS: {
                        return new ResultsUnpacker[]{new ResultsUnpacker.ArrayUnpacker(VirtualListInteractors.this.instanceMapper)};
                    }
                }
                return new ResultsUnpacker[0];
            }

            @Override
            public Operation getOperation(OperationParameters operationParams) {
                if (VirtualListInteractors.this.listType == AerospikeEmbed.EmbedType.LIST) {
                    return ListOperation.getByIndexRange((String)VirtualListInteractors.this.binName, (int)index, (int)count, (int)TypeUtils.returnTypeToListReturnType(operationParams.getNeedsResultOfType()), (CTX[])new CTX[0]);
                }
                return MapOperation.getByIndexRange((String)VirtualListInteractors.this.binName, (int)index, (int)count, (int)TypeUtils.returnTypeToMapReturnType(operationParams.getNeedsResultOfType()), (CTX[])new CTX[0]);
            }

            @Override
            public boolean isGetOperation() {
                return true;
            }
        };
        return new Interactor(deferred);
    }

    public Interactor getGetByRankInteractor(final int index) {
        DeferredOperation deferred = new DeferredOperation(){

            @Override
            public ResultsUnpacker[] getUnpackers(OperationParameters operationParams) {
                switch (operationParams.getNeedsResultOfType()) {
                    case DEFAULT: 
                    case ELEMENTS: {
                        return new ResultsUnpacker[]{new ResultsUnpacker.ArrayUnpacker(VirtualListInteractors.this.instanceMapper)};
                    }
                }
                return new ResultsUnpacker[0];
            }

            @Override
            public Operation getOperation(OperationParameters operationParams) {
                if (VirtualListInteractors.this.listType == AerospikeEmbed.EmbedType.LIST) {
                    return ListOperation.getByRank((String)VirtualListInteractors.this.binName, (int)index, (int)TypeUtils.returnTypeToListReturnType(operationParams.getNeedsResultOfType()), (CTX[])new CTX[0]);
                }
                return MapOperation.getByRank((String)VirtualListInteractors.this.binName, (int)index, (int)TypeUtils.returnTypeToMapReturnType(operationParams.getNeedsResultOfType()), (CTX[])new CTX[0]);
            }

            @Override
            public boolean isGetOperation() {
                return true;
            }
        };
        return new Interactor(deferred);
    }

    public Interactor getGetByRankRangeInteractor(final int index) {
        DeferredOperation deferred = new DeferredOperation(){

            @Override
            public ResultsUnpacker[] getUnpackers(OperationParameters operationParams) {
                switch (operationParams.getNeedsResultOfType()) {
                    case DEFAULT: 
                    case ELEMENTS: {
                        return new ResultsUnpacker[]{new ResultsUnpacker.ArrayUnpacker(VirtualListInteractors.this.instanceMapper)};
                    }
                }
                return new ResultsUnpacker[0];
            }

            @Override
            public Operation getOperation(OperationParameters operationParams) {
                if (VirtualListInteractors.this.listType == AerospikeEmbed.EmbedType.LIST) {
                    return ListOperation.getByRankRange((String)VirtualListInteractors.this.binName, (int)index, (int)TypeUtils.returnTypeToListReturnType(operationParams.getNeedsResultOfType()), (CTX[])new CTX[0]);
                }
                return MapOperation.getByRankRange((String)VirtualListInteractors.this.binName, (int)index, (int)TypeUtils.returnTypeToMapReturnType(operationParams.getNeedsResultOfType()), (CTX[])new CTX[0]);
            }

            @Override
            public boolean isGetOperation() {
                return true;
            }
        };
        return new Interactor(deferred);
    }

    public Interactor getGetByRankRangeInteractor(final int index, final int count) {
        DeferredOperation deferred = new DeferredOperation(){

            @Override
            public ResultsUnpacker[] getUnpackers(OperationParameters operationParams) {
                switch (operationParams.getNeedsResultOfType()) {
                    case DEFAULT: 
                    case ELEMENTS: {
                        return new ResultsUnpacker[]{new ResultsUnpacker.ArrayUnpacker(VirtualListInteractors.this.instanceMapper)};
                    }
                }
                return new ResultsUnpacker[0];
            }

            @Override
            public Operation getOperation(OperationParameters operationParams) {
                if (VirtualListInteractors.this.listType == AerospikeEmbed.EmbedType.LIST) {
                    return ListOperation.getByRankRange((String)VirtualListInteractors.this.binName, (int)index, (int)count, (int)TypeUtils.returnTypeToListReturnType(operationParams.getNeedsResultOfType()), (CTX[])new CTX[0]);
                }
                return MapOperation.getByRankRange((String)VirtualListInteractors.this.binName, (int)index, (int)count, (int)TypeUtils.returnTypeToMapReturnType(operationParams.getNeedsResultOfType()), (CTX[])new CTX[0]);
            }

            @Override
            public boolean isGetOperation() {
                return true;
            }
        };
        return new Interactor(deferred);
    }

    public Interactor getGetByKeyInteractor(final Object key) {
        DeferredOperation deferred = new DeferredOperation(){

            @Override
            public ResultsUnpacker[] getUnpackers(OperationParameters operationParams) {
                switch (operationParams.getNeedsResultOfType()) {
                    case DEFAULT: 
                    case ELEMENTS: {
                        return new ResultsUnpacker[]{new ResultsUnpacker.ArrayUnpacker(VirtualListInteractors.this.instanceMapper)};
                    }
                }
                return new ResultsUnpacker[0];
            }

            @Override
            public Operation getOperation(OperationParameters operationParams) {
                if (VirtualListInteractors.this.listType == AerospikeEmbed.EmbedType.LIST) {
                    return ListOperation.getByValue((String)VirtualListInteractors.this.binName, (Value)VirtualListInteractors.this.getValue(key, true), (int)TypeUtils.returnTypeToListReturnType(operationParams.getNeedsResultOfType()), (CTX[])new CTX[0]);
                }
                return MapOperation.getByKey((String)VirtualListInteractors.this.binName, (Value)VirtualListInteractors.this.getValue(key, true), (int)TypeUtils.returnTypeToMapReturnType(operationParams.getNeedsResultOfType()), (CTX[])new CTX[0]);
            }

            @Override
            public boolean isGetOperation() {
                return true;
            }
        };
        return new Interactor(deferred);
    }

    public Interactor getGetByKeyRangeInteractor(final Object startKey, final Object endKey) {
        DeferredOperation deferred = new DeferredOperation(){

            @Override
            public ResultsUnpacker[] getUnpackers(OperationParameters operationParams) {
                switch (operationParams.getNeedsResultOfType()) {
                    case DEFAULT: 
                    case ELEMENTS: {
                        return new ResultsUnpacker[]{new ResultsUnpacker.ArrayUnpacker(VirtualListInteractors.this.instanceMapper)};
                    }
                }
                return new ResultsUnpacker[0];
            }

            @Override
            public Operation getOperation(OperationParameters operationParams) {
                if (VirtualListInteractors.this.listType == AerospikeEmbed.EmbedType.LIST) {
                    return ListOperation.getByValueRange((String)VirtualListInteractors.this.binName, (Value)VirtualListInteractors.this.getValue(startKey, true), (Value)VirtualListInteractors.this.getValue(endKey, true), (int)TypeUtils.returnTypeToListReturnType(operationParams.getNeedsResultOfType()), (CTX[])new CTX[0]);
                }
                return MapOperation.getByKeyRange((String)VirtualListInteractors.this.binName, (Value)VirtualListInteractors.this.getValue(startKey, true), (Value)VirtualListInteractors.this.getValue(endKey, true), (int)TypeUtils.returnTypeToMapReturnType(operationParams.getNeedsResultOfType()), (CTX[])new CTX[0]);
            }

            @Override
            public boolean isGetOperation() {
                return true;
            }
        };
        return new Interactor(deferred);
    }

    public Interactor getRemoveKeyRangeInteractor(final Object startKey, final Object endKey) {
        DeferredOperation deferred = new DeferredOperation(){

            @Override
            public ResultsUnpacker[] getUnpackers(OperationParameters operationParams) {
                switch (operationParams.getNeedsResultOfType()) {
                    case DEFAULT: 
                    case ELEMENTS: {
                        return new ResultsUnpacker[]{new ResultsUnpacker.ArrayUnpacker(VirtualListInteractors.this.instanceMapper)};
                    }
                }
                return new ResultsUnpacker[0];
            }

            @Override
            public Operation getOperation(OperationParameters operationParams) {
                if (VirtualListInteractors.this.listType == AerospikeEmbed.EmbedType.LIST) {
                    return ListOperation.removeByValueRange((String)VirtualListInteractors.this.binName, (Value)VirtualListInteractors.this.getValue(startKey, true), (Value)VirtualListInteractors.this.getValue(endKey, true), (int)TypeUtils.returnTypeToListReturnType(operationParams.getNeedsResultOfType()), (CTX[])new CTX[0]);
                }
                return MapOperation.removeByKeyRange((String)VirtualListInteractors.this.binName, (Value)VirtualListInteractors.this.getValue(startKey, true), (Value)VirtualListInteractors.this.getValue(endKey, true), (int)TypeUtils.returnTypeToMapReturnType(operationParams.getNeedsResultOfType()), (CTX[])new CTX[0]);
            }

            @Override
            public boolean isGetOperation() {
                return false;
            }
        };
        return new Interactor(deferred);
    }

    public Interactor getRemoveKeyInteractor(final Object key) {
        DeferredOperation deferred = new DeferredOperation(){

            @Override
            public ResultsUnpacker[] getUnpackers(OperationParameters operationParams) {
                switch (operationParams.getNeedsResultOfType()) {
                    case DEFAULT: 
                    case ELEMENTS: {
                        return new ResultsUnpacker[]{new ResultsUnpacker.ArrayUnpacker(VirtualListInteractors.this.instanceMapper)};
                    }
                }
                return new ResultsUnpacker[0];
            }

            @Override
            public Operation getOperation(OperationParameters operationParams) {
                if (VirtualListInteractors.this.listType == AerospikeEmbed.EmbedType.LIST) {
                    return ListOperation.removeByValue((String)VirtualListInteractors.this.binName, (Value)VirtualListInteractors.this.getValue(key, true), (int)TypeUtils.returnTypeToListReturnType(operationParams.getNeedsResultOfType()), (CTX[])new CTX[0]);
                }
                return MapOperation.removeByKey((String)VirtualListInteractors.this.binName, (Value)VirtualListInteractors.this.getValue(key, true), (int)TypeUtils.returnTypeToMapReturnType(operationParams.getNeedsResultOfType()), (CTX[])new CTX[0]);
            }

            @Override
            public boolean isGetOperation() {
                return false;
            }
        };
        return new Interactor(deferred);
    }

    public Interactor getRemoveByValueInteractor(final Object value) {
        DeferredOperation deferred = new DeferredOperation(){

            @Override
            public ResultsUnpacker[] getUnpackers(OperationParameters operationParams) {
                switch (operationParams.getNeedsResultOfType()) {
                    case DEFAULT: 
                    case ELEMENTS: {
                        return new ResultsUnpacker[]{new ResultsUnpacker.ArrayUnpacker(VirtualListInteractors.this.instanceMapper)};
                    }
                }
                return new ResultsUnpacker[0];
            }

            @Override
            public Operation getOperation(OperationParameters operationParams) {
                if (VirtualListInteractors.this.listType == AerospikeEmbed.EmbedType.LIST) {
                    return ListOperation.removeByValue((String)VirtualListInteractors.this.binName, (Value)VirtualListInteractors.this.getValue(value, false), (int)TypeUtils.returnTypeToListReturnType(operationParams.getNeedsResultOfType()), (CTX[])new CTX[0]);
                }
                return MapOperation.removeByValue((String)VirtualListInteractors.this.binName, (Value)VirtualListInteractors.this.getValue(value, false), (int)TypeUtils.returnTypeToMapReturnType(operationParams.getNeedsResultOfType()), (CTX[])new CTX[0]);
            }

            @Override
            public boolean isGetOperation() {
                return false;
            }
        };
        return new Interactor(deferred);
    }

    public Interactor getRemoveByValueListInteractor(final List<Object> values) {
        DeferredOperation deferred = new DeferredOperation(){

            @Override
            public ResultsUnpacker[] getUnpackers(OperationParameters operationParams) {
                switch (operationParams.getNeedsResultOfType()) {
                    case DEFAULT: 
                    case ELEMENTS: {
                        return new ResultsUnpacker[]{new ResultsUnpacker.ArrayUnpacker(VirtualListInteractors.this.instanceMapper)};
                    }
                }
                return new ResultsUnpacker[0];
            }

            @Override
            public Operation getOperation(OperationParameters operationParams) {
                List aerospikeValues = values.stream().map(x -> VirtualListInteractors.this.getValue(x, false)).collect(Collectors.toList());
                if (VirtualListInteractors.this.listType == AerospikeEmbed.EmbedType.LIST) {
                    return ListOperation.removeByValueList((String)VirtualListInteractors.this.binName, aerospikeValues, (int)TypeUtils.returnTypeToListReturnType(operationParams.getNeedsResultOfType()), (CTX[])new CTX[0]);
                }
                return MapOperation.removeByValueList((String)VirtualListInteractors.this.binName, aerospikeValues, (int)TypeUtils.returnTypeToMapReturnType(operationParams.getNeedsResultOfType()), (CTX[])new CTX[0]);
            }

            @Override
            public boolean isGetOperation() {
                return false;
            }
        };
        return new Interactor(deferred);
    }

    public Interactor getRemoveByValueRangeInteractor(final Object startValue, final Object endValue) {
        DeferredOperation deferred = new DeferredOperation(){

            @Override
            public ResultsUnpacker[] getUnpackers(OperationParameters operationParams) {
                switch (operationParams.getNeedsResultOfType()) {
                    case DEFAULT: 
                    case ELEMENTS: {
                        return new ResultsUnpacker[]{new ResultsUnpacker.ArrayUnpacker(VirtualListInteractors.this.instanceMapper)};
                    }
                }
                return new ResultsUnpacker[0];
            }

            @Override
            public Operation getOperation(OperationParameters operationParams) {
                if (VirtualListInteractors.this.listType == AerospikeEmbed.EmbedType.LIST) {
                    return ListOperation.removeByValueRange((String)VirtualListInteractors.this.binName, (Value)VirtualListInteractors.this.getValue(startValue, false), (Value)VirtualListInteractors.this.getValue(endValue, false), (int)TypeUtils.returnTypeToListReturnType(operationParams.getNeedsResultOfType()), (CTX[])new CTX[0]);
                }
                return MapOperation.removeByValueRange((String)VirtualListInteractors.this.binName, (Value)VirtualListInteractors.this.getValue(startValue, false), (Value)VirtualListInteractors.this.getValue(endValue, false), (int)TypeUtils.returnTypeToMapReturnType(operationParams.getNeedsResultOfType()), (CTX[])new CTX[0]);
            }

            @Override
            public boolean isGetOperation() {
                return false;
            }
        };
        return new Interactor(deferred);
    }

    public Interactor getRemoveByValueRelativeRankRangeInteractor(final Object value, final int rank) {
        DeferredOperation deferred = new DeferredOperation(){

            @Override
            public ResultsUnpacker[] getUnpackers(OperationParameters operationParams) {
                switch (operationParams.getNeedsResultOfType()) {
                    case DEFAULT: 
                    case ELEMENTS: {
                        return new ResultsUnpacker[]{new ResultsUnpacker.ArrayUnpacker(VirtualListInteractors.this.instanceMapper)};
                    }
                }
                return new ResultsUnpacker[0];
            }

            @Override
            public Operation getOperation(OperationParameters operationParams) {
                if (VirtualListInteractors.this.listType == AerospikeEmbed.EmbedType.LIST) {
                    return ListOperation.removeByValueRelativeRankRange((String)VirtualListInteractors.this.binName, (Value)VirtualListInteractors.this.getValue(value, false), (int)rank, (int)TypeUtils.returnTypeToListReturnType(operationParams.getNeedsResultOfType()), (CTX[])new CTX[0]);
                }
                return MapOperation.removeByValueRelativeRankRange((String)VirtualListInteractors.this.binName, (Value)VirtualListInteractors.this.getValue(value, false), (int)rank, (int)TypeUtils.returnTypeToMapReturnType(operationParams.getNeedsResultOfType()), (CTX[])new CTX[0]);
            }

            @Override
            public boolean isGetOperation() {
                return false;
            }
        };
        return new Interactor(deferred);
    }

    public Interactor getRemoveByValueRelativeRankRangeInteractor(final Object value, final int rank, final int count) {
        DeferredOperation deferred = new DeferredOperation(){

            @Override
            public ResultsUnpacker[] getUnpackers(OperationParameters operationParams) {
                switch (operationParams.getNeedsResultOfType()) {
                    case DEFAULT: 
                    case ELEMENTS: {
                        return new ResultsUnpacker[]{new ResultsUnpacker.ArrayUnpacker(VirtualListInteractors.this.instanceMapper)};
                    }
                }
                return new ResultsUnpacker[0];
            }

            @Override
            public Operation getOperation(OperationParameters operationParams) {
                if (VirtualListInteractors.this.listType == AerospikeEmbed.EmbedType.LIST) {
                    return ListOperation.removeByValueRelativeRankRange((String)VirtualListInteractors.this.binName, (Value)VirtualListInteractors.this.getValue(value, false), (int)rank, (int)count, (int)TypeUtils.returnTypeToListReturnType(operationParams.getNeedsResultOfType()), (CTX[])new CTX[0]);
                }
                return MapOperation.removeByValueRelativeRankRange((String)VirtualListInteractors.this.binName, (Value)VirtualListInteractors.this.getValue(value, false), (int)rank, (int)count, (int)TypeUtils.returnTypeToMapReturnType(operationParams.getNeedsResultOfType()), (CTX[])new CTX[0]);
            }

            @Override
            public boolean isGetOperation() {
                return false;
            }
        };
        return new Interactor(deferred);
    }

    public Interactor getRemoveByIndexInteractor(final int index) {
        DeferredOperation deferred = new DeferredOperation(){

            @Override
            public ResultsUnpacker[] getUnpackers(OperationParameters operationParams) {
                switch (operationParams.getNeedsResultOfType()) {
                    case DEFAULT: 
                    case ELEMENTS: {
                        return new ResultsUnpacker[]{new ResultsUnpacker.ArrayUnpacker(VirtualListInteractors.this.instanceMapper)};
                    }
                }
                return new ResultsUnpacker[0];
            }

            @Override
            public Operation getOperation(OperationParameters operationParams) {
                if (VirtualListInteractors.this.listType == AerospikeEmbed.EmbedType.LIST) {
                    return ListOperation.removeByIndex((String)VirtualListInteractors.this.binName, (int)index, (int)TypeUtils.returnTypeToListReturnType(operationParams.getNeedsResultOfType()), (CTX[])new CTX[0]);
                }
                return MapOperation.removeByIndex((String)VirtualListInteractors.this.binName, (int)index, (int)TypeUtils.returnTypeToMapReturnType(operationParams.getNeedsResultOfType()), (CTX[])new CTX[0]);
            }

            @Override
            public boolean isGetOperation() {
                return false;
            }
        };
        return new Interactor(deferred);
    }

    public Interactor getRemoveByIndexRangeInteractor(final int index) {
        DeferredOperation deferred = new DeferredOperation(){

            @Override
            public ResultsUnpacker[] getUnpackers(OperationParameters operationParams) {
                switch (operationParams.getNeedsResultOfType()) {
                    case DEFAULT: 
                    case ELEMENTS: {
                        return new ResultsUnpacker[]{new ResultsUnpacker.ArrayUnpacker(VirtualListInteractors.this.instanceMapper)};
                    }
                }
                return new ResultsUnpacker[0];
            }

            @Override
            public Operation getOperation(OperationParameters operationParams) {
                if (VirtualListInteractors.this.listType == AerospikeEmbed.EmbedType.LIST) {
                    return ListOperation.removeByIndexRange((String)VirtualListInteractors.this.binName, (int)index, (int)TypeUtils.returnTypeToListReturnType(operationParams.getNeedsResultOfType()), (CTX[])new CTX[0]);
                }
                return MapOperation.removeByIndexRange((String)VirtualListInteractors.this.binName, (int)index, (int)TypeUtils.returnTypeToMapReturnType(operationParams.getNeedsResultOfType()), (CTX[])new CTX[0]);
            }

            @Override
            public boolean isGetOperation() {
                return false;
            }
        };
        return new Interactor(deferred);
    }

    public Interactor getRemoveByIndexRangeInteractor(final int index, final int count) {
        DeferredOperation deferred = new DeferredOperation(){

            @Override
            public ResultsUnpacker[] getUnpackers(OperationParameters operationParams) {
                switch (operationParams.getNeedsResultOfType()) {
                    case DEFAULT: 
                    case ELEMENTS: {
                        return new ResultsUnpacker[]{new ResultsUnpacker.ArrayUnpacker(VirtualListInteractors.this.instanceMapper)};
                    }
                }
                return new ResultsUnpacker[0];
            }

            @Override
            public Operation getOperation(OperationParameters operationParams) {
                if (VirtualListInteractors.this.listType == AerospikeEmbed.EmbedType.LIST) {
                    return ListOperation.removeByIndexRange((String)VirtualListInteractors.this.binName, (int)index, (int)count, (int)TypeUtils.returnTypeToListReturnType(operationParams.getNeedsResultOfType()), (CTX[])new CTX[0]);
                }
                return MapOperation.removeByIndexRange((String)VirtualListInteractors.this.binName, (int)index, (int)count, (int)TypeUtils.returnTypeToMapReturnType(operationParams.getNeedsResultOfType()), (CTX[])new CTX[0]);
            }

            @Override
            public boolean isGetOperation() {
                return false;
            }
        };
        return new Interactor(deferred);
    }

    public Interactor getRemoveByRankInteractor(final int rank) {
        DeferredOperation deferred = new DeferredOperation(){

            @Override
            public ResultsUnpacker[] getUnpackers(OperationParameters operationParams) {
                switch (operationParams.getNeedsResultOfType()) {
                    case DEFAULT: 
                    case ELEMENTS: {
                        return new ResultsUnpacker[]{new ResultsUnpacker.ArrayUnpacker(VirtualListInteractors.this.instanceMapper)};
                    }
                }
                return new ResultsUnpacker[0];
            }

            @Override
            public Operation getOperation(OperationParameters operationParams) {
                if (VirtualListInteractors.this.listType == AerospikeEmbed.EmbedType.LIST) {
                    return ListOperation.removeByRank((String)VirtualListInteractors.this.binName, (int)rank, (int)TypeUtils.returnTypeToListReturnType(operationParams.getNeedsResultOfType()), (CTX[])new CTX[0]);
                }
                return MapOperation.removeByRank((String)VirtualListInteractors.this.binName, (int)rank, (int)TypeUtils.returnTypeToMapReturnType(operationParams.getNeedsResultOfType()), (CTX[])new CTX[0]);
            }

            @Override
            public boolean isGetOperation() {
                return false;
            }
        };
        return new Interactor(deferred);
    }

    public Interactor getRemoveByRankRangeInteractor(final int rank) {
        DeferredOperation deferred = new DeferredOperation(){

            @Override
            public ResultsUnpacker[] getUnpackers(OperationParameters operationParams) {
                switch (operationParams.getNeedsResultOfType()) {
                    case DEFAULT: 
                    case ELEMENTS: {
                        return new ResultsUnpacker[]{new ResultsUnpacker.ArrayUnpacker(VirtualListInteractors.this.instanceMapper)};
                    }
                }
                return new ResultsUnpacker[0];
            }

            @Override
            public Operation getOperation(OperationParameters operationParams) {
                if (VirtualListInteractors.this.listType == AerospikeEmbed.EmbedType.LIST) {
                    return ListOperation.removeByRankRange((String)VirtualListInteractors.this.binName, (int)rank, (int)TypeUtils.returnTypeToListReturnType(operationParams.getNeedsResultOfType()), (CTX[])new CTX[0]);
                }
                return MapOperation.removeByRankRange((String)VirtualListInteractors.this.binName, (int)rank, (int)TypeUtils.returnTypeToMapReturnType(operationParams.getNeedsResultOfType()), (CTX[])new CTX[0]);
            }

            @Override
            public boolean isGetOperation() {
                return false;
            }
        };
        return new Interactor(deferred);
    }

    public Interactor getRemoveByRankRangeInteractor(final int rank, final int count) {
        DeferredOperation deferred = new DeferredOperation(){

            @Override
            public ResultsUnpacker[] getUnpackers(OperationParameters operationParams) {
                switch (operationParams.getNeedsResultOfType()) {
                    case DEFAULT: 
                    case ELEMENTS: {
                        return new ResultsUnpacker[]{new ResultsUnpacker.ArrayUnpacker(VirtualListInteractors.this.instanceMapper)};
                    }
                }
                return new ResultsUnpacker[0];
            }

            @Override
            public Operation getOperation(OperationParameters operationParams) {
                if (VirtualListInteractors.this.listType == AerospikeEmbed.EmbedType.LIST) {
                    return ListOperation.removeByRankRange((String)VirtualListInteractors.this.binName, (int)rank, (int)count, (int)TypeUtils.returnTypeToListReturnType(operationParams.getNeedsResultOfType()), (CTX[])new CTX[0]);
                }
                return MapOperation.removeByRankRange((String)VirtualListInteractors.this.binName, (int)rank, (int)count, (int)TypeUtils.returnTypeToMapReturnType(operationParams.getNeedsResultOfType()), (CTX[])new CTX[0]);
            }

            @Override
            public boolean isGetOperation() {
                return false;
            }
        };
        return new Interactor(deferred);
    }

    public Value getValue(Object javaObject, boolean isKey) {
        Object aerospikeObject = isKey ? this.elementEntry.translateKeyToAerospikeKey(javaObject) : this.mapper.getMappingConverter().translateToAerospike(javaObject);
        if (aerospikeObject == null) {
            return null;
        }
        return Value.get((Object)aerospikeObject);
    }

    public Operation getAppendOperation(Object aerospikeObject) {
        if (aerospikeObject instanceof Map.Entry) {
            Map.Entry entry = (Map.Entry)aerospikeObject;
            return MapOperation.put((MapPolicy)new MapPolicy(MapOrder.KEY_ORDERED, 0), (String)this.binName, (Value)Value.get(entry.getKey()), (Value)Value.get(entry.getValue()), (CTX[])new CTX[0]);
        }
        return ListOperation.append((String)this.binName, (Value)Value.get((Object)aerospikeObject), (CTX[])new CTX[0]);
    }

    public Interactor getByIndexInteractor(int index) {
        if (this.listType == AerospikeEmbed.EmbedType.LIST) {
            return new Interactor(ListOperation.getByIndex((String)this.binName, (int)index, (int)7, (CTX[])new CTX[0]), new ResultsUnpacker.ElementUnpacker(this.instanceMapper));
        }
        return new Interactor(MapOperation.getByIndex((String)this.binName, (int)index, (int)8, (CTX[])new CTX[0]), ResultsUnpacker.ListUnpacker.instance, new ResultsUnpacker.ElementUnpacker(this.instanceMapper));
    }

    public Interactor getSizeInteractor() {
        if (this.listType == AerospikeEmbed.EmbedType.LIST) {
            return new Interactor(ListOperation.size((String)this.binName, (CTX[])new CTX[0]), new ResultsUnpacker[0]);
        }
        return new Interactor(MapOperation.size((String)this.binName, (CTX[])new CTX[0]), new ResultsUnpacker[0]);
    }

    public Interactor getClearInteractor() {
        if (this.listType == AerospikeEmbed.EmbedType.LIST) {
            return new Interactor(ListOperation.clear((String)this.binName, (CTX[])new CTX[0]), new ResultsUnpacker[0]);
        }
        return new Interactor(MapOperation.clear((String)this.binName, (CTX[])new CTX[0]), new ResultsUnpacker[0]);
    }
}

