/*
 * Decompiled with CFR 0.152.
 */
package com.aerospike.mapper.tools.mappers;

import com.aerospike.client.AerospikeException;
import com.aerospike.mapper.annotations.AerospikeEmbed;
import com.aerospike.mapper.tools.ClassCache;
import com.aerospike.mapper.tools.ClassCacheEntry;
import com.aerospike.mapper.tools.IBaseAeroMapper;
import com.aerospike.mapper.tools.mappers.ObjectMapper;
import java.util.List;
import java.util.Map;

public class ObjectEmbedMapper
extends ObjectMapper {
    private final Class<?> referencedClass;
    private final IBaseAeroMapper mapper;
    private final AerospikeEmbed.EmbedType type;
    private final boolean skipKey;

    public ObjectEmbedMapper(Class<?> clazz, AerospikeEmbed.EmbedType type, IBaseAeroMapper mapper, boolean skipKey) {
        this.referencedClass = clazz;
        this.mapper = mapper;
        this.type = type;
        this.skipKey = skipKey;
    }

    @Override
    public Object toAerospikeFormat(Object value) {
        if (value == null) {
            return null;
        }
        boolean needsType = !this.referencedClass.equals(value.getClass());
        ClassCacheEntry<?> entry = ClassCache.getInstance().loadClass(value.getClass(), this.mapper);
        switch (this.type) {
            case LIST: {
                return entry.getList(value, this.skipKey, needsType);
            }
            case MAP: 
            case DEFAULT: {
                return entry.getMap(value, needsType);
            }
        }
        throw new AerospikeException("Unspecified EmbedType");
    }

    @Override
    public Object fromAerospikeFormat(Object value) {
        if (value == null) {
            return null;
        }
        ClassCacheEntry<?> entry = ClassCache.getInstance().loadClass(this.referencedClass, this.mapper);
        try {
            Object instance;
            switch (this.type) {
                case LIST: {
                    List listValue = (List)value;
                    instance = entry.constructAndHydrate(listValue, this.skipKey);
                    break;
                }
                case MAP: 
                case DEFAULT: {
                    instance = entry.constructAndHydrate((Map)value);
                    break;
                }
                default: {
                    throw new AerospikeException("Unspecified EmbedType");
                }
            }
            return instance;
        }
        catch (Exception e) {
            throw new AerospikeException((Throwable)e);
        }
    }
}

