/*
 * Decompiled with CFR 0.152.
 */
package com.aerospike.mapper.tools.virtuallist;

import com.aerospike.client.Operation;
import com.aerospike.mapper.tools.virtuallist.DeferredOperation;
import com.aerospike.mapper.tools.virtuallist.OperationParameters;
import com.aerospike.mapper.tools.virtuallist.ResultsUnpacker;
import com.aerospike.mapper.tools.virtuallist.ReturnType;
import javax.validation.constraints.NotNull;

public class Interactor {
    private Operation operation;
    private DeferredOperation deferredOperation;
    private final OperationParameters deferredParameters;
    private ResultsUnpacker[] resultsUnpackers;

    public Interactor(@NotNull Operation operation, ResultsUnpacker ... resultsUnpackers) {
        this.operation = operation;
        this.resultsUnpackers = resultsUnpackers;
        this.deferredParameters = null;
    }

    public Interactor(@NotNull DeferredOperation deferredOperation) {
        this.deferredOperation = deferredOperation;
        this.deferredParameters = new OperationParameters();
    }

    public void setNeedsResultOfType(ReturnType returnType) {
        if (this.deferredParameters != null) {
            this.deferredParameters.setNeedsResultOfType(returnType);
        }
    }

    public Operation getOperation() {
        if (this.operation == null && this.deferredOperation != null) {
            this.operation = this.deferredOperation.getOperation(this.deferredParameters);
            this.resultsUnpackers = this.deferredOperation.getUnpackers(this.deferredParameters);
        }
        return this.operation;
    }

    public Object getResult(Object rawResult) {
        Object result = rawResult;
        for (ResultsUnpacker thisUnpacker : this.resultsUnpackers) {
            result = thisUnpacker.unpack(result);
        }
        return result;
    }

    public boolean isWriteOperation() {
        if (this.operation != null) {
            switch (this.operation.type) {
                case ADD: 
                case APPEND: 
                case BIT_MODIFY: 
                case CDT_MODIFY: 
                case DELETE: 
                case MAP_MODIFY: 
                case PREPEND: 
                case TOUCH: 
                case WRITE: {
                    return true;
                }
            }
            return false;
        }
        return !this.deferredOperation.isGetOperation();
    }
}

