/*
 * Decompiled with CFR 0.152.
 */
package com.aerospike.mapper.tools;

import com.aerospike.client.AerospikeException;
import com.aerospike.client.Log;
import com.aerospike.client.policy.BatchPolicy;
import com.aerospike.client.policy.Policy;
import com.aerospike.client.policy.QueryPolicy;
import com.aerospike.client.policy.ScanPolicy;
import com.aerospike.mapper.annotations.AerospikeRecord;
import com.aerospike.mapper.tools.ClassCache;
import com.aerospike.mapper.tools.GenericTypeMapper;
import com.aerospike.mapper.tools.IBaseAeroMapper;
import com.aerospike.mapper.tools.configuration.ClassConfig;
import com.aerospike.mapper.tools.configuration.Configuration;
import com.aerospike.mapper.tools.utils.TypeUtils;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.validation.constraints.NotNull;
import org.apache.commons.lang3.StringUtils;

public abstract class AbstractBuilder<T extends IBaseAeroMapper> {
    private final T mapper;
    private List<Class<?>> classesToPreload = null;

    protected AbstractBuilder(T mapper) {
        this.mapper = mapper;
    }

    public AbstractBuilder<T> addConverter(Object converter) {
        GenericTypeMapper typeMapper = new GenericTypeMapper(converter);
        TypeUtils.addTypeMapper(typeMapper.getMappedClass(), typeMapper);
        return this;
    }

    public AbstractBuilder<T> preLoadClasses(Class<?> ... clazzes) {
        if (this.classesToPreload == null) {
            this.classesToPreload = new ArrayList();
        }
        this.classesToPreload.addAll(Arrays.asList(clazzes));
        return this;
    }

    public String getPackageName(Class<?> clazz) {
        String cn;
        int dot;
        Class<?> c = clazz.isArray() ? clazz.getComponentType() : clazz;
        String pn = c.isPrimitive() ? "java.lang" : ((dot = (cn = c.getName()).lastIndexOf(46)) != -1 ? cn.substring(0, dot).intern() : "");
        return pn;
    }

    public AbstractBuilder<T> preLoadClassesFromPackage(Class<?> classInPackage) {
        return this.preLoadClassesFromPackage(this.getPackageName(classInPackage));
    }

    public AbstractBuilder<T> preLoadClassesFromPackage(String thePackage) {
        Set<Class<?>> clazzes = this.findAllClassesUsingClassLoader(thePackage);
        for (Class<?> thisClazz : clazzes) {
            if (thisClazz.getAnnotation(AerospikeRecord.class) == null) continue;
            this.preLoadClass(thisClazz);
        }
        return this;
    }

    private Set<Class<?>> findAllClassesUsingClassLoader(String packageName) {
        InputStream stream = ClassLoader.getSystemClassLoader().getResourceAsStream(packageName.replaceAll("[.]", "/"));
        BufferedReader reader = new BufferedReader(new InputStreamReader(stream));
        return reader.lines().filter(line -> line.endsWith(".class")).map(line -> this.getClass((String)line, packageName)).collect(Collectors.toSet());
    }

    private Class<?> getClass(String className, String packageName) {
        try {
            return Class.forName(packageName + "." + className.substring(0, className.lastIndexOf(46)));
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }

    public AbstractBuilder<T> preLoadClass(Class<?> clazz) {
        if (this.classesToPreload == null) {
            this.classesToPreload = new ArrayList();
        }
        this.classesToPreload.add(clazz);
        return this;
    }

    public AbstractBuilder<T> withConfigurationFile(File file) throws IOException {
        return this.withConfigurationFile(file, false);
    }

    public AbstractBuilder<T> withConfigurationFile(File file, boolean allowsInvalid) throws IOException {
        ObjectMapper objectMapper = new ObjectMapper((JsonFactory)new YAMLFactory());
        Configuration configuration = (Configuration)objectMapper.readValue(file, Configuration.class);
        this.loadConfiguration(configuration, allowsInvalid);
        return this;
    }

    public AbstractBuilder<T> withConfigurationFile(InputStream ios) throws IOException {
        return this.withConfigurationFile(ios, false);
    }

    public AbstractBuilder<T> withConfigurationFile(InputStream ios, boolean allowsInvalid) throws IOException {
        ObjectMapper objectMapper = new ObjectMapper((JsonFactory)new YAMLFactory());
        Configuration configuration = (Configuration)objectMapper.readValue(ios, Configuration.class);
        this.loadConfiguration(configuration, allowsInvalid);
        return this;
    }

    public AbstractBuilder<T> withConfiguration(String configurationYaml) throws JsonProcessingException {
        return this.withConfiguration(configurationYaml, false);
    }

    public AbstractBuilder<T> withConfiguration(String configurationYaml, boolean allowsInvalid) throws JsonProcessingException {
        ObjectMapper objectMapper = new ObjectMapper((JsonFactory)new YAMLFactory());
        Configuration configuration = (Configuration)objectMapper.readValue(configurationYaml, Configuration.class);
        this.loadConfiguration(configuration, allowsInvalid);
        return this;
    }

    public AbstractBuilder<T> withClassConfigurations(ClassConfig classConfig, ClassConfig ... classConfigs) {
        Configuration configuration = new Configuration();
        configuration.add(classConfig);
        for (ClassConfig thisConfig : classConfigs) {
            configuration.add(thisConfig);
        }
        ClassCache.getInstance().addConfiguration(configuration);
        return this;
    }

    private void loadConfiguration(@NotNull Configuration configuration, boolean allowsInvalid) {
        for (ClassConfig config : configuration.getClasses()) {
            try {
                String name = config.getClassName();
                if (StringUtils.isBlank((CharSequence)name)) {
                    throw new AerospikeException("Class with blank name in configuration file");
                }
                try {
                    Class.forName(config.getClassName());
                }
                catch (ClassNotFoundException e) {
                    throw new AerospikeException("Cannot find a class with name " + name);
                }
            }
            catch (RuntimeException re) {
                if (allowsInvalid) {
                    Log.warn((String)("Ignoring issue with configuration: " + re.getMessage()));
                    continue;
                }
                throw re;
            }
        }
        ClassCache.getInstance().addConfiguration(configuration);
    }

    public AeroPolicyMapper<T> withReadPolicy(Policy policy) {
        return new AeroPolicyMapper(this, ClassCache.PolicyType.READ, policy);
    }

    public AeroPolicyMapper<T> withWritePolicy(Policy policy) {
        return new AeroPolicyMapper(this, ClassCache.PolicyType.WRITE, policy);
    }

    public AeroPolicyMapper<T> withBatchPolicy(BatchPolicy policy) {
        return new AeroPolicyMapper(this, ClassCache.PolicyType.BATCH, (Policy)policy);
    }

    public AeroPolicyMapper<T> withScanPolicy(ScanPolicy policy) {
        return new AeroPolicyMapper(this, ClassCache.PolicyType.SCAN, (Policy)policy);
    }

    public AeroPolicyMapper<T> withQueryPolicy(QueryPolicy policy) {
        return new AeroPolicyMapper(this, ClassCache.PolicyType.QUERY, (Policy)policy);
    }

    public T build() {
        if (this.classesToPreload != null) {
            for (Class<?> clazz : this.classesToPreload) {
                ClassCache.getInstance().loadClass(clazz, (IBaseAeroMapper)this.mapper);
            }
        }
        return this.mapper;
    }

    public static class AeroPolicyMapper<T extends IBaseAeroMapper> {
        private final AbstractBuilder<T> builder;
        private final Policy policy;
        private final ClassCache.PolicyType policyType;

        public AeroPolicyMapper(AbstractBuilder<T> builder, ClassCache.PolicyType policyType, Policy policy) {
            this.builder = builder;
            this.policyType = policyType;
            this.policy = policy;
        }

        public AbstractBuilder<T> forClasses(Class<?> ... classes) {
            for (Class<?> thisClass : classes) {
                ClassCache.getInstance().setSpecificPolicy(this.policyType, thisClass, this.policy);
            }
            return this.builder;
        }

        public AbstractBuilder<T> forThisOrChildrenOf(Class<?> clazz) {
            ClassCache.getInstance().setChildrenPolicy(this.policyType, clazz, this.policy);
            return this.builder;
        }

        public AbstractBuilder<T> forAll() {
            ClassCache.getInstance().setDefaultPolicy(this.policyType, this.policy);
            return this.builder;
        }
    }
}

