/*
 * Decompiled with CFR 0.152.
 */
package com.aerospike.mapper.tools;

import com.aerospike.client.AerospikeException;
import com.aerospike.client.Bin;
import com.aerospike.client.IAerospikeClient;
import com.aerospike.client.Key;
import com.aerospike.client.Operation;
import com.aerospike.client.Record;
import com.aerospike.client.Value;
import com.aerospike.client.policy.BatchPolicy;
import com.aerospike.client.policy.Policy;
import com.aerospike.client.policy.QueryPolicy;
import com.aerospike.client.policy.RecordExistsAction;
import com.aerospike.client.policy.ScanPolicy;
import com.aerospike.client.policy.WritePolicy;
import com.aerospike.client.query.Filter;
import com.aerospike.client.query.RecordSet;
import com.aerospike.client.query.Statement;
import com.aerospike.mapper.tools.AbstractBuilder;
import com.aerospike.mapper.tools.ClassCache;
import com.aerospike.mapper.tools.ClassCacheEntry;
import com.aerospike.mapper.tools.IAeroMapper;
import com.aerospike.mapper.tools.LoadedObjectResolver;
import com.aerospike.mapper.tools.Processor;
import com.aerospike.mapper.tools.ThreadLocalKeySaver;
import com.aerospike.mapper.tools.converters.MappingConverter;
import com.aerospike.mapper.tools.utils.MapperUtils;
import com.aerospike.mapper.tools.virtuallist.VirtualList;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Function;
import javax.validation.constraints.NotNull;

public class AeroMapper
implements IAeroMapper {
    private final IAerospikeClient mClient;
    private final MappingConverter mappingConverter;

    private AeroMapper(@NotNull IAerospikeClient client) {
        this.mClient = client;
        this.mappingConverter = new MappingConverter(this, this.mClient);
    }

    @Override
    public <T> void save(T ... objects) throws AerospikeException {
        for (T thisObject : objects) {
            this.save(thisObject, new String[0]);
        }
    }

    @Override
    public <T> void save(@NotNull T object, String ... binNames) throws AerospikeException {
        WritePolicy writePolicy = this.generateWritePolicyFromObject(object);
        writePolicy.recordExistsAction = RecordExistsAction.REPLACE;
        this.save(writePolicy, object, binNames);
    }

    @Override
    public <T> void save(@NotNull WritePolicy writePolicy, @NotNull T object, String ... binNames) throws AerospikeException {
        String set;
        Class<?> clazz = object.getClass();
        ClassCacheEntry<?> entry = MapperUtils.getEntryAndValidateNamespace(clazz, this);
        if (writePolicy == null) {
            writePolicy = this.generateWritePolicyFromObject(object);
        }
        if ("".equals(set = entry.getSetName())) {
            set = null;
        }
        Key key = new Key(entry.getNamespace(), set, Value.get((Object)entry.getKey(object)));
        Bin[] bins = entry.getBins(object, writePolicy.recordExistsAction != RecordExistsAction.REPLACE, binNames);
        this.mClient.put(writePolicy, key, bins);
    }

    @Override
    public <T> void insert(@NotNull T object, String ... binNames) {
        WritePolicy writePolicy = this.generateWritePolicyFromObject(object);
        writePolicy.recordExistsAction = RecordExistsAction.CREATE_ONLY;
        this.save(writePolicy, object, binNames);
    }

    @Override
    public <T> void update(@NotNull T object, String ... binNames) throws AerospikeException {
        WritePolicy writePolicy = this.generateWritePolicyFromObject(object);
        writePolicy.recordExistsAction = RecordExistsAction.UPDATE;
        this.save(writePolicy, object, binNames);
    }

    private <T> WritePolicy generateWritePolicyFromObject(T object) {
        Class<?> clazz = object.getClass();
        ClassCacheEntry<?> entry = MapperUtils.getEntryAndValidateNamespace(clazz, this);
        WritePolicy writePolicy = new WritePolicy(entry.getWritePolicy());
        Integer ttl = entry.getTtl();
        Boolean sendKey = entry.getSendKey();
        if (ttl != null) {
            writePolicy.expiration = ttl;
        }
        if (sendKey != null) {
            writePolicy.sendKey = sendKey;
        }
        return writePolicy;
    }

    @Override
    public <T> T readFromDigest(@NotNull Class<T> clazz, @NotNull byte[] digest) throws AerospikeException {
        return this.readFromDigest(clazz, digest, true);
    }

    @Override
    public <T> T readFromDigest(@NotNull Class<T> clazz, @NotNull byte[] digest, boolean resolveDependencies) throws AerospikeException {
        ClassCacheEntry<T> entry = MapperUtils.getEntryAndValidateNamespace(clazz, this);
        Key key = new Key(entry.getNamespace(), digest, entry.getSetName(), null);
        return this.read(null, clazz, key, entry, resolveDependencies);
    }

    @Override
    public <T> T readFromDigest(Policy readPolicy, @NotNull Class<T> clazz, @NotNull byte[] digest) throws AerospikeException {
        return this.readFromDigest(readPolicy, clazz, digest, true);
    }

    @Override
    public <T> T readFromDigest(Policy readPolicy, @NotNull Class<T> clazz, @NotNull byte[] digest, boolean resolveDependencies) throws AerospikeException {
        ClassCacheEntry<T> entry = MapperUtils.getEntryAndValidateNamespace(clazz, this);
        Key key = new Key(entry.getNamespace(), digest, entry.getSetName(), null);
        return this.read(readPolicy, clazz, key, entry, resolveDependencies);
    }

    @Override
    public <T> T read(@NotNull Class<T> clazz, @NotNull Object userKey) throws AerospikeException {
        return this.read(clazz, userKey, true);
    }

    @Override
    public <T> T read(@NotNull Class<T> clazz, @NotNull Object userKey, boolean resolveDependencies) throws AerospikeException {
        ClassCacheEntry<T> entry = MapperUtils.getEntryAndValidateNamespace(clazz, this);
        String set = entry.getSetName();
        Key key = new Key(entry.getNamespace(), set, Value.get((Object)entry.translateKeyToAerospikeKey(userKey)));
        return this.read(null, clazz, key, entry, resolveDependencies);
    }

    @Override
    public <T> T read(Policy readPolicy, @NotNull Class<T> clazz, @NotNull Object userKey) throws AerospikeException {
        return this.read(readPolicy, clazz, userKey, true);
    }

    @Override
    public <T> T read(Policy readPolicy, @NotNull Class<T> clazz, @NotNull Object userKey, boolean resolveDependencies) throws AerospikeException {
        ClassCacheEntry<T> entry = MapperUtils.getEntryAndValidateNamespace(clazz, this);
        String set = entry.getSetName();
        Key key = new Key(entry.getNamespace(), set, Value.get((Object)entry.translateKeyToAerospikeKey(userKey)));
        return this.read(readPolicy, clazz, key, entry, resolveDependencies);
    }

    @Override
    public <T> T[] read(@NotNull Class<T> clazz, @NotNull Object[] userKeys) throws AerospikeException {
        return this.read((BatchPolicy)null, clazz, userKeys);
    }

    @Override
    public <T> T[] read(BatchPolicy batchPolicy, @NotNull Class<T> clazz, @NotNull Object[] userKeys) throws AerospikeException {
        return this.read(batchPolicy, clazz, userKeys, (Operation[])null);
    }

    @Override
    public <T> T[] read(@NotNull Class<T> clazz, @NotNull Object[] userKeys, Operation ... operations) {
        return this.read(null, clazz, userKeys, operations);
    }

    @Override
    public <T> T[] read(BatchPolicy batchPolicy, @NotNull Class<T> clazz, @NotNull Object[] userKeys, Operation ... operations) {
        ClassCacheEntry<T> entry = MapperUtils.getEntryAndValidateNamespace(clazz, this);
        String set = entry.getSetName();
        Key[] keys = new Key[userKeys.length];
        for (int i = 0; i < userKeys.length; ++i) {
            if (userKeys[i] == null) {
                throw new AerospikeException("Cannot pass null to object " + i + " in multi-read call");
            }
            keys[i] = new Key(entry.getNamespace(), set, Value.get((Object)entry.translateKeyToAerospikeKey(userKeys[i])));
        }
        return this.readBatch(batchPolicy, clazz, keys, entry, operations);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> T read(Policy readPolicy, @NotNull Class<T> clazz, @NotNull Key key, @NotNull ClassCacheEntry<T> entry, boolean resolveDependencies) {
        Record record;
        Object objectForKey;
        if ((readPolicy == null || readPolicy.filterExp == null) && (objectForKey = LoadedObjectResolver.get(key)) != null) {
            return (T)objectForKey;
        }
        if (readPolicy == null) {
            readPolicy = entry.getReadPolicy();
        }
        if ((record = this.mClient.get(readPolicy, key)) == null) {
            return null;
        }
        try {
            ThreadLocalKeySaver.save(key);
            T t = this.mappingConverter.convertToObject(clazz, key, record, entry, resolveDependencies);
            return t;
        }
        finally {
            ThreadLocalKeySaver.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> T[] readBatch(BatchPolicy batchPolicy, @NotNull Class<T> clazz, @NotNull Key[] keys, @NotNull ClassCacheEntry<T> entry, Operation ... operations) {
        if (batchPolicy == null) {
            batchPolicy = entry.getBatchPolicy();
        }
        Record[] records = operations != null && operations.length > 0 ? this.mClient.get(batchPolicy, keys, operations) : this.mClient.get(batchPolicy, keys);
        Object[] results = (Object[])Array.newInstance(clazz, records.length);
        for (int i = 0; i < records.length; ++i) {
            if (records[i] == null) {
                results[i] = null;
                continue;
            }
            try {
                ThreadLocalKeySaver.save(keys[i]);
                T result = this.mappingConverter.convertToObject(clazz, keys[i], records[i], entry, false);
                results[i] = result;
                continue;
            }
            finally {
                ThreadLocalKeySaver.clear();
            }
        }
        this.mappingConverter.resolveDependencies(entry);
        return results;
    }

    @Override
    public <T> boolean delete(@NotNull Class<T> clazz, @NotNull Object userKey) throws AerospikeException {
        return this.delete(null, clazz, userKey);
    }

    @Override
    public <T> boolean delete(WritePolicy writePolicy, @NotNull Class<T> clazz, @NotNull Object userKey) throws AerospikeException {
        ClassCacheEntry<T> entry = MapperUtils.getEntryAndValidateNamespace(clazz, this);
        Object asKey = entry.translateKeyToAerospikeKey(userKey);
        if (writePolicy == null) {
            writePolicy = entry.getWritePolicy();
            if (entry.getDurableDelete() != null) {
                writePolicy = new WritePolicy(writePolicy);
                writePolicy.durableDelete = entry.getDurableDelete();
            }
        }
        Key key = new Key(entry.getNamespace(), entry.getSetName(), Value.get((Object)asKey));
        return this.mClient.delete(writePolicy, key);
    }

    @Override
    public boolean delete(@NotNull Object object) throws AerospikeException {
        return this.delete((WritePolicy)null, object);
    }

    @Override
    public boolean delete(WritePolicy writePolicy, @NotNull Object object) throws AerospikeException {
        ClassCacheEntry<?> entry = MapperUtils.getEntryAndValidateNamespace(object.getClass(), this);
        Key key = new Key(entry.getNamespace(), entry.getSetName(), Value.get((Object)entry.getKey(object)));
        if (writePolicy == null) {
            writePolicy = entry.getWritePolicy();
            if (entry.getDurableDelete() != null) {
                writePolicy = new WritePolicy(writePolicy);
                writePolicy.durableDelete = entry.getDurableDelete();
            }
        }
        return this.mClient.delete(writePolicy, key);
    }

    @Override
    public <T> void find(@NotNull Class<T> clazz, Function<T, Boolean> function) throws AerospikeException {
        ClassCacheEntry<T> entry = MapperUtils.getEntryAndValidateNamespace(clazz, this);
        Statement statement = new Statement();
        statement.setNamespace(entry.getNamespace());
        statement.setSetName(entry.getSetName());
        try (RecordSet recordSet = null;){
            recordSet = this.mClient.query(null, statement);
            while (recordSet.next()) {
                T result = clazz.getConstructor(new Class[0]).newInstance(new Object[0]);
                entry.hydrateFromRecord(recordSet.getRecord(), result);
                if (function.apply(result).booleanValue()) continue;
                break;
            }
        }
    }

    @Override
    public <T> void scan(@NotNull Class<T> clazz, @NotNull Processor<T> processor) {
        this.scan(null, clazz, processor);
    }

    @Override
    public <T> void scan(ScanPolicy policy, @NotNull Class<T> clazz, @NotNull Processor<T> processor) {
        this.scan(policy, clazz, processor, -1);
    }

    @Override
    public <T> void scan(@NotNull Class<T> clazz, @NotNull Processor<T> processor, int recordsPerSecond) {
        this.scan(null, clazz, processor, recordsPerSecond);
    }

    @Override
    public <T> void scan(ScanPolicy policy, @NotNull Class<T> clazz, @NotNull Processor<T> processor, int recordsPerSecond) {
        block4: {
            ClassCacheEntry<T> entry = MapperUtils.getEntryAndValidateNamespace(clazz, this);
            if (policy == null) {
                policy = entry.getScanPolicy();
            }
            if (recordsPerSecond >= 0) {
                policy = new ScanPolicy(policy);
                policy.recordsPerSecond = recordsPerSecond;
            }
            String namespace = entry.getNamespace();
            String setName = entry.getSetName();
            AtomicBoolean userTerminated = new AtomicBoolean(false);
            try {
                this.mClient.scanAll(policy, namespace, setName, (key, record) -> {
                    Object object = this.getMappingConverter().convertToObject(clazz, key, record);
                    if (!processor.process(object)) {
                        userTerminated.set(true);
                        throw new AerospikeException.ScanTerminated();
                    }
                }, new String[0]);
            }
            catch (AerospikeException.ScanTerminated st) {
                if (userTerminated.get()) break block4;
                throw st;
            }
        }
    }

    @Override
    public <T> List<T> scan(@NotNull Class<T> clazz) {
        return this.scan(null, clazz);
    }

    @Override
    public <T> List<T> scan(ScanPolicy policy, @NotNull Class<T> clazz) {
        ArrayList result = new ArrayList();
        Processor<Object> resultProcessor = record -> {
            List list = result;
            synchronized (list) {
                result.add(record);
            }
            return true;
        };
        this.scan(policy, clazz, resultProcessor);
        return result;
    }

    @Override
    public <T> void query(@NotNull Class<T> clazz, @NotNull Processor<T> processor, Filter filter) {
        this.query(null, clazz, processor, filter);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> void query(QueryPolicy policy, @NotNull Class<T> clazz, @NotNull Processor<T> processor, Filter filter) {
        ClassCacheEntry<T> entry = MapperUtils.getEntryAndValidateNamespace(clazz, this);
        if (policy == null) {
            policy = entry.getQueryPolicy();
        }
        Statement statement = new Statement();
        statement.setFilter(filter);
        statement.setNamespace(entry.getNamespace());
        statement.setSetName(entry.getSetName());
        try (RecordSet recordSet = this.mClient.query(policy, statement);){
            while (recordSet.next()) {
                T object = this.getMappingConverter().convertToObject(clazz, recordSet.getKey(), recordSet.getRecord());
                if (processor.process(object)) continue;
                break;
            }
        }
    }

    @Override
    public <T> List<T> query(Class<T> clazz, Filter filter) {
        return this.query(null, clazz, filter);
    }

    @Override
    public <T> List<T> query(QueryPolicy policy, Class<T> clazz, Filter filter) {
        ArrayList result = new ArrayList();
        Processor<Object> resultProcessor = record -> {
            result.add(record);
            return true;
        };
        this.query(policy, clazz, resultProcessor, filter);
        return result;
    }

    @Override
    public <T> VirtualList<T> asBackedList(@NotNull Object object, @NotNull String binName, Class<T> elementClazz) {
        return new VirtualList<T>(this, object, binName, elementClazz);
    }

    @Override
    public <T> VirtualList<T> asBackedList(@NotNull Class<?> owningClazz, @NotNull Object key, @NotNull String binName, Class<T> elementClazz) {
        return new VirtualList<T>(this, owningClazz, key, binName, elementClazz);
    }

    @Override
    public IAerospikeClient getClient() {
        return this.mClient;
    }

    @Override
    public MappingConverter getMappingConverter() {
        return this.mappingConverter;
    }

    @Override
    public IAeroMapper asMapper() {
        return this;
    }

    @Override
    public Policy getReadPolicy(Class<?> clazz) {
        return this.getPolicyByClassAndType(clazz, ClassCache.PolicyType.READ);
    }

    @Override
    public WritePolicy getWritePolicy(Class<?> clazz) {
        return (WritePolicy)this.getPolicyByClassAndType(clazz, ClassCache.PolicyType.WRITE);
    }

    @Override
    public BatchPolicy getBatchPolicy(Class<?> clazz) {
        return (BatchPolicy)this.getPolicyByClassAndType(clazz, ClassCache.PolicyType.BATCH);
    }

    @Override
    public ScanPolicy getScanPolicy(Class<?> clazz) {
        return (ScanPolicy)this.getPolicyByClassAndType(clazz, ClassCache.PolicyType.SCAN);
    }

    @Override
    public QueryPolicy getQueryPolicy(Class<?> clazz) {
        return (QueryPolicy)this.getPolicyByClassAndType(clazz, ClassCache.PolicyType.QUERY);
    }

    private Policy getPolicyByClassAndType(Class<?> clazz, ClassCache.PolicyType policyType) {
        ClassCacheEntry<?> entry = ClassCache.getInstance().loadClass(clazz, this);
        switch (policyType) {
            case READ: {
                return entry == null ? this.mClient.getReadPolicyDefault() : entry.getReadPolicy();
            }
            case WRITE: {
                return entry == null ? this.mClient.getWritePolicyDefault() : entry.getWritePolicy();
            }
            case BATCH: {
                return entry == null ? this.mClient.getBatchPolicyDefault() : entry.getBatchPolicy();
            }
            case SCAN: {
                return entry == null ? this.mClient.getScanPolicyDefault() : entry.getScanPolicy();
            }
            case QUERY: {
                return entry == null ? this.mClient.getQueryPolicyDefault() : entry.getQueryPolicy();
            }
        }
        throw new UnsupportedOperationException("Provided unsupported policy type: " + (Object)((Object)policyType));
    }

    @Override
    public String getNamespace(Class<?> clazz) {
        ClassCacheEntry<?> entry = ClassCache.getInstance().loadClass(clazz, this);
        return entry == null ? null : entry.getNamespace();
    }

    @Override
    public String getSet(Class<?> clazz) {
        ClassCacheEntry<?> entry = ClassCache.getInstance().loadClass(clazz, this);
        return entry == null ? null : entry.getSetName();
    }

    @Override
    public Object getKey(Object obj) {
        ClassCacheEntry<?> entry = ClassCache.getInstance().loadClass(obj.getClass(), this);
        return entry == null ? null : entry.getKey(obj);
    }

    @Override
    public Key getRecordKey(Object obj) {
        ClassCacheEntry<?> entry = ClassCache.getInstance().loadClass(obj.getClass(), this);
        return entry == null ? null : new Key(entry.getNamespace(), entry.getSetName(), Value.get((Object)entry.getKey(obj)));
    }

    public static class Builder
    extends AbstractBuilder<AeroMapper> {
        public Builder(IAerospikeClient client) {
            super(new AeroMapper(client));
            ClassCache.getInstance().setDefaultPolicies(client);
        }
    }
}

