/*
 * Decompiled with CFR 0.152.
 */
package com.aerospike.mapper.tools;

import com.aerospike.client.AerospikeException;
import com.aerospike.client.Bin;
import com.aerospike.client.Key;
import com.aerospike.client.Operation;
import com.aerospike.client.Value;
import com.aerospike.client.policy.BatchPolicy;
import com.aerospike.client.policy.Policy;
import com.aerospike.client.policy.QueryPolicy;
import com.aerospike.client.policy.RecordExistsAction;
import com.aerospike.client.policy.ScanPolicy;
import com.aerospike.client.policy.WritePolicy;
import com.aerospike.client.query.Filter;
import com.aerospike.client.query.Statement;
import com.aerospike.client.reactor.IAerospikeReactorClient;
import com.aerospike.mapper.tools.AbstractBuilder;
import com.aerospike.mapper.tools.AeroMapper;
import com.aerospike.mapper.tools.ClassCache;
import com.aerospike.mapper.tools.ClassCacheEntry;
import com.aerospike.mapper.tools.IAeroMapper;
import com.aerospike.mapper.tools.IReactiveAeroMapper;
import com.aerospike.mapper.tools.LoadedObjectResolver;
import com.aerospike.mapper.tools.ThreadLocalKeySaver;
import com.aerospike.mapper.tools.converters.MappingConverter;
import com.aerospike.mapper.tools.utils.MapperUtils;
import com.aerospike.mapper.tools.virtuallist.ReactiveVirtualList;
import java.util.Arrays;
import java.util.Objects;
import java.util.function.Function;
import javax.validation.constraints.NotNull;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class ReactiveAeroMapper
implements IReactiveAeroMapper {
    private final IAerospikeReactorClient reactorClient;
    private final IAeroMapper aeroMapper;
    private final MappingConverter mappingConverter;

    private ReactiveAeroMapper(@NotNull IAerospikeReactorClient reactorClient) {
        this.reactorClient = reactorClient;
        this.aeroMapper = (IAeroMapper)new AeroMapper.Builder(reactorClient.getAerospikeClient()).build();
        this.mappingConverter = new MappingConverter(this, reactorClient.getAerospikeClient());
    }

    @Override
    public <T> Flux<T> save(T ... objects) {
        return Flux.fromStream(Arrays.stream(objects)).flatMap(x$0 -> this.save(x$0, new String[0]));
    }

    @Override
    public <T> Mono<T> save(@NotNull T object, String ... binNames) {
        WritePolicy writePolicy = this.generateWritePolicyFromObject(object);
        writePolicy.recordExistsAction = RecordExistsAction.REPLACE;
        return this.save(writePolicy, object, binNames);
    }

    @Override
    public <T> Mono<T> save(@NotNull WritePolicy writePolicy, @NotNull T object, String ... binNames) {
        String set;
        Class<?> clazz = object.getClass();
        ClassCacheEntry<?> entry = MapperUtils.getEntryAndValidateNamespace(clazz, this);
        if (writePolicy == null) {
            writePolicy = this.generateWritePolicyFromObject(object);
        }
        if ("".equals(set = entry.getSetName())) {
            set = null;
        }
        Key key = new Key(entry.getNamespace(), set, Value.get((Object)entry.getKey(object)));
        Bin[] bins = entry.getBins(object, writePolicy.recordExistsAction != RecordExistsAction.REPLACE, binNames);
        return this.reactorClient.put(writePolicy, key, bins).map(docKey -> object);
    }

    @Override
    public <T> Mono<T> insert(@NotNull T object, String ... binNames) {
        WritePolicy writePolicy = this.generateWritePolicyFromObject(object);
        writePolicy.recordExistsAction = RecordExistsAction.CREATE_ONLY;
        return this.save(writePolicy, object, binNames);
    }

    @Override
    public <T> Mono<T> update(@NotNull T object, String ... binNames) {
        WritePolicy writePolicy = this.generateWritePolicyFromObject(object);
        writePolicy.recordExistsAction = RecordExistsAction.UPDATE;
        return this.save(writePolicy, object, binNames);
    }

    private <T> WritePolicy generateWritePolicyFromObject(T object) {
        Class<?> clazz = object.getClass();
        ClassCacheEntry<?> entry = MapperUtils.getEntryAndValidateNamespace(clazz, this);
        WritePolicy writePolicy = new WritePolicy(entry.getWritePolicy());
        Integer ttl = entry.getTtl();
        Boolean sendKey = entry.getSendKey();
        if (ttl != null) {
            writePolicy.expiration = ttl;
        }
        if (sendKey != null) {
            writePolicy.sendKey = sendKey;
        }
        return writePolicy;
    }

    @Override
    public <T> Mono<T> readFromDigest(@NotNull Class<T> clazz, @NotNull byte[] digest) {
        return this.readFromDigest(clazz, digest, true);
    }

    @Override
    public <T> Mono<T> readFromDigest(@NotNull Class<T> clazz, @NotNull byte[] digest, boolean resolveDependencies) {
        ClassCacheEntry<T> entry = MapperUtils.getEntryAndValidateNamespace(clazz, this);
        Key key = new Key(entry.getNamespace(), digest, entry.getSetName(), null);
        return this.read(null, clazz, key, entry, resolveDependencies);
    }

    @Override
    public <T> Mono<T> readFromDigest(Policy readPolicy, @NotNull Class<T> clazz, @NotNull byte[] digest) {
        return this.readFromDigest(readPolicy, clazz, digest, true);
    }

    @Override
    public <T> Mono<T> readFromDigest(Policy readPolicy, @NotNull Class<T> clazz, @NotNull byte[] digest, boolean resolveDependencies) {
        ClassCacheEntry<T> entry = MapperUtils.getEntryAndValidateNamespace(clazz, this);
        Key key = new Key(entry.getNamespace(), digest, entry.getSetName(), null);
        return this.read(readPolicy, clazz, key, entry, resolveDependencies);
    }

    @Override
    public <T> Mono<T> read(@NotNull Class<T> clazz, @NotNull Object userKey) {
        return this.read(clazz, userKey, true);
    }

    @Override
    public <T> Mono<T> read(@NotNull Class<T> clazz, @NotNull Object userKey, boolean resolveDependencies) {
        ClassCacheEntry<T> entry = MapperUtils.getEntryAndValidateNamespace(clazz, this);
        String set = entry.getSetName();
        Key key = new Key(entry.getNamespace(), set, Value.get((Object)entry.translateKeyToAerospikeKey(userKey)));
        return this.read(null, clazz, key, entry, resolveDependencies);
    }

    @Override
    public <T> Mono<T> read(Policy readPolicy, @NotNull Class<T> clazz, @NotNull Object userKey) {
        return this.read(readPolicy, clazz, userKey, true);
    }

    @Override
    public <T> Mono<T> read(Policy readPolicy, @NotNull Class<T> clazz, @NotNull Object userKey, boolean resolveDependencies) {
        ClassCacheEntry<T> entry = MapperUtils.getEntryAndValidateNamespace(clazz, this);
        String set = entry.getSetName();
        Key key = new Key(entry.getNamespace(), set, Value.get((Object)entry.translateKeyToAerospikeKey(userKey)));
        return this.read(readPolicy, clazz, key, entry, resolveDependencies);
    }

    @Override
    public <T> Flux<T> read(@NotNull Class<T> clazz, @NotNull Object[] userKeys) {
        return this.read((BatchPolicy)null, clazz, userKeys);
    }

    @Override
    public <T> Flux<T> read(BatchPolicy batchPolicy, @NotNull Class<T> clazz, @NotNull Object[] userKeys) {
        return this.read(null, clazz, userKeys, (Operation[])null);
    }

    @Override
    public <T> Flux<T> read(@NotNull Class<T> clazz, @NotNull Object[] userKeys, Operation ... operations) {
        return this.read(null, clazz, userKeys, operations);
    }

    @Override
    public <T> Flux<T> read(BatchPolicy batchPolicy, @NotNull Class<T> clazz, @NotNull Object[] userKeys, Operation ... operations) {
        ClassCacheEntry<T> entry = MapperUtils.getEntryAndValidateNamespace(clazz, this);
        String set = entry.getSetName();
        Key[] keys = new Key[userKeys.length];
        for (int i = 0; i < userKeys.length; ++i) {
            if (userKeys[i] == null) {
                throw new AerospikeException("Cannot pass null to object " + i + " in multi-read call");
            }
            keys[i] = new Key(entry.getNamespace(), set, Value.get((Object)entry.translateKeyToAerospikeKey(userKeys[i])));
        }
        return this.readBatch(batchPolicy, clazz, keys, entry, operations);
    }

    private <T> Mono<T> read(Policy readPolicy, @NotNull Class<T> clazz, @NotNull Key key, @NotNull ClassCacheEntry<T> entry, boolean resolveDependencies) {
        Object objectForKey;
        if ((readPolicy == null || readPolicy.filterExp == null) && (objectForKey = LoadedObjectResolver.get(key)) != null) {
            return Mono.just((Object)objectForKey);
        }
        if (readPolicy == null) {
            readPolicy = entry.getReadPolicy();
        }
        return this.reactorClient.get(readPolicy, key).filter(keyRecord -> Objects.nonNull(keyRecord.record)).map(keyRecord -> {
            try {
                ThreadLocalKeySaver.save(key);
                Object t = this.mappingConverter.convertToObject(clazz, key, keyRecord.record, entry, resolveDependencies);
                return t;
            }
            finally {
                ThreadLocalKeySaver.clear();
            }
        });
    }

    private <T> Flux<T> readBatch(BatchPolicy batchPolicy, @NotNull Class<T> clazz, @NotNull Key[] keys, @NotNull ClassCacheEntry<T> entry, Operation ... operations) {
        if (batchPolicy == null) {
            batchPolicy = entry.getBatchPolicy();
        }
        Flux keyRecordFlux = operations != null && operations.length > 0 ? this.reactorClient.getFlux(batchPolicy, keys, operations) : this.reactorClient.getFlux(batchPolicy, keys);
        return keyRecordFlux.filter(keyRecord -> Objects.nonNull(keyRecord.record)).map(keyRecord -> {
            try {
                ThreadLocalKeySaver.save(keyRecord.key);
                Object t = this.mappingConverter.convertToObject(clazz, keyRecord.key, keyRecord.record, entry, true);
                return t;
            }
            finally {
                ThreadLocalKeySaver.clear();
            }
        });
    }

    @Override
    public <T> Mono<Boolean> delete(@NotNull Class<T> clazz, @NotNull Object userKey) {
        return this.delete(null, clazz, userKey);
    }

    @Override
    public <T> Mono<Boolean> delete(WritePolicy writePolicy, @NotNull Class<T> clazz, @NotNull Object userKey) {
        ClassCacheEntry<T> entry = MapperUtils.getEntryAndValidateNamespace(clazz, this);
        Object asKey = entry.translateKeyToAerospikeKey(userKey);
        if (writePolicy == null) {
            writePolicy = entry.getWritePolicy();
            if (entry.getDurableDelete() != null) {
                writePolicy = new WritePolicy(writePolicy);
                writePolicy.durableDelete = entry.getDurableDelete();
            }
        }
        Key key = new Key(entry.getNamespace(), entry.getSetName(), Value.get((Object)asKey));
        return this.reactorClient.delete(writePolicy, key).map(k -> true);
    }

    @Override
    public Mono<Boolean> delete(@NotNull Object object) {
        return this.delete((WritePolicy)null, object);
    }

    @Override
    public Mono<Boolean> delete(WritePolicy writePolicy, @NotNull Object object) {
        ClassCacheEntry<?> entry = MapperUtils.getEntryAndValidateNamespace(object.getClass(), this);
        Key key = new Key(entry.getNamespace(), entry.getSetName(), Value.get((Object)entry.getKey(object)));
        if (writePolicy == null) {
            writePolicy = entry.getWritePolicy();
            if (entry.getDurableDelete() != null) {
                writePolicy = new WritePolicy(writePolicy);
                writePolicy.durableDelete = entry.getDurableDelete();
            }
        }
        return this.reactorClient.delete(writePolicy, key).map(k -> true);
    }

    @Override
    public <T> Mono<Void> find(@NotNull Class<T> clazz, Function<T, Boolean> function) {
        return Mono.fromCallable(() -> {
            this.asMapper().find(clazz, function);
            return null;
        });
    }

    @Override
    public <T> Flux<T> scan(@NotNull Class<T> clazz) {
        return this.scan(null, clazz);
    }

    @Override
    public <T> Flux<T> scan(ScanPolicy policy, @NotNull Class<T> clazz) {
        return this.scan(policy, clazz, -1);
    }

    @Override
    public <T> Flux<T> scan(@NotNull Class<T> clazz, int recordsPerSecond) {
        return this.scan(null, clazz, recordsPerSecond);
    }

    @Override
    public <T> Flux<T> scan(ScanPolicy policy, @NotNull Class<T> clazz, int recordsPerSecond) {
        ClassCacheEntry<T> entry = MapperUtils.getEntryAndValidateNamespace(clazz, this);
        if (policy == null) {
            policy = entry.getScanPolicy();
        }
        if (recordsPerSecond >= 0) {
            policy = new ScanPolicy(policy);
            policy.recordsPerSecond = recordsPerSecond;
        }
        String namespace = entry.getNamespace();
        String setName = entry.getSetName();
        return this.reactorClient.scanAll(policy, namespace, setName, new String[0]).map(keyRecord -> this.getMappingConverter().convertToObject(clazz, keyRecord.key, keyRecord.record));
    }

    @Override
    public <T> Flux<T> query(@NotNull Class<T> clazz, Filter filter) {
        return this.query(null, clazz, filter);
    }

    @Override
    public <T> Flux<T> query(QueryPolicy policy, @NotNull Class<T> clazz, Filter filter) {
        ClassCacheEntry<T> entry = MapperUtils.getEntryAndValidateNamespace(clazz, this);
        if (policy == null) {
            policy = entry.getQueryPolicy();
        }
        Statement statement = new Statement();
        statement.setFilter(filter);
        statement.setNamespace(entry.getNamespace());
        statement.setSetName(entry.getSetName());
        return this.reactorClient.query(policy, statement).map(keyRecord -> this.getMappingConverter().convertToObject(clazz, keyRecord.key, keyRecord.record));
    }

    @Override
    public <T> ReactiveVirtualList<T> asBackedList(@NotNull Object object, @NotNull String binName, Class<T> elementClazz) {
        return new ReactiveVirtualList<T>(this, object, binName, elementClazz);
    }

    @Override
    public <T> ReactiveVirtualList<T> asBackedList(@NotNull Class<?> owningClazz, @NotNull Object key, @NotNull String binName, Class<T> elementClazz) {
        return new ReactiveVirtualList<T>(this, owningClazz, key, binName, elementClazz);
    }

    @Override
    public IAerospikeReactorClient getReactorClient() {
        return this.reactorClient;
    }

    @Override
    public MappingConverter getMappingConverter() {
        return this.mappingConverter;
    }

    @Override
    public IAeroMapper asMapper() {
        return this.aeroMapper;
    }

    @Override
    public Policy getReadPolicy(Class<?> clazz) {
        return this.getPolicyByClassAndType(clazz, ClassCache.PolicyType.READ);
    }

    @Override
    public WritePolicy getWritePolicy(Class<?> clazz) {
        return (WritePolicy)this.getPolicyByClassAndType(clazz, ClassCache.PolicyType.WRITE);
    }

    @Override
    public BatchPolicy getBatchPolicy(Class<?> clazz) {
        return (BatchPolicy)this.getPolicyByClassAndType(clazz, ClassCache.PolicyType.BATCH);
    }

    @Override
    public ScanPolicy getScanPolicy(Class<?> clazz) {
        return (ScanPolicy)this.getPolicyByClassAndType(clazz, ClassCache.PolicyType.SCAN);
    }

    @Override
    public QueryPolicy getQueryPolicy(Class<?> clazz) {
        return (QueryPolicy)this.getPolicyByClassAndType(clazz, ClassCache.PolicyType.QUERY);
    }

    private Policy getPolicyByClassAndType(Class<?> clazz, ClassCache.PolicyType policyType) {
        ClassCacheEntry<?> entry = ClassCache.getInstance().loadClass(clazz, this);
        switch (policyType) {
            case READ: {
                return entry == null ? this.reactorClient.getReadPolicyDefault() : entry.getReadPolicy();
            }
            case WRITE: {
                return entry == null ? this.reactorClient.getWritePolicyDefault() : entry.getWritePolicy();
            }
            case BATCH: {
                return entry == null ? this.reactorClient.getBatchPolicyDefault() : entry.getBatchPolicy();
            }
            case SCAN: {
                return entry == null ? this.reactorClient.getScanPolicyDefault() : entry.getScanPolicy();
            }
            case QUERY: {
                return entry == null ? this.reactorClient.getQueryPolicyDefault() : entry.getQueryPolicy();
            }
        }
        throw new UnsupportedOperationException("Provided unsupported policy.");
    }

    @Override
    public <T> Mono<String> getNamespace(Class<T> clazz) {
        ClassCacheEntry<T> entry = MapperUtils.getEntryAndValidateNamespace(clazz, this);
        return entry == null ? null : Mono.just((Object)entry.getNamespace());
    }

    @Override
    public <T> Mono<String> getSet(Class<T> clazz) {
        ClassCacheEntry<T> entry = ClassCache.getInstance().loadClass(clazz, this);
        return entry == null ? null : Mono.just((Object)entry.getSetName());
    }

    @Override
    public Mono<Object> getKey(Object obj) {
        ClassCacheEntry<?> entry = ClassCache.getInstance().loadClass(obj.getClass(), this);
        return entry == null ? null : Mono.just((Object)entry.getKey(obj));
    }

    @Override
    public Mono<Key> getRecordKey(Object obj) {
        ClassCacheEntry<?> entry = ClassCache.getInstance().loadClass(obj.getClass(), this);
        return entry == null ? null : Mono.just((Object)new Key(entry.getNamespace(), entry.getSetName(), Value.get((Object)entry.getKey(obj))));
    }

    public static class Builder
    extends AbstractBuilder<ReactiveAeroMapper> {
        public Builder(IAerospikeReactorClient reactorClient) {
            super(new ReactiveAeroMapper(reactorClient));
            ClassCache.getInstance().setReactiveDefaultPolicies(reactorClient);
        }
    }
}

