/*
 * Decompiled with CFR 0.152.
 */
package com.aerospike.mapper.tools.mappers;

import com.aerospike.client.AerospikeException;
import com.aerospike.mapper.annotations.AerospikeEmbed;
import com.aerospike.mapper.tools.ClassCache;
import com.aerospike.mapper.tools.ClassCacheEntry;
import com.aerospike.mapper.tools.DeferredObjectLoader;
import com.aerospike.mapper.tools.IBaseAeroMapper;
import com.aerospike.mapper.tools.TypeMapper;
import com.aerospike.mapper.tools.mappers.ObjectMapper;
import com.aerospike.mapper.tools.utils.TypeUtils;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

public class ListMapper
extends TypeMapper {
    private final Class<?> referencedClass;
    private final Class<?> instanceClass;
    private final IBaseAeroMapper mapper;
    private final boolean supportedWithoutTranslation;
    private final TypeMapper instanceClassMapper;
    private final AerospikeEmbed.EmbedType embedType;
    private final ClassCacheEntry<?> subTypeEntry;
    private final boolean saveKey;
    private final boolean allowBatchLoad;

    public ListMapper(Class<?> clazz, Class<?> instanceClass, TypeMapper instanceClassMapper, IBaseAeroMapper mapper, AerospikeEmbed.EmbedType embedType, boolean saveKey, boolean allowBatchLoad) {
        this.referencedClass = clazz;
        this.mapper = mapper;
        this.instanceClass = instanceClass;
        this.supportedWithoutTranslation = TypeUtils.isAerospikeNativeType(instanceClass);
        this.instanceClassMapper = instanceClassMapper;
        this.saveKey = saveKey;
        this.allowBatchLoad = allowBatchLoad;
        this.embedType = embedType == AerospikeEmbed.EmbedType.DEFAULT ? AerospikeEmbed.EmbedType.LIST : embedType;
        if (!(this.embedType != AerospikeEmbed.EmbedType.MAP || instanceClassMapper != null && ObjectMapper.class.isAssignableFrom(instanceClassMapper.getClass()))) {
            this.subTypeEntry = null;
            throw new AerospikeException("Annotations embedding lists of objects can only map those objects to maps instead of lists if the object is an AerospikeRecord on instance of class " + clazz.getSimpleName());
        }
        this.subTypeEntry = instanceClass != null ? ClassCache.getInstance().loadClass(instanceClass, mapper) : null;
    }

    public Object toAerospikeInstanceFormat(Object obj) {
        if (this.embedType == null || this.embedType == AerospikeEmbed.EmbedType.LIST) {
            if (this.instanceClass == null) {
                if (obj == null) {
                    return null;
                }
                TypeMapper thisMapper = TypeUtils.getMapper(obj.getClass(), null, this.mapper);
                return thisMapper == null ? obj : thisMapper.toAerospikeFormat(obj, true, false);
            }
            if (obj == null || obj.getClass().equals(this.instanceClass)) {
                return this.instanceClassMapper.toAerospikeFormat(obj);
            }
            return this.instanceClassMapper.toAerospikeFormat(obj, false, true);
        }
        Object key = this.subTypeEntry.getKey(obj);
        Object item = obj == null || obj.getClass().equals(this.instanceClass) ? this.instanceClassMapper.toAerospikeFormat(obj) : this.instanceClassMapper.toAerospikeFormat(obj, false, true);
        return new AbstractMap.SimpleEntry<Object, Object>(key, item);
    }

    @Override
    public Object toAerospikeFormat(Object value) {
        if (value == null) {
            return null;
        }
        List list = (List)value;
        if (this.embedType == null || this.embedType == AerospikeEmbed.EmbedType.LIST) {
            ArrayList<Object> results = new ArrayList<Object>();
            for (Object obj : list) {
                results.add(this.toAerospikeInstanceFormat(obj));
            }
            return results;
        }
        TreeMap<Object, Object> results = new TreeMap<Object, Object>();
        for (Object obj : list) {
            Object key = this.subTypeEntry.getKey(obj);
            Object item = obj == null || obj.getClass().equals(this.instanceClass) ? this.instanceClassMapper.toAerospikeFormat(obj) : this.instanceClassMapper.toAerospikeFormat(obj, false, true);
            results.put(key, item);
        }
        return results;
    }

    private Class<?> getClassToUse(Object obj) {
        if (List.class.isAssignableFrom(obj.getClass())) {
            String lastElement;
            List list = (List)obj;
            int lastElementIndex = list.size() - 1;
            if (!list.isEmpty() && list.get(lastElementIndex) instanceof String && (lastElement = (String)list.get(lastElementIndex)).startsWith("@T:")) {
                String className = lastElement.substring("@T:".length());
                ClassCacheEntry<?> thisClass = ClassCache.getInstance().getCacheEntryFromStoredName(className);
                if (thisClass != null) {
                    return thisClass.getUnderlyingClass();
                }
            }
        }
        return obj.getClass();
    }

    public Object fromAerospikeInstanceFormat(Object obj) {
        if (this.embedType == null || this.embedType == AerospikeEmbed.EmbedType.LIST) {
            if (this.instanceClass == null) {
                if (obj == null) {
                    return null;
                }
                TypeMapper thisMapper = TypeUtils.getMapper(this.getClassToUse(obj), TypeUtils.AnnotatedType.getDefaultAnnotateType(), this.mapper);
                return thisMapper == null ? obj : thisMapper.fromAerospikeFormat(obj);
            }
            return this.instanceClassMapper.fromAerospikeFormat(obj);
        }
        Map.Entry entry = (Map.Entry)obj;
        Object result = this.instanceClassMapper.fromAerospikeFormat(entry.getValue());
        this.subTypeEntry.setKey(result, entry.getKey());
        return result;
    }

    @Override
    public Object fromAerospikeFormat(Object value) {
        if (value == null) {
            return null;
        }
        ArrayList<Object> results = new ArrayList<Object>();
        if (this.embedType == null || this.embedType == AerospikeEmbed.EmbedType.LIST) {
            List list = (List)value;
            if (list.size() == 0 || this.supportedWithoutTranslation) {
                return value;
            }
            int index = 0;
            if (this.instanceClass == null) {
                for (Object obj : list) {
                    if (obj == null) {
                        results.add(null);
                    } else {
                        Object result;
                        TypeMapper thisMapper = TypeUtils.getMapper(this.getClassToUse(obj), TypeUtils.AnnotatedType.getDefaultAnnotateType(), this.mapper);
                        Object object2 = result = thisMapper == null ? obj : thisMapper.fromAerospikeFormat(obj);
                        if (result instanceof DeferredObjectLoader.DeferredObject) {
                            int thisIndex = index;
                            DeferredObjectLoader.DeferredSetter setter = object -> results.set(thisIndex, object);
                            DeferredObjectLoader.DeferredObjectSetter objectSetter = new DeferredObjectLoader.DeferredObjectSetter(setter, (DeferredObjectLoader.DeferredObject)result);
                            DeferredObjectLoader.add(objectSetter);
                            results.add(null);
                        } else {
                            results.add(result);
                        }
                    }
                    ++index;
                }
            } else {
                for (Object obj : list) {
                    if (!this.allowBatchLoad) {
                        results.add(this.instanceClassMapper.fromAerospikeFormat(obj));
                    } else {
                        Object result = this.instanceClassMapper.fromAerospikeFormat(obj);
                        if (result instanceof DeferredObjectLoader.DeferredObject) {
                            int thisIndex = index;
                            DeferredObjectLoader.DeferredSetter setter = object -> results.set(thisIndex, object);
                            DeferredObjectLoader.DeferredObjectSetter objectSetter = new DeferredObjectLoader.DeferredObjectSetter(setter, (DeferredObjectLoader.DeferredObject)result);
                            DeferredObjectLoader.add(objectSetter);
                            results.add(null);
                        } else {
                            results.add(result);
                        }
                    }
                    ++index;
                }
            }
        } else {
            Map map = (Map)value;
            for (Object key : map.keySet()) {
                Object item = map.get(key);
                Object result = this.instanceClassMapper.fromAerospikeFormat(item);
                this.subTypeEntry.setKey(result, key);
                results.add(result);
            }
        }
        return results;
    }
}

