/*
 * Decompiled with CFR 0.152.
 */
package com.aerospike.mapper.tools;

import com.aerospike.client.Key;
import com.aerospike.mapper.tools.LoadedObjectResolver;
import java.util.ArrayDeque;
import java.util.Deque;

public class ThreadLocalKeySaver {
    private static final ThreadLocal<Deque<Key>> threadLocalKeys = ThreadLocal.withInitial(ArrayDeque::new);

    private ThreadLocalKeySaver() {
    }

    public static void save(Key key) {
        threadLocalKeys.get().addLast(key);
        LoadedObjectResolver.begin();
    }

    public static void clear() {
        LoadedObjectResolver.end();
        threadLocalKeys.get().removeLast();
        if (threadLocalKeys.get().isEmpty()) {
            threadLocalKeys.remove();
        }
    }

    public static Key get() {
        Deque<Key> keys = threadLocalKeys.get();
        if (keys.isEmpty()) {
            return null;
        }
        return keys.getLast();
    }
}

