/*
 * Decompiled with CFR 0.152.
 */
package com.aerospike.mapper.tools.configuration;

import com.aerospike.client.AerospikeException;
import com.aerospike.mapper.annotations.AerospikeEmbed;
import com.aerospike.mapper.annotations.AerospikeReference;
import com.aerospike.mapper.tools.ConfigurationUtils;
import com.aerospike.mapper.tools.configuration.BinConfig;
import com.aerospike.mapper.tools.configuration.EmbedConfig;
import com.aerospike.mapper.tools.configuration.KeyConfig;
import com.aerospike.mapper.tools.configuration.ReferenceConfig;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.List;
import javax.validation.constraints.NotNull;

public class ClassConfig {
    @JsonProperty(value="class")
    private String className;
    private String namespace;
    private String set;
    private Integer ttl;
    private Integer version;
    private Boolean sendKey;
    private Boolean mapAll;
    private Boolean durableDelete;
    private KeyConfig key;
    private String shortName;
    private String factoryClass;
    private String factoryMethod;
    private final List<BinConfig> bins = new ArrayList<BinConfig>();

    public String getClassName() {
        return this.className;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public String getSet() {
        return this.set;
    }

    public Integer getTtl() {
        return this.ttl;
    }

    public Integer getVersion() {
        return this.version;
    }

    public Boolean getSendKey() {
        return this.sendKey;
    }

    public Boolean getMapAll() {
        return this.mapAll;
    }

    public Boolean getDurableDelete() {
        return this.durableDelete;
    }

    public String getShortName() {
        return this.shortName;
    }

    public KeyConfig getKey() {
        return this.key;
    }

    public List<BinConfig> getBins() {
        return this.bins;
    }

    public String getFactoryClass() {
        return this.factoryClass;
    }

    public void setFactoryClass(String factoryClass) {
        this.factoryClass = factoryClass;
    }

    public String getFactoryMethod() {
        return this.factoryMethod;
    }

    public void setFactoryMethod(String factoryMethod) {
        this.factoryMethod = factoryMethod;
    }

    public BinConfig getBinByName(@NotNull String name) {
        for (BinConfig thisBin : this.bins) {
            if (!name.equals(thisBin.getName())) continue;
            return thisBin;
        }
        return null;
    }

    public BinConfig getBinByGetterName(@NotNull String getterName) {
        for (BinConfig thisBin : this.bins) {
            if (!getterName.equals(thisBin.getGetter())) continue;
            return thisBin;
        }
        return null;
    }

    public BinConfig getBinByFieldName(@NotNull String fieldName) {
        for (BinConfig thisBin : this.bins) {
            if (!fieldName.equals(thisBin.getField())) continue;
            return thisBin;
        }
        return null;
    }

    public void validate() {
        for (BinConfig thisBin : this.bins) {
            thisBin.validate(this.className);
        }
    }

    private void setClassName(String className) {
        this.className = className;
    }

    private void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    private void setSet(String set) {
        this.set = set;
    }

    private void setTtl(Integer ttl) {
        this.ttl = ttl;
    }

    private void setVersion(Integer version) {
        this.version = version;
    }

    private void setSendKey(Boolean sendKey) {
        this.sendKey = sendKey;
    }

    private void setMapAll(Boolean mapAll) {
        this.mapAll = mapAll;
    }

    private void setDurableDelete(Boolean durableDelete) {
        this.durableDelete = durableDelete;
    }

    private void setKey(KeyConfig key) {
        this.key = key;
    }

    private void setShortName(String shortName) {
        this.shortName = shortName;
    }

    public static class AeroBinConfig {
        private final Builder builder;
        private final BinConfig binConfig;

        public AeroBinConfig(Builder builder, String fieldName) {
            this.builder = builder;
            this.binConfig = new BinConfig();
            this.binConfig.setField(fieldName);
        }

        public Builder mappingToBin(String name) {
            this.binConfig.setName(name);
            return this.end();
        }

        public Builder beingReferencedBy(AerospikeReference.ReferenceType type) {
            this.binConfig.setReference(new ReferenceConfig(type, false, true));
            return this.end();
        }

        public Builder beingLazilyReferencedBy(AerospikeReference.ReferenceType type) {
            this.binConfig.setReference(new ReferenceConfig(type, true, true));
            return this.end();
        }

        public Builder beingEmbeddedAs(AerospikeEmbed.EmbedType type) {
            EmbedConfig embedConfig = new EmbedConfig();
            embedConfig.setType(type);
            this.binConfig.setEmbed(embedConfig);
            return this.end();
        }

        public Builder beingEmbeddedAs(AerospikeEmbed.EmbedType type, AerospikeEmbed.EmbedType elementType) {
            EmbedConfig embedConfig = new EmbedConfig();
            embedConfig.setType(type);
            embedConfig.setElementType(elementType);
            this.binConfig.setEmbed(embedConfig);
            return this.end();
        }

        public Builder asGenerationField() {
            this.binConfig.setGeneration(true);
            return this.end();
        }

        public Builder beingEmbeddedAs(AerospikeEmbed.EmbedType type, AerospikeEmbed.EmbedType elementType, boolean saveKey) {
            EmbedConfig embedConfig = new EmbedConfig();
            embedConfig.setType(type);
            embedConfig.setElementType(elementType);
            embedConfig.setSaveKey(saveKey);
            this.binConfig.setEmbed(embedConfig);
            return this.end();
        }

        public Builder beingExcluded() {
            this.binConfig.setExclude(true);
            return this.end();
        }

        private Builder end() {
            this.builder.mergeBinConfig(this.binConfig);
            return this.builder;
        }
    }

    public static class Builder {
        private final Class<?> clazz;
        private final ClassConfig classConfig;

        public Builder(Class<?> clazz) {
            this.clazz = clazz;
            this.classConfig = new ClassConfig();
            this.classConfig.setClassName(clazz.getName());
        }

        private void validateFieldExists(String fieldName) {
            if (!ConfigurationUtils.validateFieldOnClass(this.clazz, fieldName)) {
                throw new AerospikeException(String.format("Field %s does not exist on class %s or its superclasses", fieldName, this.clazz));
            }
        }

        public Builder withNamespace(String namespace) {
            this.classConfig.setNamespace(namespace);
            return this;
        }

        public Builder withShortName(String shortName) {
            this.classConfig.setShortName(shortName);
            return this;
        }

        public Builder withSet(String setName) {
            this.classConfig.setSet(setName);
            return this;
        }

        public Builder withTtl(int ttl) {
            this.classConfig.setTtl(ttl);
            return this;
        }

        public Builder withVersion(int version) {
            this.classConfig.setVersion(version);
            return this;
        }

        public Builder withSendKey(boolean sendKey) {
            this.classConfig.setSendKey(sendKey);
            return this;
        }

        public Builder withMapAll(boolean mapAll) {
            this.classConfig.setMapAll(mapAll);
            return this;
        }

        public Builder withDurableDelete(boolean durableDelete) {
            this.classConfig.setDurableDelete(durableDelete);
            return this;
        }

        public Builder withShortName(boolean sendKey) {
            this.classConfig.setSendKey(sendKey);
            return this;
        }

        public Builder withFactoryClassAndMethod(@NotNull Class<?> factoryClass, @NotNull String factoryMethod) {
            this.classConfig.setFactoryClass(factoryClass.getName());
            this.classConfig.setFactoryMethod(factoryMethod);
            return this;
        }

        public Builder withKeyField(String fieldName) {
            if (this.classConfig.getKey() == null) {
                this.classConfig.setKey(new KeyConfig());
            }
            this.validateFieldExists(fieldName);
            this.classConfig.getKey().setField(fieldName);
            return this;
        }

        public Builder withKeyFieldAndStoreAsBin(String fieldName, boolean storeAsBin) {
            if (this.classConfig.getKey() == null) {
                this.classConfig.setKey(new KeyConfig());
            }
            this.validateFieldExists(fieldName);
            this.classConfig.getKey().setField(fieldName);
            this.classConfig.getKey().setStoreAsBin(storeAsBin);
            return this;
        }

        public Builder withKeyGetterAndSetterOf(String getterName, String setterName) {
            if (this.classConfig.getKey() == null) {
                this.classConfig.setKey(new KeyConfig());
            }
            this.classConfig.getKey().setGetter(getterName);
            this.classConfig.getKey().setSetter(setterName);
            return this;
        }

        public AeroBinConfig withFieldNamed(String fieldName) {
            this.validateFieldExists(fieldName);
            return new AeroBinConfig(this, fieldName);
        }

        private void mergeBinConfig(BinConfig config) {
            List<BinConfig> bins = this.classConfig.getBins();
            for (BinConfig thisBin : bins) {
                if (!config.getField().equals(thisBin.getField())) continue;
                thisBin.merge(config);
                return;
            }
            this.classConfig.getBins().add(config);
        }

        public ClassConfig build() {
            return this.classConfig;
        }
    }
}

