/*
 * Decompiled with CFR 0.152.
 */
package com.akaita.java.rxjava2debug;

import io.reactivex.annotations.NonNull;
import java.util.LinkedList;
import java.util.List;

class ExceptionUtils {
    ExceptionUtils() {
    }

    static Throwable setRootCause(@NonNull Throwable throwable, @NonNull Throwable rootCause) {
        if (throwable == null) {
            return null;
        }
        if (rootCause == null) {
            return throwable;
        }
        List<Throwable> causes = ExceptionUtils.listCauses(throwable);
        causes.add(rootCause);
        return ExceptionUtils.collapseCauses(causes);
    }

    @NonNull
    private static List<Throwable> listCauses(@NonNull Throwable throwable) {
        LinkedList<Throwable> causes = new LinkedList<Throwable>();
        for (Throwable cause = throwable.getCause(); cause != null && !causes.contains(cause); cause = cause.getCause()) {
            causes.add(cause);
        }
        return causes;
    }

    @NonNull
    private static Throwable collapseCauses(@NonNull List<Throwable> causes) {
        if (causes.size() == 0) {
            return new RuntimeException("Empty list of causes");
        }
        Throwable topThrowable = null;
        for (int i = causes.size() - 1; i >= 0; --i) {
            topThrowable = new Throwable(causes.get(i).getMessage(), topThrowable);
            if (causes.get(i).getStackTrace() == null) continue;
            topThrowable.setStackTrace(causes.get(i).getStackTrace());
        }
        return topThrowable;
    }
}

