/*
 * Decompiled with CFR 0.152.
 */
package com.akaita.java.rxjava2debug;

import com.akaita.java.rxjava2debug.ExceptionUtils;
import com.akaita.java.rxjava2debug.StackTraceUtils;
import hu.akarnokd.rxjava2.debug.RxJavaAssemblyException;
import hu.akarnokd.rxjava2.debug.RxJavaAssemblyTracking;
import io.reactivex.annotations.Nullable;

public class RxJava2Debug {
    @Nullable
    private static String[] basePackages;

    public static void enableRxJava2AssemblyTracking() {
        RxJava2Debug.enableRxJava2AssemblyTracking(null);
    }

    public static void enableRxJava2AssemblyTracking(@Nullable String[] basePackageNames) {
        basePackages = basePackageNames;
        RxJavaAssemblyTracking.enable();
        RxJava2Debug.setRxJavaAssemblyHandler();
    }

    public static void disableRxJava2AssemblyTracking() {
        RxJavaAssemblyTracking.disable();
    }

    @Nullable
    public static Throwable getEnhancedStackTrace(Throwable original) {
        Throwable enhanced = original;
        RxJavaAssemblyException assembledException = RxJavaAssemblyException.find(original);
        if (assembledException != null) {
            StackTraceElement[] clearStack = StackTraceUtils.parseStackTrace(assembledException, basePackages);
            Throwable clearException = new Throwable();
            clearException.setStackTrace(clearStack);
            enhanced = ExceptionUtils.setRootCause(original, clearException);
        }
        return enhanced;
    }

    private static void setRxJavaAssemblyHandler() {
        final Thread.UncaughtExceptionHandler previousDefaultHandler = Thread.getDefaultUncaughtExceptionHandler();
        Thread.setDefaultUncaughtExceptionHandler(new Thread.UncaughtExceptionHandler(){

            @Override
            public void uncaughtException(Thread t, Throwable e) {
                Throwable enhancedStackTrace = RxJava2Debug.getEnhancedStackTrace(e);
                if (enhancedStackTrace != null) {
                    previousDefaultHandler.uncaughtException(t, enhancedStackTrace);
                } else {
                    previousDefaultHandler.uncaughtException(t, e);
                }
            }
        });
    }
}

