/*
 * Decompiled with CFR 0.152.
 */
package com.akaita.java.rxjava2debug;

import hu.akarnokd.rxjava2.debug.RxJavaAssemblyException;
import io.reactivex.annotations.NonNull;
import io.reactivex.annotations.Nullable;
import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

class StackTraceUtils {
    private static final Pattern STACK_TRACE_ELEMENT_PATTERN = Pattern.compile("^at (.*)\\.(.*)\\((.*):([0-9]+)\\)$");
    private static final String NEW_LINE_REGEX = "\\n\\r|\\r\\n|\\n|\\r";

    StackTraceUtils() {
    }

    @NonNull
    static StackTraceElement[] parseStackTrace(@NonNull RxJavaAssemblyException exception, @Nullable String[] basePackages) {
        String[] lines = exception.stacktrace().split(NEW_LINE_REGEX);
        ArrayList<StackTraceElement> stackTrace = new ArrayList<StackTraceElement>();
        boolean filterIn = false;
        for (String line : lines) {
            StackTraceElement element;
            boolean bl = filterIn = filterIn || basePackages == null || basePackages.length == 0 || StackTraceUtils.startsWithAny(line, basePackages);
            if (!filterIn || (element = StackTraceUtils.parseStackTraceLine(line)) == null) continue;
            stackTrace.add(element);
        }
        return stackTrace.toArray(new StackTraceElement[0]);
    }

    static boolean startsWithAny(@NonNull String input, @NonNull String[] matchers) {
        for (String matcher : matchers) {
            if (!input.startsWith("at " + matcher) && !input.startsWith(matcher)) continue;
            return true;
        }
        return false;
    }

    @Nullable
    private static StackTraceElement parseStackTraceLine(@NonNull String stackTraceLine) {
        StackTraceElement retVal = null;
        Matcher matcher = STACK_TRACE_ELEMENT_PATTERN.matcher(stackTraceLine);
        if (matcher.matches()) {
            String clazz = matcher.group(1);
            String method = matcher.group(2);
            String filename = matcher.group(3);
            int line = Integer.valueOf(matcher.group(4));
            retVal = new StackTraceElement(clazz, method, filename, line);
        }
        return retVal;
    }
}

